/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.resolver;

import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pid.resolver.model.AbstractResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.SubjectType;
import eu.dnetlib.wds.resolver.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class WDSResolvedObject
extends AbstractResolvedObject {
    private List<PID> pids;
    private List<String> titles;
    private List<String> authors;
    private ObjectType type;
    private List<Project> projects;
    private List<Pair<String, String>> descriptions;
    private List<SubjectType> subjects;
    private Map<String, String> dates;
    private String publisher;
    private String license;
    private List<ObjectRelation> relations;

    public Map<String, String> getDates() {
        return this.dates;
    }

    public WDSResolvedObject setDates(Map<String, String> dates) {
        this.dates = dates;
        return this;
    }

    public WDSResolvedObject addProject(Project project) {
        if (this.projects == null) {
            this.projects = new ArrayList<Project>();
        }
        this.projects.add(project);
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public WDSResolvedObject setLicense(String license) {
        this.license = license;
        return this;
    }

    public WDSResolvedObject addPid(PID pid) {
        if (this.pids == null) {
            this.pids = new ArrayList<PID>();
            this.setPid(pid.getId()).setPidType(pid.getType());
        }
        this.pids.add(pid);
        return this;
    }

    public WDSResolvedObject addDate(String dateType, String dateValue) {
        if (this.dates == null) {
            this.dates = new HashMap<String, String>();
        }
        this.dates.put(dateType, dateValue);
        return this;
    }

    public WDSResolvedObject addTitle(String title) {
        if (this.titles == null) {
            this.titles = new ArrayList<String>();
        }
        this.titles.add(title);
        return this;
    }

    public WDSResolvedObject addDescription(Pair<String, String> description) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Pair<String, String>>();
        }
        this.descriptions.add(description);
        return this;
    }

    public WDSResolvedObject addSubject(SubjectType subject) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectType>();
        }
        this.subjects.add(subject);
        return this;
    }

    public WDSResolvedObject addAuthor(String author) {
        if (this.authors == null) {
            this.authors = new ArrayList<String>();
        }
        this.authors.add(author);
        return this;
    }

    public List<PID> getPids() {
        return this.pids;
    }

    public WDSResolvedObject setPids(List<PID> pids) {
        this.pids = pids;
        return this;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public WDSResolvedObject setTitles(List<String> titles) {
        this.titles = titles;
        return this;
    }

    public ObjectType getType() {
        return this.type;
    }

    public WDSResolvedObject setType(ObjectType type) {
        this.type = type;
        return this;
    }

    public List<ObjectRelation> getRelations() {
        return this.relations;
    }

    public WDSResolvedObject setRelations(List<ObjectRelation> relations) {
        this.relations = relations;
        return this;
    }

    public WDSResolvedObject addRelation(ObjectRelation relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<ObjectRelation>();
        }
        this.relations.add(relation);
        return this;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public WDSResolvedObject setProjects(List<Project> projects) {
        this.projects = projects;
        return this;
    }

    public List<Pair<String, String>> getDescriptions() {
        return this.descriptions;
    }

    public WDSResolvedObject setDescriptions(List<Pair<String, String>> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public WDSResolvedObject setAuthors(List<String> authors) {
        this.authors = authors;
        return this;
    }

    public List<SubjectType> getSubjects() {
        return this.subjects;
    }

    public WDSResolvedObject setSubjects(List<SubjectType> subjects) {
        this.subjects = subjects;
        return this;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getEscapedPublisher() {
        return StringEscapeUtils.escapeXml11((String)this.publisher);
    }

    public WDSResolvedObject setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public List<String> getEscapedXMLAuthors() {
        if (this.authors == null) {
            return this.authors;
        }
        return this.authors.stream().map(StringEscapeUtils::escapeXml11).collect(Collectors.toList());
    }

    public List<String> getEscapedXMLTitles() {
        if (this.titles == null) {
            return this.titles;
        }
        return this.titles.stream().map(StringEscapeUtils::escapeXml11).collect(Collectors.toList());
    }

    public List<String> getEscapedDescriptions() {
        if (this.descriptions == null) {
            return null;
        }
        return this.descriptions.stream().map(Pair::getValue).map(StringEscapeUtils::escapeXml11).collect(Collectors.toList());
    }

    public String toString() {
        return this.toJsonString();
    }
}

