package eu.dnetlib.wds.resolver;

import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;

public class WDSObjectRelation implements ObjectRelation {

    private String sourceRecordId;
    private PID sourcePID;
    private PID targetPID;
    private String relationSemantics;
    private String inverseRelation;
    private ObjectType targetType;


    @Override
    public String getSourceRecordId() {
        return sourceRecordId;
    }

    @Override
    public WDSObjectRelation setSourceRecordId(String sourceRecordId) {
        this.sourceRecordId = sourceRecordId;
        return this;
    }

    @Override
    public PID getSourcePID() {
        return sourcePID;
    }

    @Override
    public WDSObjectRelation setSourcePID(PID sourcePID) {
        this.sourcePID = sourcePID;
        return this;
    }

    @Override
    public PID getTargetPID() {
        return targetPID;
    }

    @Override
    public WDSObjectRelation setTargetPID(PID targetPID) {
        this.targetPID = targetPID;
        return this;
    }

    @Override
    public String getRelationSemantics() {
        return relationSemantics;
    }

    @Override
    public WDSObjectRelation setRelationSemantics(String relationSemantics) {
        this.relationSemantics = relationSemantics;
        return this;
    }

    @Override
    public String getInverseRelation() {
        return inverseRelation;
    }

    @Override
    public WDSObjectRelation setInverseRelation(String inverseRelation) {
        this.inverseRelation = inverseRelation;
        return this;
    }

    @Override
    public ObjectType getTargetType() {
        return targetType;
    }

    @Override
    public WDSObjectRelation setTargetType(ObjectType targetType) {
        this.targetType = targetType;
        return this;
    }
}
