/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.resolver.mdstore.plugin;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.AbstractRecordResolver;
import eu.dnetlib.pid.resolver.mdstore.plugin.ResolverSerializer;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.wds.parser.WDSParser;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import eu.dnetlib.wds.resolver.serializers.WDSResolverSerializer;
import eu.dnetlib.wds.utils.WDSUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringUtils;

public class WDSRecordResolver
extends AbstractRecordResolver {
    private final WDSParser parser = new WDSParser();

    public WDSRecordResolver(long ts) {
        super(ts);
    }

    public String resolve(String inputRecord) {
        boolean shouldUpdate;
        String newXML;
        WDSResolvedObject inputObject = (WDSResolvedObject)this.parser.parse(inputRecord);
        if (inputObject == null) {
            log.error((Object)("Error on parsing record the result is null, record: " + inputRecord));
            return null;
        }
        if (inputObject != null && !StringUtils.isBlank((CharSequence)inputObject.getPid())) {
            log.debug((Object)("trying to resolve " + inputObject.getPid()));
        }
        if ((newXML = this.resolveRelations(inputRecord, (ResolvedObject)inputObject, shouldUpdate = false)) != null) {
            return newXML;
        }
        return null;
    }

    protected Map<String, ObjectType> tryToResolveRelation(PID currentPid) {
        if (currentPid.getId() != null && currentPid.getId().contains("wds_resolver")) {
            return null;
        }
        log.debug((Object)("tryToResolveRelation " + currentPid));
        for (PIDResolver resolver : this.pluginResolver) {
            WDSResolvedObject currentIdentifier = (WDSResolvedObject)resolver.retrievePID(currentPid.getId(), currentPid.getType(), this.offline);
            if (currentIdentifier == null || StringUtils.isBlank((CharSequence)currentIdentifier.getPid()) || !currentIdentifier.getPid().toLowerCase().equals(currentPid.getId().toLowerCase())) continue;
            HashMap<String, ObjectType> result = new HashMap<String, ObjectType>();
            result.put("wds_resolver::" + WDSUtils.generateIdentifier((String)currentIdentifier.getPid(), (String)currentIdentifier.getPidType()), currentIdentifier.getType());
            return result;
        }
        return null;
    }

    public void setPluginResolver(List<PIDResolver> pluginResolver) {
        this.pluginResolver = pluginResolver;
    }

    public BlockingQueue<DBObject> getInputQueue() {
        return this.inputQueue;
    }

    public void setInputQueue(BlockingQueue<DBObject> inputQueue) {
        this.inputQueue = inputQueue;
    }

    public MongoCollection<DBObject> getOutputCollection() {
        return this.outputCollection;
    }

    public void setOutputCollection(MongoCollection<DBObject> outputCollection) {
        this.outputCollection = outputCollection;
    }

    public void setSerializer(ResolverSerializer serializer) {
        WDSResolverSerializer tmp = new WDSResolverSerializer();
        tmp.setPmfTemplate(new StringTemplate(((WDSResolverSerializer)serializer).getPmfTemplate().getTemplate()));
        tmp.setDmfTemplate(new StringTemplate(((WDSResolverSerializer)serializer).getDmfTemplate().getTemplate()));
        this.serializer = tmp;
    }
}

