package eu.dnetlib.wds.collector.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringEscapeUtils;

/**
 * Created by sandro on 6/21/16.
 */
public class CMRObject {

	private List<List<String>> polygons;
	private List<CMRRelation> links = new ArrayList<>();
	private String time_end;
	private String original_format;
	private String data_center;
	private String dataset_id;
	private String time_start;
	private String title;
	private String id;
	private String short_name;
	private List<String> boxes;
	private List<String> organizations;
	private String coordinate_system;
	private String summary;
	private String updated;
	private String points;

	public static CMRRelation newRelation() {
		return new CMRObject().new CMRRelation();
	}

	public List<List<String>> getPolygons() {
		return polygons;
	}

	public void setPolygons(final List<List<String>> polygons) {
		this.polygons = polygons;
	}

	public List<CMRRelation> getLinks() {
		return links;
	}

	public void setLinks(final List<CMRRelation> links) {
		this.links = links;
	}

	public String getTime_end() {
		return time_end;
	}

	public void setTime_end(final String time_end) {
		this.time_end = time_end;
	}

	public String getOriginal_format() {
		return original_format;
	}

	public void setOriginal_format(final String original_format) {
		this.original_format = original_format;
	}

	public String getData_center() {
		return data_center;
	}

	public void setData_center(final String data_center) {
		this.data_center = data_center;
	}

	public String getDataset_id() {
		return dataset_id;
	}

	public void setDataset_id(final String dataset_id) {
		this.dataset_id = dataset_id;
	}

	public String getTime_start() {
		return time_start;
	}

	public void setTime_start(final String time_start) {
		this.time_start = time_start;
	}

	public String getTitle() {
		if (title != null) {
			return StringEscapeUtils.escapeXml10(title);
		}

		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getShort_name() {
		return short_name;
	}

	public void setShort_name(final String short_name) {
		this.short_name = short_name;
	}

	public List<String> getBoxes() {
		return boxes;
	}

	public void setBoxes(final List<String> boxes) {
		this.boxes = boxes;
	}

	public List<String> getOrganizations() {
		if (organizations != null) return organizations.stream().map(it -> StringEscapeUtils.escapeXml11(it)).collect(Collectors.toList());
		return null;
	}

	public void setOrganizations(final List<String> organizations) {
		this.organizations = organizations;
	}

	public String getCoordinate_system() {
		return coordinate_system;
	}

	public void setCoordinate_system(final String coordinate_system) {
		this.coordinate_system = coordinate_system;
	}

	public String getSummary() {
		return StringEscapeUtils.escapeXml11(summary);
	}

	public void setSummary(final String summary) {
		this.summary = summary;
	}

	public String getPoints() {
		return points;
	}

	public void setPoints(final String points) {
		this.points = points;
	}

	public String getUpdated() {
		return updated;
	}

	public void setUpdated(final String updated) {
		this.updated = updated;
	}

	public class CMRRelation {

		private String id;

		private String relation;

		private String title;

		private String hreflang;

		private String href;

		public String getId() {
			return id;
		}

		public void setId(final String id) {
			this.id = id;
		}

		public String getRelation() {
			return relation;
		}

		public void setRelation(final String relation) {
			this.relation = relation;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(final String title) {
			this.title = title;
		}

		public String getHreflang() {
			return hreflang;
		}

		public void setHreflang(final String hreflang) {
			this.hreflang = hreflang;
		}

		public String getHref() {
			return href;
		}

		public void setHref(final String href) {
			this.href = href;
		}
	}
}
