/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.parser;

import com.google.common.collect.Lists;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import eu.dnetlib.wds.resolver.WDSObjectRelation;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import eu.dnetlib.wds.utils.WDSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DMFResolverParser
extends AbstractResolverParser {
    private static final Log log = LogFactory.getLog(DMFResolverParser.class);

    public ResolvedObject parseObject(String record) {
        try {
            List dates;
            String type;
            List resourceTypeGeneral;
            List descriptions;
            List titles;
            List identifierType;
            WDSResolvedObject parsedObject = new WDSResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            ap.declareXPathNameSpace("dri", "http://www.driver-repository.eu/namespace/dri");
            String datasourcePrefix = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//dri:datasourceprefix");
            ap.declareXPathNameSpace("oaf", "http://namespace.dnet.eu/oaf");
            ObjectProvenance provenance = new ObjectProvenance();
            provenance.setDatasourceId(WDSUtils.getIdFromDataSourcePrefix((String)datasourcePrefix));
            provenance.setDatasource(WDSUtils.getNameFromDataSourcePrefix((String)datasourcePrefix));
            parsedObject.setDatasourceProvenance(Arrays.asList(provenance));
            String publisher = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='publisher']");
            if (StringUtils.isNotEmpty((CharSequence)publisher)) {
                parsedObject.setPublisher(publisher);
            }
            if (this.extractIdentifier((ResolvedObject)parsedObject, identifierType = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='identifier']", (List)Lists.newArrayList((Object[])new String[]{"identifierType"})))) {
                return null;
            }
            List relations = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='relatedIdentifier']", Arrays.asList("relatedIdentifierType", "relationType", "inverseRelationType"));
            if (relations != null && relations.size() > 0) {
                ArrayList<ObjectRelation> relationsResult = new ArrayList<ObjectRelation>();
                relations.forEach(relationMap -> {
                    String relationType = (String)relationMap.getAttributes().get("relationType");
                    String inverseRelationType = (String)relationMap.getAttributes().get("inverseRelationType");
                    String relatedIdentifierType = (String)relationMap.getAttributes().get("relatedIdentifierType");
                    String relatedPid = relationMap.getTextValue();
                    WDSObjectRelation currentRelation = new WDSObjectRelation();
                    currentRelation.setTargetPID(this.inferPid(new PID(relatedPid, relatedIdentifierType)));
                    currentRelation.setRelationSemantics(relationType);
                    currentRelation.setInverseRelation(inverseRelationType);
                    relationsResult.add(currentRelation);
                });
                parsedObject.setRelations(relationsResult);
            }
            List subjects = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='subject']", Arrays.asList("subjectScheme"));
            this.extractSubject((ResolvedObject)parsedObject, subjects);
            List creators = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='creator']/*[local-name()='creatorName']");
            if (creators != null && creators.size() > 0) {
                parsedObject.setAuthors(creators);
            }
            if ((titles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='title']")) != null && titles.size() > 0) {
                parsedObject.setTitles(titles);
            }
            if ((descriptions = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']//*[local-name()='description']")) != null && descriptions.size() > 0) {
                parsedObject.setDescriptions(descriptions.stream().map(it -> new Pair((Object)"unknwonw", it)).collect(Collectors.toList()));
            }
            if ((resourceTypeGeneral = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='resourceType']", Arrays.asList("resourceTypeGeneral"))) != null && !resourceTypeGeneral.isEmpty()) {
                type = (String)((VtdUtilityParser.Node)resourceTypeGeneral.get(0)).getAttributes().get("resourceTypeGeneral");
                this.setType((ResolvedObject)parsedObject, type);
            }
            if (parsedObject.getType() == ObjectType.unknown) {
                type = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='resourceType']");
                this.setType((ResolvedObject)parsedObject, type);
            }
            if ((dates = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resource']/*[local-name()='dates']/*[local-name()='date']")) != null && dates.size() > 0) {
                dates.forEach(it -> parsedObject.addDate("unknown", (String)it));
            }
            return parsedObject;
        }
        catch (Throwable e) {
            log.error((Object)("Error on parsing record " + record), e);
            return null;
        }
    }
}

