<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs"
                version="2.0">
	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">
		<record>
			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<ROW table="datasources">
						<FIELD name="id">
							<xsl:value-of select="concat($namespacePrefix,'::', //datasource/id)"/>
						</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($namespacePrefix,'::', //datasource/id)"/>
						</FIELD>
						<FIELD name="officialname">
							<xsl:value-of select="//datasource/name"/>
						</FIELD>
						<FIELD name="englishname">
							<xsl:value-of select="//datasource/name"/>
						</FIELD>
						<FIELD name="od_contenttypes">dataset</FIELD>
						<FIELD name="websiteurl">
							<xsl:value-of select="//datasource/url"/>
						</FIELD>
						<FIELD name="namespaceprefix">
							<xsl:value-of select="concat('cmr_',substring(//datasource/uuid,1,8))"/>
						</FIELD>
						<FIELD name="datasourceclass">datarepository::unknown</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
					</ROW>
					<ROW table="hostedby_map">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat(//datasource/id,'@@',$parentDatasourceId )"/>
						</FIELD>
						<FIELD name="oa_source_id">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="entry">
							<xsl:value-of select="//datasource/id"/>
						</FIELD>
						<FIELD name="datasourceid">
							<xsl:value-of select="concat($namespacePrefix,'::', //datasource/id)"/>
						</FIELD>
						<FIELD name="key_type">CMR Datasources</FIELD>
					</ROW>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>