/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.nodes;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.wds.collector.plugins.GenericDatasource;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SaveRepositoryProfileJobNode
extends SimpleJobNode {
    static final String query = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') where $x//DATASOURCE_ORIGINAL_ID/text() ='%s' return $x//RESOURCE_IDENTIFIER/@value/string()";
    private static final Log log = LogFactory.getLog(SaveRepositoryProfileJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String inputEprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private StringTemplate xmlTemplate;

    protected String execute(Env env) throws Exception {
        ISRegistryService registryService = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        Iterable profiles = this.resultSetClient.iter(rsIn, String.class);
        Gson g = new Gson();
        if (profiles != null) {
            profiles.forEach(it -> {
                GenericDatasource ds = (GenericDatasource)g.fromJson(it, GenericDatasource.class);
                this.xmlTemplate.removeAttribute("datasource");
                this.xmlTemplate.setAttribute("datasource", (Object)ds);
                String currentProfile = this.xmlTemplate.toString();
                try {
                    List resourceIds = lookUpService.quickSearchProfile(String.format(query, ds.getId()));
                    if (resourceIds != null && resourceIds.size() > 0) {
                        registryService.updateProfile((String)resourceIds.get(0), currentProfile, "RepositoryServiceResourceType");
                    } else {
                        registryService.registerProfile(currentProfile);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error on saving profile " + it), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public StringTemplate getXmlTemplate() {
        return this.xmlTemplate;
    }

    @Required
    public void setXmlTemplate(StringTemplate xmlTemplate) {
        this.xmlTemplate = xmlTemplate;
    }
}

