package eu.dnetlib.wds.collector.plugins;

import org.apache.commons.lang3.StringEscapeUtils;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by sandro on 7/18/16.
 */
public class GenericDatasource {

	private String id;

	private String name;

	private String url;

    private final Map<String, String> extrafields = new HashMap<>();
    private String namespacePrefix;
    private String dateOfCreation;

	public String getId() {
		return StringEscapeUtils.escapeXml11(id);
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return StringEscapeUtils.escapeXml11(name);
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getUrl() {
		return StringEscapeUtils.escapeXml11(url);
	}

	public void setUrl(final String url) {
		this.url = url;
	}

    public String getNamespacePrefix() {
        return namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public Map<String, String> getExtrafields() {
        return extrafields;
    }

    public String getDateOfCreation() {
        final LocalDateTime ldt = LocalDateTime.now();
        final ZonedDateTime zdt = ldt.atZone(ZoneOffset.UTC);
        return zdt.toString();
    }

}
