/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.resolver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.SubjectType;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class DLIResolver
extends AbstractPIDResolver {
    private static String INDEX_URL = "http://ip-90-147-167-27.ct1.garrservices.it:9200/dli_shadow/object/_search?pretty";

    protected boolean canResolvePid(String pidType) {
        return StringUtils.isNotEmpty((CharSequence)pidType);
    }

    public WDSResolvedObject resolve(String pid, String pidType) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity jsonObjectResponseEntity = restTemplate.postForEntity(INDEX_URL, (Object)this.createJson(pid, pidType), JsonObject.class, new Object[0]);
        JsonObject hits = ((JsonObject)jsonObjectResponseEntity.getBody()).getAsJsonObject("hits");
        int total = hits.get("total").getAsInt();
        if (total > 0) {
            JsonArray results = hits.getAsJsonArray("hits");
            return this.parseDLIResponse(results.get(0).getAsJsonObject());
        }
        return null;
    }

    private WDSResolvedObject parseDLIResponse(JsonObject input) {
        JsonArray publisherArray;
        JsonArray subjectArray;
        String description;
        WDSResolvedObject result = new WDSResolvedObject();
        JsonObject source = input.getAsJsonObject("_source");
        if (source == null || source.isJsonNull()) {
            return null;
        }
        JsonArray localIdentifiers = source.getAsJsonArray("localIdentifier");
        if (localIdentifiers == null || localIdentifiers.isJsonNull()) {
            return null;
        }
        localIdentifiers.forEach(it -> result.addPid(new PID(it.getAsJsonObject().get("id").getAsString(), it.getAsJsonObject().get("type").getAsString())));
        String typology = source.get("typology").getAsString();
        if (!typology.equals("publication") && !typology.equals("dataset")) {
            return null;
        }
        result.setType(ObjectType.valueOf((String)typology));
        result.setTitles(this.getArrayFromJson("title", source));
        result.setAuthors(this.getArrayFromJson("author", source));
        List<String> date = this.getArrayFromJson("date", source);
        HashMap<String, String> d = new HashMap<String, String>();
        if (date != null && date.size() > 0) {
            d.put("unknown", date.get(0));
        }
        result.setDates(d);
        String string = description = source.get("abstract") != null ? source.get("abstract").getAsString() : null;
        if (description != null && StringUtils.isNotEmpty((CharSequence)description)) {
            result.addDescription((Pair<String, String>)new Pair((Object)"unknown", (Object)description));
        }
        if ((subjectArray = source.getAsJsonArray("subject")) != null && !subjectArray.isJsonNull()) {
            subjectArray.forEach(it -> result.addSubject(new SubjectType(it.getAsJsonObject().get("scheme").getAsString(), it.getAsJsonObject().get("value").getAsString())));
        }
        if ((publisherArray = source.getAsJsonArray("publisher")) != null && !publisherArray.isJsonNull()) {
            publisherArray.forEach(it -> result.setPublisher(it.getAsString()));
        }
        result.setDatasourceProvenance(Collections.singletonList(new ObjectProvenance().setDatasource("Data Literature Interlinking").setDatasourceId("wds_________::dli")));
        return result;
    }

    private List<String> getArrayFromJson(String key, JsonObject source) {
        ArrayList<String> result = new ArrayList<String>();
        JsonArray inputArray = source.getAsJsonArray(key);
        if (inputArray != null && !inputArray.isJsonNull()) {
            inputArray.forEach(it -> {
                if (StringUtils.isNotEmpty((CharSequence)it.getAsString())) {
                    result.add(it.getAsString());
                }
            });
        }
        return result;
    }

    private JsonObject createJson(String pid, String pidType) {
        JsonObject root = new JsonObject();
        JsonObject nested = new JsonObject();
        JsonObject n1 = new JsonObject();
        JsonObject nestedQuery = new JsonObject();
        JsonObject boolQuery = new JsonObject();
        JsonArray mustArray = new JsonArray();
        JsonObject firstMatch = new JsonObject();
        JsonObject firstMatchId = new JsonObject();
        JsonObject secondMatch = new JsonObject();
        JsonObject secondMatchType = new JsonObject();
        root.add("query", (JsonElement)n1);
        n1.add("nested", (JsonElement)nested);
        nested.addProperty("path", "localIdentifier");
        nested.add("query", (JsonElement)nestedQuery);
        nestedQuery.add("bool", (JsonElement)boolQuery);
        boolQuery.add("must", (JsonElement)mustArray);
        mustArray.add((JsonElement)firstMatch);
        mustArray.add((JsonElement)secondMatch);
        firstMatch.add("match", (JsonElement)firstMatchId);
        secondMatch.add("match", (JsonElement)secondMatchType);
        firstMatchId.addProperty("localIdentifier.id", pid.toLowerCase().trim());
        secondMatchType.addProperty("localIdentifier.type", pidType.toLowerCase().trim());
        return root;
    }
}

