/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.parser;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import eu.dnetlib.wds.resolver.WDSObjectRelation;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PMFResolverParser
extends AbstractResolverParser {
    public ResolvedObject parseObject(String record) {
        try {
            WDSResolvedObject parsedObject = new WDSResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            ap.declareXPathNameSpace("dri", "http://www.driver-repository.eu/namespace/dri");
            String resolvedDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//dri:resolvedDate");
            ap.declareXPathNameSpace("oaf", "http://namespace.dnet.eu/oaf");
            List pid = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:pid", Arrays.asList("type"));
            if (pid == null || pid.size() <= 0) {
                return null;
            }
            String currentPid = ((VtdUtilityParser.Node)pid.get(0)).getTextValue();
            String currentPidType = (String)((VtdUtilityParser.Node)pid.get(0)).getAttributes().get("type");
            parsedObject.setPid(currentPid);
            parsedObject.setPidType(currentPidType);
            List collectedFromNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:collectedFrom", Arrays.asList("name", "id", "mode", "completionStatus"));
            List relatedIdentifiers = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//oaf:relatedIdentifier", Arrays.asList("relatedIdentifierType", "relationType", "entityType", "inverseRelationType"));
            if (relatedIdentifiers != null && relatedIdentifiers.size() > 0) {
                ArrayList<ObjectRelation> relations = new ArrayList<ObjectRelation>();
                relatedIdentifiers.forEach(relation -> {
                    String currentPid = relation.getTextValue();
                    String currentPidType = (String)relation.getAttributes().get("relatedIdentifierType");
                    String currentType = (String)relation.getAttributes().get("entityType");
                    WDSObjectRelation currentRelation = new WDSObjectRelation();
                    currentRelation.setTargetPID(this.inferPid(new PID(currentPid, currentPidType)));
                    currentRelation.setSourcePID(this.inferPid(new PID(parsedObject.getPid(), parsedObject.getPidType())));
                    currentRelation.setRelationSemantics((String)relation.getAttributes().get("relationType"));
                    currentRelation.setInverseRelation((String)relation.getAttributes().get("inverseRelationType"));
                    currentRelation.setTargetType(ObjectType.valueOf((String)currentType));
                    relations.add(currentRelation);
                });
                parsedObject.setRelations(relations);
            }
            ap.declareXPathNameSpace("dc", "http://purl.org/dc/elements/1.1/");
            List authorsNode = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//dc:creator");
            parsedObject.setAuthors(authorsNode);
            parsedObject.setTitles(VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//dc:title"));
            parsedObject.addDescription((Pair<String, String>)new Pair((Object)"unknown", (Object)VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//dc:description")));
            parsedObject.addDate("unknown", VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//dc:date"));
            List subjects = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//dc:subject", Arrays.asList("scheme"));
            if (subjects != null && subjects.size() > 0) {
                ArrayList<SubjectType> currentSubjects = new ArrayList<SubjectType>();
                subjects.forEach(it -> {
                    String scheme = (String)it.getAttributes().get("scheme");
                    if (scheme == null) {
                        scheme = "unknown";
                    }
                    currentSubjects.add(new SubjectType(scheme, it.getTextValue()));
                });
                parsedObject.setSubjects(currentSubjects);
            }
            this.setType((ResolvedObject)parsedObject, VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//dc:type"));
            return parsedObject;
        }
        catch (Throwable e) {
            log.debug((Object)("Input record: " + record));
            log.error((Object)"Error on parsing record ", e);
            return null;
        }
    }
}

