package eu.dnetlib.wds.collector.plugins;

import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Required;

/**
 * Created by sandro on 5/27/16.
 */
public class CMRCollectorPlugin extends AbstractCollectorPlugin {

	private StringTemplate xmlTemplate;





	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {
		return () -> DnetStreamSupport.generateStreamFromIterator(new CMRIterator())
				.map(it -> {
					xmlTemplate.reset();
					xmlTemplate.setAttribute("object", it);
					return xmlTemplate.toString();
				}).iterator();

	}

	public StringTemplate getXmlTemplate() {
		return xmlTemplate;
	}

	@Required
	public void setXmlTemplate(final StringTemplate xmlTemplate) {
		this.xmlTemplate = xmlTemplate;
	}

}
