package eu.dnetlib.wds.collector.plugins;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.google.gson.*;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by sandro on 5/27/16.
 */
public class CMRIterator implements Iterator<CMRObject> {

	private final static String BASE_URL_PAGE = "https://cmr.earthdata.nasa.gov/search/collections.json?pretty=true&page_size=50&page_num=%d";

	private static final Log log = LogFactory.getLog(CMRIterator.class);

	private int current_page = 1;

	private CMRObject nextElement = null;

	private List<CMRObject> buffer = new ArrayList<>();

	private Gson gson = null;

	public CMRIterator() {

		GsonBuilder builder = new GsonBuilder();
		builder.registerTypeAdapter(CMRObject.class, new CMRObjectDeserializer());
		gson = builder.create();
		calculateNextElement();
	}

	private void calculateNextElement() {
		try {
			final URL myURL = new URL(String.format(BASE_URL_PAGE, current_page));

			final String result = IOUtils.toString(myURL.openStream());

			JsonElement element = new JsonParser().parse(result);
			final JsonArray asJsonArray = element.getAsJsonObject().get("feed").getAsJsonObject().get("entry").getAsJsonArray();

			if (asJsonArray.size() > 0) {
				for (JsonElement el : asJsonArray) {

					final CMRObject resultObj = gson.fromJson(el.toString(), CMRObject.class);


                    buffer.add(resultObj);
				}
				current_page++;
				return;
			}

		} catch (Throwable e) {
			log.error(String.format("Error on calculate next Element, The iterator will be shut down"), e);

		}

		this.nextElement = null;

	}

	@Override
	public boolean hasNext() {
		return this.buffer.size() > 0;
	}

	@Override
	public CMRObject next() {
		final CMRObject temp = buffer.remove(0);
		if (buffer.size() < 10) {
			calculateNextElement();
		}
		return temp;
	}
}
