/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.resolver;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import eu.dnetlib.wds.resolver.Project;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenAireParser
extends AbstractResolverParser {
    private static final Log log = LogFactory.getLog(OpenAireParser.class);

    public WDSResolvedObject parseObject(String record) {
        try {
            List resutlTypes;
            List descriptions;
            List authorNodes;
            List titles;
            WDSResolvedObject currentObject = new WDSResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            ap.declareXPathNameSpace("oaf", "http://namespace.openaire.eu/oaf");
            List subjectNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='result']//*[local-name()='subject']", Arrays.asList("classname", "schemename"));
            if (subjectNodes != null && subjectNodes.size() > 0) {
                ArrayList<SubjectType> currentSubjects = new ArrayList<SubjectType>();
                subjectNodes.forEach(it -> currentSubjects.add(new SubjectType((String)it.getAttributes().get("schemename"), it.getTextValue())));
                currentObject.setSubjects(currentSubjects);
            }
            if ((titles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='result']/*[local-name()='title']")) != null && titles.size() > 0) {
                currentObject.setTitles(titles);
            }
            if ((authorNodes = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='result']//*[local-name()='fullname']")) != null && authorNodes.size() > 0) {
                currentObject.setAuthors(authorNodes);
            }
            if ((descriptions = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='result']//*[local-name()='description']")) != null && descriptions.size() > 0) {
                descriptions.forEach(d -> currentObject.addDescription((Pair<String, String>)new Pair((Object)"unknown", d)));
            }
            if ((resutlTypes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='result']/*[local-name()='resulttype']", Arrays.asList("classid"))) != null && resutlTypes.size() > 0) {
                String type = (String)((VtdUtilityParser.Node)resutlTypes.get(0)).getAttributes().get("classid");
                this.setType((ResolvedObject)currentObject, type);
            }
            ap.selectXPath("//*[local-name()='rel'][./to/@type='project']");
            while (ap.evalXPath() != -1) {
                List projectTitles = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"./title");
                List projectAcronym = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"./acronym");
                List projectCodes = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"./code");
                List funderNames = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)".//funder", Arrays.asList("name"));
                List projectfundings = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)".//*[starts-with(name(), 'funding_level_')]");
                String funderName = funderNames != null ? (String)((VtdUtilityParser.Node)funderNames.stream().findFirst().get()).getAttributes().get("name") : "";
                String funding = projectfundings.size() > 0 ? (String)projectfundings.get(projectfundings.size() - 1) : "";
                funding = funding.length() > 2 ? funding.substring(funding.indexOf("::") + 2) : "";
                currentObject.addProject(new Project().setAcronym(projectAcronym != null && projectAcronym.size() > 0 ? (String)projectAcronym.get(0) : "").setFundingStream(funding).setFunder(funderName).setGrantID((String)projectCodes.get(0)).setName((String)projectTitles.get(0)));
            }
            return currentObject;
        }
        catch (Throwable e) {
            log.error((Object)"Error on parsing object ", e);
            return null;
        }
    }
}

