/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.resolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.wds.resolver.OpenAireParser;
import eu.dnetlib.wds.resolver.WDSResolvedObject;
import java.net.URLEncoder;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenAireResolver
extends AbstractPIDResolver {
    private static final String templateURL = "pid:\"%s\"";
    private static final String OPENAIRE_NS_PREFIX = "openaire____";
    private static final String baseURL = "http://solr.openaire.eu:8983/solr/DMF-index-openaire_shard1_replica1/select?q=%s&wt=json";
    private static final Log log = LogFactory.getLog(OpenAireResolver.class);
    private final OpenAireParser parser = new OpenAireParser();

    protected boolean canResolvePid(String pidType) {
        return pidType != null && pidType.toLowerCase().equals("doi");
    }

    protected WDSResolvedObject resolve(String pid, String pidType) {
        try {
            String currentQuery = String.format(baseURL, URLEncoder.encode(String.format(templateURL, pid), "UTF-8"));
            WDSResolvedObject obj = this.parsingResponse(OpenAireResolver.requestURL((String)currentQuery));
            if (obj == null) {
                return null;
            }
            obj.setPidType(pidType);
            obj.setPid(pid);
            return obj;
        }
        catch (Throwable e) {
            log.error((Object)("Error on resolve pid " + pid), e);
            return null;
        }
    }

    private WDSResolvedObject parsingResponse(String response) {
        if (response == null) {
            return null;
        }
        JsonElement jElement = new JsonParser().parse(response);
        JsonObject jobject = jElement.getAsJsonObject();
        if (jobject.has("response")) {
            long total = jobject.get("response").getAsJsonObject().get("numFound").getAsLong();
            if (total == 0L) {
                return null;
            }
            JsonArray hits = ((JsonObject)jobject.get("response")).get("docs").getAsJsonArray();
            JsonElement s = ((JsonObject)hits.get(0)).get("__result").getAsJsonArray().get(0);
            WDSResolvedObject resolvedObject = this.parser.parseObject(s.getAsString());
            resolvedObject.setRelations(Lists.newArrayList());
            ObjectProvenance op = new ObjectProvenance();
            op.setDatasource("OpenAIRE");
            op.setDatasourceId("wds_________::openaire");
            resolvedObject.setDatasourceProvenance(Collections.singletonList(op));
            return resolvedObject;
        }
        return null;
    }
}

