package eu.dnetlib.wds.collector.plugins;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.*;
import eu.dnetlib.wds.collector.plugins.CMRObject.CMRRelation;

/**
 * Created by sandro on 6/21/16.
 */
public class CMRObjectDeserializer implements JsonDeserializer<CMRObject> {

	@Override
	public CMRObject deserialize(final JsonElement jsonElement, final Type type, final JsonDeserializationContext jsonDeserializationContext)
			throws JsonParseException {

		final CMRObject result = new CMRObject();

		final JsonObject root = jsonElement.getAsJsonObject();

		if (root.has("polygons")) {
			JsonArray polygons = root.getAsJsonArray("polygons");
			List<List<String>> polygonsList = new ArrayList<>();
			for (JsonElement elem : polygons) {
				JsonArray polygon = elem.getAsJsonArray();
				List<String> currentPolygon = new ArrayList<>();
				for (JsonElement polygonItem : polygon) {
					currentPolygon.add(polygonItem.getAsString());
				}
				polygonsList.add(currentPolygon);
			}
			result.setPolygons(polygonsList);
		}

		result.setLinks(getListOfRelation(root, "links"));

		result.setTime_end(getSingleItem(root, "time_end"));
		result.setTitle(getSingleItem(root, "title"));
		result.setOriginal_format(getSingleItem(root, "original_format"));
		result.setTime_start(getSingleItem(root, "time_start"));
        result.setData_center(getSingleItem(root, "archive_center"));
        result.setDataset_id(getSingleItem(root, "dataset_id"));
		result.setId(getSingleItem(root, "id"));
		result.setShort_name(getSingleItem(root, "short_name"));
		result.setBoxes(getListOfItem(root, "boxes"));
		result.setOrganizations(getListOfItem(root, "organizations"));
		result.setCoordinate_system(getSingleItem(root, "coordinate_system"));
		result.setSummary(getSingleItem(root, "summary"));
		result.setPoints(getSingleItem(root, "points"));
		result.setUpdated(getSingleItem(root, "updated"));
		return result;
	}

	private String getSingleItem(final JsonObject root, final String key) {
		if (root.has(key)) {
			return root.get(key).getAsString();
		}
		return null;
	}

	private List<String> getListOfItem(final JsonObject root, final String key) {
		if (root.has(key)) {

			JsonArray jsonList = root.getAsJsonArray(key);
			List<String> resultList = new ArrayList<>();
			for (JsonElement elem : jsonList) {
				final String currentItem = elem.getAsString().trim();
				resultList.add(currentItem);
			}
			return resultList;
		}
		return null;
	}

	private List<CMRObject.CMRRelation> getListOfRelation(final JsonObject root, final String key) {
		if (root.has(key)) {

			JsonArray jsonList = root.getAsJsonArray(key);
			List<CMRRelation> resultList = new ArrayList<>();
			for (JsonElement elem : jsonList) {
				CMRRelation rel = CMRObject.newRelation();
				JsonObject currentObject = elem.getAsJsonObject();
				rel.setHreflang(currentObject.get("hreflang").getAsString());
				rel.setHref(currentObject.get("href").getAsString());
				if (currentObject.has("title"))
					rel.setTitle(currentObject.get("title").getAsString());
				rel.setId(currentObject.get("rel").getAsString());

				resultList.add(rel);
			}
			return resultList;
		}
		return null;
	}

}
