package eu.dnetlib.wds.resolver;

import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pid.resolver.model.*;
import org.apache.commons.lang3.StringEscapeUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


public class WDSResolvedObject extends AbstractResolvedObject {


    private List<PID> pids;
    private List<String> titles;
    private List<String> authors;
    private ObjectType type;
    private List<Project> projects;
    private List<Pair<String, String>> descriptions;
    private List<SubjectType> subjects;
    private Map<String, String> dates;
    private String publisher;
    private String license;
    private List<ObjectRelation> relations;


    public Map<String, String> getDates() {
        return dates;
    }

    public WDSResolvedObject setDates(Map<String, String> dates) {
        this.dates = dates;
        return this;
    }

    public WDSResolvedObject addProject(final Project project) {
        if (this.projects == null)
            this.projects = new ArrayList<>();
        projects.add(project);
        return this;
    }

    public String getLicense() {
        return license;
    }

    public WDSResolvedObject setLicense(String license) {
        this.license = license;
        return this;
    }

    public WDSResolvedObject addPid(final PID pid) {
        if (this.pids == null) {
            this.pids = new ArrayList<>();
            this.setPid(pid.getId()).setPidType(pid.getType());
        }
        pids.add(pid);
        return this;
    }

    public WDSResolvedObject addDate(final String dateType, final String dateValue) {
        if (dates == null)
            dates = new HashMap<>();
        dates.put(dateType, dateValue);
        return this;
    }

    public WDSResolvedObject addTitle(final String title) {
        if (this.titles == null)
            this.titles = new ArrayList<>();
        titles.add(title);
        return this;
    }

    public WDSResolvedObject addDescription(final Pair<String, String> description) {
        if (this.descriptions == null)
            this.descriptions = new ArrayList<>();
        descriptions.add(description);
        return this;
    }

    public WDSResolvedObject addSubject(final SubjectType subject) {
        if (this.subjects == null)
            this.subjects = new ArrayList<>();
        subjects.add(subject);
        return this;
    }

    public WDSResolvedObject addAuthor(final String author) {
        if (this.authors == null)
            this.authors = new ArrayList<>();
        authors.add(author);
        return this;
    }


    public List<PID> getPids() {
        return pids;
    }

    public WDSResolvedObject setPids(List<PID> pids) {
        this.pids = pids;
        return this;
    }

    public List<String> getTitles() {
        return titles;
    }

    public WDSResolvedObject setTitles(List<String> titles) {
        this.titles = titles;
        return this;
    }

    public ObjectType getType() {
        return type;
    }

    public WDSResolvedObject setType(ObjectType type) {
        this.type = type;
        return this;
    }

    @Override
    public List<ObjectRelation> getRelations() {
        return this.relations;
    }


    public WDSResolvedObject setRelations(List<ObjectRelation> relations) {
        this.relations = relations;
        return this;
    }

    public WDSResolvedObject addRelation(ObjectRelation relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<>();
        }
        this.relations.add(relation);
        return this;
    }

    public List<Project> getProjects() {
        return projects;
    }

    public WDSResolvedObject setProjects(List<Project> projects) {
        this.projects = projects;
        return this;
    }

    public List<Pair<String, String>> getDescriptions() {
        return descriptions;
    }

    public WDSResolvedObject setDescriptions(List<Pair<String, String>> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public List<String> getAuthors() {
        return authors;
    }

    public WDSResolvedObject setAuthors(List<String> authors) {
        this.authors = authors;
        return this;
    }

    public List<SubjectType> getSubjects() {
        return subjects;
    }

    public WDSResolvedObject setSubjects(List<SubjectType> subjects) {
        this.subjects = subjects;
        return this;
    }

    public String getPublisher() {
        return publisher;
    }


    public String getEscapedPublisher() {
        return StringEscapeUtils.escapeXml11(publisher);
    }

    public WDSResolvedObject setPublisher(final String publisher) {
        this.publisher = publisher;
        return this;
    }


    public List<String> getEscapedXMLAuthors() {
        if (authors == null)
            return authors;
        return authors.stream().map(StringEscapeUtils::escapeXml11).collect(Collectors.toList());
    }

    public List<String> getEscapedXMLTitles() {
        if (titles == null)
            return titles;
        return titles.stream().map(StringEscapeUtils::escapeXml11).collect(Collectors.toList());

    }

    public List<String> getEscapedDescriptions() {
        if (descriptions == null)
            return null;
        return descriptions.stream().map(Pair::getValue).map(StringEscapeUtils::escapeXml11).collect(Collectors.toList());
    }


    @Override
    public String toString() {
        return toJsonString();
    }


}
