/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.wds.collector.plugins;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.dnetlib.wds.collector.plugins.CMRObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class CMRObjectDeserializer
implements JsonDeserializer<CMRObject> {
    public CMRObject deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        CMRObject result = new CMRObject();
        JsonObject root = jsonElement.getAsJsonObject();
        if (root.has("polygons")) {
            JsonArray polygons = root.getAsJsonArray("polygons");
            ArrayList<List<String>> polygonsList = new ArrayList<List<String>>();
            for (JsonElement elem : polygons) {
                JsonArray polygon = elem.getAsJsonArray();
                ArrayList<String> currentPolygon = new ArrayList<String>();
                for (JsonElement polygonItem : polygon) {
                    currentPolygon.add(polygonItem.getAsString());
                }
                polygonsList.add(currentPolygon);
            }
            result.setPolygons(polygonsList);
        }
        result.setLinks(this.getListOfRelation(root, "links"));
        result.setTime_end(this.getSingleItem(root, "time_end"));
        result.setTitle(this.getSingleItem(root, "title"));
        result.setOriginal_format(this.getSingleItem(root, "original_format"));
        result.setTime_start(this.getSingleItem(root, "time_start"));
        result.setData_center(this.getSingleItem(root, "archive_center"));
        result.setDataset_id(this.getSingleItem(root, "dataset_id"));
        result.setId(this.getSingleItem(root, "id"));
        result.setShort_name(this.getSingleItem(root, "short_name"));
        result.setBoxes(this.getListOfItem(root, "boxes"));
        result.setOrganizations(this.getListOfItem(root, "organizations"));
        result.setCoordinate_system(this.getSingleItem(root, "coordinate_system"));
        result.setSummary(this.getSingleItem(root, "summary"));
        result.setPoints(this.getSingleItem(root, "points"));
        result.setUpdated(this.getSingleItem(root, "updated"));
        return result;
    }

    private String getSingleItem(JsonObject root, String key) {
        if (root.has(key)) {
            return root.get(key).getAsString();
        }
        return null;
    }

    private List<String> getListOfItem(JsonObject root, String key) {
        if (root.has(key)) {
            JsonArray jsonList = root.getAsJsonArray(key);
            ArrayList<String> resultList = new ArrayList<String>();
            for (JsonElement elem : jsonList) {
                String currentItem = elem.getAsString().trim();
                resultList.add(currentItem);
            }
            return resultList;
        }
        return null;
    }

    private List<CMRObject.CMRRelation> getListOfRelation(JsonObject root, String key) {
        if (root.has(key)) {
            JsonArray jsonList = root.getAsJsonArray(key);
            ArrayList<CMRObject.CMRRelation> resultList = new ArrayList<CMRObject.CMRRelation>();
            for (JsonElement elem : jsonList) {
                CMRObject.CMRRelation rel = CMRObject.newRelation();
                JsonObject currentObject = elem.getAsJsonObject();
                rel.setHreflang(currentObject.get("hreflang").getAsString());
                rel.setHref(currentObject.get("href").getAsString());
                if (currentObject.has("title")) {
                    rel.setTitle(currentObject.get("title").getAsString());
                }
                rel.setId(currentObject.get("rel").getAsString());
                resultList.add(rel);
            }
            return resultList;
        }
        return null;
    }
}

