/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering;

import gr.forth.ics.isl.stellaclustering.ContentToCluster;
import gr.forth.ics.isl.stellaclustering.Input;
import gr.forth.ics.isl.stellaclustering.Output;
import gr.forth.ics.isl.stellaclustering.Snippet;
import gr.forth.ics.isl.stellaclustering.clusterer.Cluster;
import gr.forth.ics.isl.stellaclustering.clusterer.Clusterer;
import gr.forth.ics.isl.stellaclustering.clusterer.NMSTC_Plus;
import gr.forth.ics.isl.stellaclustering.clusterer.NM_STC;
import gr.forth.ics.isl.stellaclustering.clusterer.STC;
import gr.forth.ics.isl.stellaclustering.clusterer.STC_Orig;
import gr.forth.ics.isl.stellaclustering.clusterer.STC_Plus;
import gr.forth.ics.isl.stellaclustering.clusterer.STC_PlusPlus;
import gr.forth.ics.isl.stellaclustering.resources.Resources;
import gr.forth.ics.isl.stellaclustering.util.TreeNode;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLT_Creator {
    private String rootName;
    private int clusteringAlgorithm;
    private int numOfClusters;
    private LinkedHashMap<Integer, Float> docIds;
    private LinkedHashMap<Integer, Snippet> snippets;
    private TreeNode clusterTree;

    public CLT_Creator(String rootName, ArrayList<ContentToCluster> contentsToCluster, int clusteringAlgorithm, int numOfClusters) {
        this.rootName = rootName;
        this.clusteringAlgorithm = clusteringAlgorithm;
        this.numOfClusters = numOfClusters;
        try {
            this.docIds = new LinkedHashMap();
            this.snippets = new LinkedHashMap();
            for (int i = 0; i < contentsToCluster.size(); ++i) {
                String secText;
                ContentToCluster res = contentsToCluster.get(i);
                String mainText = res.getMainText();
                if (mainText == null) {
                    mainText = "";
                }
                if ((secText = res.getSecondaryText()) == null) {
                    secText = "";
                }
                int rank = i + 1;
                this.docIds.put(rank, new Float(rank));
                this.snippets.put(rank, new Input().preprocesing(mainText, secText));
            }
            Input in = new Input(this.docIds);
            in.setSnippets(this.snippets);
            STC stc = new NM_STC();
            if (clusteringAlgorithm == 1) {
                stc = new STC_Orig(in, 0.5f);
            } else if (clusteringAlgorithm == 2) {
                stc = new STC_Plus(in, 0.4f);
            } else if (clusteringAlgorithm == 3) {
                stc = new NM_STC();
                stc.setInputData(in);
                if (numOfClusters <= 0) {
                    ((NM_STC)stc).setNCmax(15);
                } else {
                    ((NM_STC)stc).setNCmax(numOfClusters);
                }
                ((NM_STC)stc).setQuery(this.rootName);
            } else if (clusteringAlgorithm == 4) {
                stc = new STC_PlusPlus(in, 0.4f);
            } else if (clusteringAlgorithm == 5) {
                stc = new NMSTC_Plus(in, 5, 0.8f);
                if (numOfClusters <= 0) {
                    ((NMSTC_Plus)stc).setNCmax(15);
                } else {
                    ((NMSTC_Plus)stc).setNCmax(numOfClusters);
                }
                ((NMSTC_Plus)stc).setQuery(this.rootName);
            }
            ArrayList<Cluster> cl = null;
            try {
                cl = stc.clustering();
            }
            catch (Exception e) {
                System.out.println("*** ERROR RUNNING CLUSTERING: " + e.getMessage());
            }
            Output out = new Output(cl);
            out.sortByScore();
            if (numOfClusters > 0 && clusteringAlgorithm != 3 && clusteringAlgorithm != 5) {
                out.keepTopClusters(numOfClusters);
            }
            this.clusterTree = out.transformClustersToTree(this.rootName);
        }
        catch (Exception ex) {
            System.out.println("*** PROBLEM CLUSTERING THE RESULTS!");
            Logger.getLogger(Clusterer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void InitializeClusteringProperties(String propertiesFilePath) {
        System.out.println("# Initializing Clustering Properties...");
        try {
            String stemmerLog;
            String aklita;
            String irregular;
            String prefixes;
            String endings;
            String stopList;
            String logsFolder;
            String textFolder;
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(propertiesFilePath);
            prop.load(in);
            Resources.TEXTFOLDER = textFolder = prop.getProperty("gr.forth.ics.stellaclustering.resources.textFolder");
            Resources.LOGSFOLDER = logsFolder = prop.getProperty("gr.forth.ics.stellaclustering.resources.logsFolder");
            String useStemming = prop.getProperty("gr.forth.ics.stellaclustering.resources.useStemming");
            Resources.useStemming = !useStemming.toLowerCase().equals("false");
            String useStopWords = prop.getProperty("gr.forth.ics.stellaclustering.resources.useStopWords");
            Resources.useStopWords = !useStopWords.toLowerCase().equals("false");
            Resources.STOPLIST = stopList = prop.getProperty("gr.forth.ics.stellaclustering.resources.stemmer.stopList");
            Resources.ENDINGS = endings = prop.getProperty("gr.forth.ics.stellaclustering.resources.stemmer.endings");
            Resources.PREFIXES = prefixes = prop.getProperty("gr.forth.ics.stellaclustering.resources.stemmer.prefixes");
            Resources.IRREGULAR = irregular = prop.getProperty("gr.forth.ics.stellaclustering.resources.stemmer.irregular");
            Resources.AKLITA = aklita = prop.getProperty("gr.forth.ics.stellaclustering.resources.stemmer.aklita");
            Resources.STEMMERLOG = stemmerLog = prop.getProperty("gr.forth.ics.stellaclustering.resources.stemmer.stemmerLog");
        }
        catch (Exception e) {
            System.out.println("*** PROBLEM READING PROPERTIES FILE: " + e.getMessage());
        }
        System.out.println("=> TEXT FOLDER: " + Resources.TEXTFOLDER);
        System.out.println("=> LOGS FOLDER: " + Resources.LOGSFOLDER);
        System.out.println("=> USE STEMMING: " + Resources.useStemming);
        System.out.println("=> USE STOPWORDS: " + Resources.useStopWords);
        System.out.println("=> STOPLIST: " + Resources.STOPLIST);
        System.out.println("=> ENDINGS: " + Resources.ENDINGS);
        System.out.println("=> PREFIXES: " + Resources.PREFIXES);
        System.out.println("=> IRREGULAR: " + Resources.IRREGULAR);
        System.out.println("=> AKLITA: " + Resources.AKLITA);
        System.out.println("=> STEMMERLOG: " + Resources.STEMMERLOG);
    }

    public int getClusteringAlgorithm() {
        return this.clusteringAlgorithm;
    }

    public void setClusteringAlgorithm(int clusteringAlgorithm) {
        this.clusteringAlgorithm = clusteringAlgorithm;
    }

    public int getNumOfClusters() {
        return this.numOfClusters;
    }

    public void setNumOfClusters(int numOfClusters) {
        this.numOfClusters = numOfClusters;
    }

    public TreeNode getClusterTree() {
        return this.clusterTree;
    }

    public void setClusterTree(TreeNode clusterTree) {
        this.clusterTree = clusterTree;
    }

    public LinkedHashMap<Integer, Float> getDocIds() {
        return this.docIds;
    }

    public void setDocIds(LinkedHashMap<Integer, Float> docIds) {
        this.docIds = docIds;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }
}

