/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering;

import gr.forth.ics.isl.stellaclustering.CLT_Creator;
import gr.forth.ics.isl.stellaclustering.ContentToCluster;
import gr.forth.ics.isl.stellaclustering.util.HTMLTag;
import gr.forth.ics.isl.stellaclustering.util.TreeNode;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Example {
    public static void main(String[] args) {
        String query = "fish";
        System.out.println("Getting the results for the query '" + query + "' from Bing Search Engine...");
        ArrayList<ContentToCluster> results = Example.findBingResults(query);
        CLT_Creator.InitializeClusteringProperties("/conf/clustering.properties");
        System.out.println("Creating the Cluster Label Tree...");
        CLT_Creator clt = new CLT_Creator(query, results, 3, 15);
        System.out.println("Cluster Label Tree: \n");
        Enumeration<javax.swing.tree.TreeNode> enumer = clt.getClusterTree().preorderEnumeration();
        while (enumer.hasMoreElements()) {
            TreeNode node = (TreeNode)enumer.nextElement();
            System.out.println(node.getTitle() + " " + node.getDocumentsList());
        }
        System.out.println();
    }

    private static ArrayList<ContentToCluster> findBingResults(String query) {
        ArrayList<ContentToCluster> results = new ArrayList<ContentToCluster>();
        try {
            String enc_query = URLEncoder.encode(query, "utf-8");
            String bing_path = "http://www.bing.com/search?q=" + enc_query + "&count=50&first=0&format=rss";
            URL url = new URL(bing_path);
            HTMLTag tagger = new HTMLTag(url, true);
            int i1 = tagger.getFirstTagIndex("item");
            int num = 1;
            while (i1 != -1) {
                String title = tagger.getFirstTagData("title", i1);
                String description = tagger.getFirstTagData("description", i1);
                ContentToCluster result = new ContentToCluster(title, description);
                results.add(result);
                ++num;
                i1 = tagger.getFirstTagIndex("item", i1 + 2);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        return results;
    }
}

