/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering;

import gr.forth.ics.isl.stellaclustering.Snippet;
import gr.forth.ics.isl.stellaclustering.lexicalanalyzer.LexicalAnalyzer;
import gr.forth.ics.isl.stellaclustering.lexicalanalyzer.LexicalAnalyzerProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Input {
    private LinkedHashMap<Integer, Snippet> snippets;
    private LinkedHashMap<Integer, Float> docIds = new LinkedHashMap();
    private boolean BLOCK_STOPWORDS;
    private boolean WITH_STEMMING;
    private boolean SENTENCE_SEPERATION;
    private boolean USE_TITLES;
    private HashMap<String, Float> idfs;

    public Input() throws Exception {
        this.snippets = new LinkedHashMap();
        this.BLOCK_STOPWORDS = true;
        this.WITH_STEMMING = false;
        this.SENTENCE_SEPERATION = true;
        this.USE_TITLES = true;
        this.idfs = null;
    }

    public Input(LinkedHashMap<Integer, Float> docIds) throws Exception {
        this.snippets = new LinkedHashMap();
        this.BLOCK_STOPWORDS = true;
        this.WITH_STEMMING = false;
        this.SENTENCE_SEPERATION = false;
        this.USE_TITLES = true;
        this.idfs = null;
        this.setDocIds(docIds);
    }

    public Input(LinkedHashMap<Integer, Float> docIds, boolean stopwords, boolean stemming, boolean sentences, boolean useTitles) {
        this.snippets = new LinkedHashMap();
        this.BLOCK_STOPWORDS = stopwords;
        this.WITH_STEMMING = stemming;
        this.SENTENCE_SEPERATION = sentences;
        this.USE_TITLES = useTitles;
        this.idfs = null;
        this.setDocIds(docIds);
    }

    public void setDocIds(LinkedHashMap<Integer, Float> docIds) {
        this.docIds = docIds;
    }

    public void setSnippets(LinkedHashMap<Integer, Snippet> snippets) {
        this.snippets = snippets;
    }

    public void setIdfs(HashMap<String, Float> idfsMap) {
        this.idfs = idfsMap;
    }

    public LinkedHashMap<Integer, Float> getDocIds() {
        return this.docIds;
    }

    public LinkedHashMap<Integer, Snippet> getSnippets() {
        return this.snippets;
    }

    public HashMap<String, Float> getIdfs() {
        return this.idfs;
    }

    private ArrayList<String> splitInto2Sentences(String text) {
        ArrayList<String> sentences = new ArrayList<String>();
        String[] credits = text.split("(\\.\\.\\.)");
        for (int i = 0; i < credits.length; ++i) {
            String thisTerm = credits[i];
            sentences.add(thisTerm);
        }
        return sentences;
    }

    private ArrayList<String> getQueryAsVector(String query) throws FileNotFoundException, IOException {
        ArrayList<String> queryAsVector = new ArrayList<String>();
        String[] creds = query.split(" ");
        for (int i = 0; i < creds.length; ++i) {
            String thisTerm = creds[i];
            queryAsVector.add(thisTerm);
        }
        return queryAsVector;
    }

    public int snippetsSize() {
        return this.snippets.size();
    }

    public void printIDFs() {
        for (String term : this.idfs.keySet()) {
            float idf = this.idfs.get(term).floatValue();
            System.out.println("term=" + term + " idf=" + idf);
        }
    }

    public static ArrayList<Integer> getTopLFilesIds(ArrayList<Integer> docIds, int top) {
        if (docIds == null || docIds.isEmpty()) {
            System.out.println("Documents' List is empty.");
            return null;
        }
        if (docIds.size() <= top) {
            return docIds;
        }
        ArrayList<Integer> topIds = new ArrayList<Integer>();
        Iterator<Integer> iter = docIds.iterator();
        for (int count = 0; iter.hasNext() && count < top; ++count) {
            topIds.add(iter.next());
        }
        return topIds;
    }

    public Snippet preprocesing(String title, String snip) throws Exception {
        LexicalAnalyzer lex = null;
        LexicalAnalyzerProperties lexProp = new LexicalAnalyzerProperties();
        lexProp.setBlockStopWords(this.BLOCK_STOPWORDS);
        lexProp.setUseStemmer(this.WITH_STEMMING);
        lexProp.setStoreTxt(false);
        lexProp.setBlockTermsWithPunctuation(true);
        lex = new LexicalAnalyzer(lexProp);
        ArrayList<String> titleSent = new ArrayList<String>();
        ArrayList<String> bestTextSent = new ArrayList<String>();
        ArrayList<Object> bestText = new ArrayList();
        ArrayList<String> finalTitles = new ArrayList<String>();
        ArrayList<String> finalBestTexts = new ArrayList();
        Snippet snippet = null;
        if (this.SENTENCE_SEPERATION) {
            Locale currentLocale = new Locale("en", "US");
            BreakIterator sentenceIterator = BreakIterator.getSentenceInstance(currentLocale);
            boolean j = false;
            int ins = 0;
            boolean flagPdf = false;
            String sent = new String();
            if (this.USE_TITLES && !title.isEmpty()) {
                flagPdf = false;
                if (title.startsWith("http:") || title.startsWith("https:") || title.startsWith("untitled")) {
                    title = "";
                } else if (title.startsWith("Microsoft Word")) {
                    if ((title = title.substring(17)).endsWith(".doc") || title.endsWith(".DOC")) {
                        title = title.substring(0, title.length() - 4);
                    }
                    flagPdf = true;
                } else if (title.startsWith("Microsoft PowerPoint")) {
                    if ((title = title.substring(23)).endsWith(".ppt") || title.endsWith(".PPT")) {
                        title = title.substring(0, title.length() - 4);
                    }
                    flagPdf = true;
                }
                ins = 0;
                if (flagPdf) {
                    String[] cred = title.split("_");
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < cred.length; ++i) {
                        buf.append(cred[i]);
                        buf.append(" ");
                    }
                    String tmp = buf.toString().trim();
                    if (!tmp.isEmpty()) {
                        titleSent.add(ins++, tmp);
                    }
                } else {
                    sentenceIterator.setText(title);
                    int start = sentenceIterator.first();
                    int end = sentenceIterator.next();
                    while (end != -1) {
                        sent = title.substring(start, end);
                        if (!sent.isEmpty()) {
                            titleSent.add(ins++, sent);
                        }
                        start = end;
                        end = sentenceIterator.next();
                    }
                }
                if (!titleSent.isEmpty()) {
                    finalTitles = lex.stringAnalyze(titleSent);
                }
            }
            bestText = this.splitInto2Sentences(snip);
            ins = 0;
            for (int x = 0; x < bestText.size(); ++x) {
                String bs = (String)bestText.get(x);
                if (bs.isEmpty()) continue;
                sentenceIterator.setText(bs);
                int start = sentenceIterator.first();
                int end = sentenceIterator.next();
                while (end != -1) {
                    sent = bs.substring(start, end);
                    if (!sent.isEmpty()) {
                        bestTextSent.add(ins++, sent);
                    }
                    start = end;
                    end = sentenceIterator.next();
                }
            }
            if (!bestTextSent.isEmpty()) {
                finalBestTexts = lex.stringAnalyze(bestTextSent);
            }
            snippet = new Snippet(finalTitles, finalBestTexts);
        }
        return snippet;
    }
}

