/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering;

import gr.forth.ics.isl.stellaclustering.clusterer.Cluster;
import gr.forth.ics.isl.stellaclustering.util.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output {
    private ArrayList<Cluster> clusters;
    private TreeNode tree;

    public Output() {
        this.clusters = new ArrayList();
    }

    public Output(ArrayList<Cluster> cl) {
        this.clusters = cl;
    }

    public void setClusters(ArrayList<Cluster> cl) {
        this.clusters = cl;
    }

    public ArrayList<Cluster> getClusters() {
        return this.clusters;
    }

    public void setTree(TreeNode tree) {
        this.tree = tree;
    }

    public TreeNode getTree() {
        return this.tree;
    }

    public TreeNode transformClustersToTree(String query) throws Exception {
        this.tree = new TreeNode("All");
        this.tree.setTitle(query);
        this.tree.setId(1);
        this.tree.setDocumentsList(new ArrayList<Integer>());
        this.constructSubTree(this.tree, this.clusters, 2);
        return this.tree;
    }

    private int constructSubTree(TreeNode startNode, ArrayList<Cluster> cl, int index) {
        for (int i = 0; i < cl.size(); ++i) {
            Cluster clust = cl.get(i);
            ArrayList<Integer> docIds = clust.getDocuments();
            TreeNode node = new TreeNode(docIds);
            node.setTitle(clust.getLabel());
            node.setId(index++);
            node.setDocumentsList(docIds);
            if (clust.hasChildren()) {
                node.setAllowsChildren(true);
                index = this.constructSubTree(node, clust.getChildren(), index);
                node.isLeaf = 0;
            } else {
                node.isLeaf = 1;
            }
            startNode.add(node);
        }
        return index;
    }

    public void printTreeRecursive(TreeNode subTree, int spaces) throws Exception {
        if (subTree == null) {
            throw new NullPointerException("The tree is empty.");
        }
        for (int i = 0; i < spaces; ++i) {
            System.out.print("  ");
        }
        Enumeration<javax.swing.tree.TreeNode> en = subTree.breadthFirstEnumeration();
        TreeNode enNode = (TreeNode)en.nextElement();
        this.printNode(enNode);
        en = subTree.children();
        while (en.hasMoreElements()) {
            TreeNode leftChild = (TreeNode)en.nextElement();
            this.printTreeRecursive(leftChild, spaces + 2);
        }
    }

    private void printNode(TreeNode node) throws Exception {
        System.out.print(" *Title: \"" + node.getTitle() + "\" Id=" + node.getId());
        System.out.println(".Files:" + node.getUserObject());
    }

    public void sortByScore() {
        Collections.sort(this.clusters, Cluster.ORDER_BY_LABEL_SCORE);
    }

    public static void sortByScore(ArrayList<Cluster> list) {
        Collections.sort(list, Cluster.ORDER_BY_LABEL_SCORE);
    }

    public static ArrayList<String> belongsToCluster(int docId, TreeNode clusterTree) throws Exception {
        ArrayList<String> labels = new ArrayList<String>();
        if (clusterTree == null) {
            System.out.println("The tree is EMPTY..!");
            return null;
        }
        Enumeration<javax.swing.tree.TreeNode> en = clusterTree.breadthFirstEnumeration();
        String title = clusterTree.getTitle();
        Object docs = clusterTree.getUserObject();
        if (docs instanceof String || ((ArrayList)docs).contains(docId)) {
            int childno = clusterTree.getChildCount();
            if (childno > 0) {
                labels.add(title);
                en = clusterTree.children();
                while (en.hasMoreElements()) {
                    TreeNode leftChild = (TreeNode)en.nextElement();
                    ArrayList<String> childLabels = Output.belongsToCluster(docId, leftChild);
                    if (childLabels.isEmpty()) continue;
                    labels.addAll(childLabels);
                }
            } else {
                labels.add(title);
            }
        }
        return labels;
    }

    public static ArrayList<Integer> belongsToClusterIds(int docId, TreeNode clusterTree) throws Exception {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (clusterTree == null) {
            System.out.println("The tree is EMPTY..!");
            return null;
        }
        Enumeration<javax.swing.tree.TreeNode> en = clusterTree.breadthFirstEnumeration();
        Integer nodeId = new Integer(clusterTree.getId());
        Object docs = clusterTree.getUserObject();
        if (docs instanceof String || ((ArrayList)docs).contains(docId)) {
            int childno = clusterTree.getChildCount();
            if (childno > 0) {
                ids.add(nodeId);
                en = clusterTree.children();
                while (en.hasMoreElements()) {
                    TreeNode leftChild = (TreeNode)en.nextElement();
                    ArrayList<Integer> childIds = Output.belongsToClusterIds(docId, leftChild);
                    if (childIds.isEmpty()) continue;
                    ids.addAll(childIds);
                }
            } else {
                ids.add(nodeId);
            }
        }
        return ids;
    }

    public ArrayList<Integer> clusteredDocs(ArrayList<Cluster> cl) {
        ArrayList<Integer> allDocs = new ArrayList<Integer>();
        for (int i = 0; i < cl.size(); ++i) {
            Cluster clust = cl.get(i);
            ArrayList<Integer> docIds = clust.getDocuments();
            allDocs.addAll(docIds);
            allDocs = new ArrayList<Integer>(new TreeSet<Integer>(allDocs));
        }
        return allDocs;
    }

    public String toSingleString(String query) {
        StringBuffer buff = new StringBuffer();
        buff.append(query).append("\n");
        buff.append(this.getResultAsIndentedString(this.clusters, 1));
        buff.append("\n");
        return buff.toString();
    }

    private String getResultAsIndentedString(ArrayList<Cluster> cl, int level) {
        StringBuffer buff = new StringBuffer();
        StringBuffer spaces = new StringBuffer();
        for (int j = 0; j < level + 1; ++j) {
            spaces.append(" ");
        }
        for (int i = 0; i < cl.size(); ++i) {
            Cluster clust = cl.get(i);
            ArrayList<Integer> docIds = clust.getDocuments();
            if (level != 0) {
                buff.append(spaces);
            }
            buff.append("-");
            buff.append(clust.getLabel());
            buff.append("(").append(docIds.size()).append(")");
            buff.append(" ").append(docIds).append("\n");
            if (!clust.hasChildren()) continue;
            buff.append(this.getResultAsIndentedString(clust.getChildren(), level + 1));
        }
        return buff.toString();
    }

    public void keepTopClusters(int numOfCl) {
        int size = this.clusters.size();
        if (size > numOfCl) {
            this.clusters.subList(numOfCl, size).clear();
        }
    }

    public void printClusters() {
        for (int i = 0; i < this.clusters.size(); ++i) {
            System.out.println("label=" + this.clusters.get(i).getLabel() + " score=" + this.clusters.get(i).getScore());
            System.out.println("documents=" + this.clusters.get(i).getDocuments());
        }
    }

    public static void printClusters(ArrayList<Cluster> cl) {
        System.out.println("size=" + cl.size());
        for (int i = 0; i < cl.size(); ++i) {
            System.out.println("label=" + cl.get(i).getLabel());
            System.out.println("documents=" + cl.get(i).getDocuments());
        }
    }
}

