/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering;

import gr.forth.ics.isl.stellaclustering.SuffixTreeNode;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixTree
implements Cloneable {
    private HashMap<String, SuffixTreeNode> rootWords = new HashMap();

    public void setRootWords(HashMap<String, SuffixTreeNode> wordsArray) {
        this.rootWords = wordsArray;
    }

    public HashMap<String, SuffixTreeNode> getRootWords() {
        return this.rootWords;
    }

    public void insertSuffix(Integer id, String suffix, boolean titlePriority, boolean isTitle) {
        if (this.rootWords != null) {
            HashMap<String, SuffixTreeNode> startSTNodes = this.rootWords;
            HashMap<Object, Object> subTreeNode = new HashMap();
            int i = 0;
            try {
                String[] words = suffix.split(" ");
                for (i = 0; i < words.length && startSTNodes.containsKey(words[i]); ++i) {
                    if (titlePriority && isTitle && !startSTNodes.get(words[i]).getTitleDocIds().contains(id)) {
                        startSTNodes.get(words[i]).addDocIdToTitleDocs(id);
                    }
                    if (!isTitle && !startSTNodes.get(words[i]).getSnippetDocIds().contains(id)) {
                        startSTNodes.get(words[i]).addDocIdToSnippetDocs(id);
                    }
                    startSTNodes = startSTNodes.get(words[i]).getChildren();
                }
                subTreeNode = startSTNodes;
                while (i < words.length) {
                    subTreeNode.put(new String(words[i]), new SuffixTreeNode(id, isTitle));
                    subTreeNode = ((SuffixTreeNode)subTreeNode.get(words[i])).getChildren();
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void printST_toFile(String fileExtension) throws Exception {
        File f;
        if (fileExtension.equals("xml")) {
            f = new File("/spare/mitos/skopidak/mitos/mitos-t1/suffixTree.xml");
        } else if (fileExtension.equals("txt")) {
            f = new File("/spare/mitos/skopidak/mitos/mitos-t1/suffixTree.txt");
        } else if (fileExtension.equals("html")) {
            f = new File("/spare/mitos/skopidak/mitos/mitos-t1/suffixTree.html");
        } else {
            throw new IllegalArgumentException("Wrong file extension.");
        }
        FileOutputStream fout = new FileOutputStream(f);
        if (fileExtension.equals("xml")) {
            String init = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<query>\n");
            fout.write(init.getBytes());
        } else if (fileExtension.equals("html")) {
            String initHtml = new String("<html><head></head><body>\n");
            fout.write(initHtml.getBytes());
        }
        HashMap<String, SuffixTreeNode> stcMap = this.rootWords;
        if (fileExtension.equals("xml")) {
            this.print_tree2XML(stcMap, 1, fout);
        } else if (fileExtension.equals("txt")) {
            this.print_tree(stcMap, 1, fout);
        } else if (fileExtension.equals("html")) {
            this.print_tree2HTML(stcMap, 1, fout);
        }
        if (fileExtension.equals("xml")) {
            String endline = new String("</query>");
            fout.write(endline.getBytes());
        } else if (fileExtension.equals("html")) {
            String endline = new String("</body>");
            fout.write(endline.getBytes());
        }
        fout.close();
    }

    private void print_tree(HashMap<String, SuffixTreeNode> subTree, int level, FileOutputStream fout) throws Exception {
        for (String key : subTree.keySet()) {
            SuffixTreeNode node = subTree.get(key);
            StringBuffer buff = new StringBuffer();
            for (int j = 0; j < level; ++j) {
                buff.append("  ");
            }
            buff.append(level + " |" + key + "| docIds=" + node.getDocIds().toString() + "\n");
            fout.write(buff.toString().getBytes());
            HashMap<String, SuffixTreeNode> children = node.getChildren();
            this.print_tree(children, level + 1, fout);
        }
    }

    private void print_tree2HTML(HashMap<String, SuffixTreeNode> subTree, int level, FileOutputStream fout) throws Exception {
        StringBuffer spaces = new StringBuffer();
        for (int j = 0; j < level; ++j) {
            spaces.append("  ");
        }
        StringBuffer listBuff = new StringBuffer();
        listBuff.append(spaces);
        listBuff.append("<ol>\n");
        fout.write(listBuff.toString().getBytes());
        for (String key : subTree.keySet()) {
            SuffixTreeNode node = subTree.get(key);
            StringBuffer buff = new StringBuffer();
            buff.append(spaces);
            buff.append("<li>");
            buff.append(key);
            buff.append(" ");
            buff.append(node.getDocIds().toString());
            buff.append("</li>\n");
            fout.write(buff.toString().getBytes());
            HashMap<String, SuffixTreeNode> children = node.getChildren();
            if (children.size() <= 0) continue;
            this.print_tree2HTML(children, level + 1, fout);
        }
        StringBuffer endBuff = new StringBuffer();
        endBuff.append(spaces);
        endBuff.append("</ol>\n");
        fout.write(endBuff.toString().getBytes());
    }

    private void print_tree2XML(HashMap<String, SuffixTreeNode> subTree, int level, FileOutputStream fout) throws Exception {
        StringBuffer spaces = new StringBuffer();
        for (int j = 0; j < level; ++j) {
            spaces.append("  ");
        }
        for (String key : subTree.keySet()) {
            SuffixTreeNode node = subTree.get(key);
            StringBuffer buff = new StringBuffer();
            buff.append(spaces);
            buff.append("<cluster>\n");
            buff.append(spaces);
            buff.append("  <name>");
            buff.append(key);
            buff.append("</name>\n");
            buff.append(spaces);
            buff.append("  <size>");
            buff.append(node.countDocIds());
            buff.append("</size>\n");
            buff.append(spaces);
            buff.append("  <documentIds>");
            buff.append(node.getDocIds().toString());
            buff.append("</documentIds>\n");
            fout.write(buff.toString().getBytes());
            StringBuffer endBuff = new StringBuffer();
            HashMap<String, SuffixTreeNode> children = node.getChildren();
            if (children.size() > 0) {
                StringBuffer childBuff = new StringBuffer();
                childBuff.append(spaces);
                childBuff.append("  <children>\n");
                fout.write(childBuff.toString().getBytes());
                this.print_tree2XML(children, level + 1, fout);
                endBuff.append(spaces);
                endBuff.append("  </children>\n");
            }
            endBuff.append(spaces);
            endBuff.append("</cluster>\n");
            fout.write(endBuff.toString().getBytes());
        }
    }

    protected void printST(HashMap<String, SuffixTreeNode> subTree, int level) throws Exception {
        for (String key : subTree.keySet()) {
            SuffixTreeNode node = subTree.get(key);
            System.out.println(level + " w=" + key + " docs=" + node.getDocIds().toString() + "\ntitle docs=" + node.getTitleDocsSize() + "snippet docs=" + node.getSnippetDocsSize());
            System.out.println("t=" + node.getTitleDocIds() + " s=" + node.getSnippetDocIds());
            HashMap<String, SuffixTreeNode> children = node.getChildren();
            this.printST(children, level + 1);
        }
    }

    public ArrayList<Integer> findDocs() throws Exception {
        ArrayList<Integer> allDocs = new ArrayList<Integer>();
        for (String key : this.rootWords.keySet()) {
            SuffixTreeNode node = this.rootWords.get(key);
            ArrayList<Integer> docIds = node.getDocIds();
            allDocs.addAll(docIds);
            allDocs = new ArrayList<Integer>(new TreeSet<Integer>(allDocs));
        }
        return allDocs;
    }

    public Object clone() throws CloneNotSupportedException {
        SuffixTree copy = (SuffixTree)super.clone();
        if (this.rootWords != null) {
            copy.rootWords = (HashMap)this.rootWords.clone();
        }
        return copy;
    }
}

