/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixTreeNode {
    private String phrase = new String();
    private float baseClusterScore = 0.0f;
    private HashMap<String, SuffixTreeNode> children = new HashMap();
    private ArrayList<Integer> titleDocIds = new ArrayList();
    private ArrayList<Integer> snippetDocIds = new ArrayList();
    private boolean hasPruned;
    private boolean isTopLabel;

    public SuffixTreeNode() {
        this.hasPruned = false;
        this.isTopLabel = false;
    }

    public SuffixTreeNode(Integer id, boolean isTitle) {
        if (isTitle) {
            this.titleDocIds.add(id);
        } else {
            this.snippetDocIds.add(id);
        }
        this.hasPruned = false;
        this.isTopLabel = false;
    }

    public void setPhrase(String word) {
        this.phrase = word;
    }

    public void setBaseClusterScore(float baseClusterScore) {
        this.baseClusterScore = baseClusterScore;
    }

    public void setChildren(HashMap<String, SuffixTreeNode> children) {
        this.children = children;
    }

    public void setTitleDocIds(ArrayList<Integer> docs) {
        this.titleDocIds = docs;
    }

    public void setSnippetDocIds(ArrayList<Integer> docs) {
        this.snippetDocIds = docs;
    }

    public void setHasPruned(boolean prune) {
        this.hasPruned = prune;
    }

    public void setIsTopLabel(boolean topLab) {
        this.isTopLabel = topLab;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public float getBaseClusterScore() {
        return this.baseClusterScore;
    }

    public HashMap<String, SuffixTreeNode> getChildren() {
        return this.children;
    }

    public ArrayList<Integer> getTitleDocIds() {
        return this.titleDocIds;
    }

    public ArrayList<Integer> getSnippetDocIds() {
        return this.snippetDocIds;
    }

    public int getTitleDocsSize() {
        return this.titleDocIds.size();
    }

    public int getSnippetDocsSize() {
        return this.snippetDocIds.size();
    }

    public boolean getHasPruned() {
        return this.hasPruned;
    }

    public boolean getIsTopLabel() {
        return this.isTopLabel;
    }

    public void addDocIdToTitleDocs(Integer id) {
        this.titleDocIds.add(id);
    }

    public void addDocIdToSnippetDocs(Integer id) {
        this.snippetDocIds.add(id);
    }

    public void addChild(String word, SuffixTreeNode node) {
        this.children.put(word, node);
    }

    public ArrayList<Integer> getDocIds() throws Exception {
        return this.unionOfTwoLists(this.titleDocIds, this.snippetDocIds);
    }

    public boolean containsDocId(Integer id) throws Exception {
        return this.getDocIds().contains(id);
    }

    public int countDocIds() throws Exception {
        return this.getDocIds().size();
    }

    private ArrayList<Integer> unionOfTwoLists(ArrayList<Integer> li1, ArrayList<Integer> li2) throws Exception {
        ArrayList<Integer> union = new ArrayList<Integer>();
        int i = 0;
        for (i = 0; i < li1.size(); ++i) {
            union.add(li1.get(i));
        }
        for (i = 0; i < li2.size(); ++i) {
            if (li1.contains(li2.get(i))) continue;
            union.add(li2.get(i));
        }
        return union;
    }

    public boolean hasTopLabsChildren() {
        if (!this.getChildren().isEmpty()) {
            for (String key : this.getChildren().keySet()) {
                SuffixTreeNode node = this.getChildren().get(key);
                if (!node.getIsTopLabel()) continue;
                return true;
            }
        }
        return false;
    }

    public int countTopLabsChildren() {
        int count = 0;
        if (!this.getChildren().isEmpty()) {
            for (String key : this.getChildren().keySet()) {
                SuffixTreeNode node = this.getChildren().get(key);
                if (!node.getIsTopLabel()) continue;
                ++count;
            }
        }
        return count;
    }

    public void mergeDocumentSets(SuffixTreeNode node) {
        this.getTitleDocIds().addAll(node.getTitleDocIds());
        this.setTitleDocIds(new ArrayList<Integer>(new TreeSet<Integer>(this.getTitleDocIds())));
        this.getSnippetDocIds().addAll(node.getSnippetDocIds());
        this.setSnippetDocIds(new ArrayList<Integer>(new TreeSet<Integer>(this.getSnippetDocIds())));
    }

    public boolean hasSameDocsWith(SuffixTreeNode node) {
        try {
            if (this.countDocIds() == node.countDocIds() && this.getDocIds().containsAll(node.getDocIds())) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("java.lang.Exception in SuffixTreeNode: hasSameDocsWith()");
        }
        return false;
    }
}

