/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.clusterer;

import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster {
    private String label;
    private float score;
    private ArrayList<Integer> documents;
    private ArrayList<Cluster> children;
    public static final Comparator<Cluster> ORDER_BY_LABEL_SCORE = new Comparator<Cluster>(){

        @Override
        public int compare(Cluster c1, Cluster c2) {
            return c1.getScore() > c2.getScore() ? -1 : (c1.getScore() == c2.getScore() ? 0 : 1);
        }
    };

    public Cluster() {
        this.label = new String();
        this.score = 0.0f;
        this.documents = new ArrayList();
        this.children = new ArrayList();
    }

    public Cluster(String name, float score) {
        this.label = name.trim();
        this.score = score;
        this.documents = new ArrayList();
        this.children = new ArrayList();
    }

    public Cluster(String name, float score, ArrayList<Integer> docs, ArrayList<Cluster> children) {
        this.label = name.trim();
        this.score = score;
        this.documents = docs;
        this.children = children;
    }

    public void setLabel(String name) {
        this.label = name.trim();
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setDocuments(ArrayList<Integer> docs) {
        this.documents = docs;
    }

    public void setChildren(ArrayList<Cluster> subClusters) {
        this.children = subClusters;
    }

    public String getLabel() {
        return this.label;
    }

    public float getScore() {
        return this.score;
    }

    public ArrayList<Integer> getDocuments() {
        return this.documents;
    }

    public ArrayList<Cluster> getChildren() {
        return this.children;
    }

    public void addDocument(Integer id) {
        this.documents.add(id);
    }

    public void addSubCluster(Cluster cl) {
        this.children.add(cl);
    }

    public boolean hasChildren() {
        return this.children != null;
    }
}

