/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.clusterer;

import gr.forth.ics.isl.stellaclustering.Input;
import gr.forth.ics.isl.stellaclustering.SuffixTreeNode;
import gr.forth.ics.isl.stellaclustering.clusterer.Cluster;
import gr.forth.ics.isl.stellaclustering.clusterer.NM_STC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMSTC_Plus
extends NM_STC {
    int F;
    float coverThres;
    int total;
    int cat1;
    int cat2;
    int cat3;

    public NMSTC_Plus(int F, float coverThres) {
        this.F = F;
        this.coverThres = coverThres;
        this.cat3 = 0;
        this.cat2 = 0;
        this.cat1 = 0;
        this.total = 0;
    }

    public NMSTC_Plus(Input in, int F, float coverThres) {
        this.F = F;
        this.coverThres = coverThres;
        this.setInputData(in);
    }

    public void setF(int childNum) {
        this.F = childNum;
    }

    public void setCoverThres(float coverThres) {
        this.coverThres = coverThres;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> getNextTopScored(ArrayList<Map.Entry<String, SuffixTreeNode>> childrenList, int childrenNum) {
        ArrayList<Map.Entry<String, SuffixTreeNode>> nextCh = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
        int listSize = childrenList.size();
        if (listSize < childrenNum) {
            childrenNum = listSize;
        }
        int num = 0;
        int zeroscore = 0;
        Iterator<Map.Entry<String, SuffixTreeNode>> it = childrenList.iterator();
        while (it.hasNext() && num < childrenNum) {
            Map.Entry<String, SuffixTreeNode> entry = it.next();
            SuffixTreeNode node = entry.getValue();
            if (node.getIsTopLabel()) {
                it.remove();
                continue;
            }
            if (node.getBaseClusterScore() > 0.0f) {
                nextCh.add(entry);
                ++num;
                continue;
            }
            ++zeroscore;
        }
        for (int i = 0; i < num + zeroscore; ++i) {
            childrenList.remove(0);
        }
        return nextCh;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> getElementsWithExtOver(float coverThres, ArrayList<Map.Entry<String, SuffixTreeNode>> nextTopScored, SuffixTreeNode parentNode) {
        ArrayList<Map.Entry<String, SuffixTreeNode>> returnedNodes = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
        try {
            ArrayList<Integer> parentDocs = parentNode.getDocIds();
            Iterator<Map.Entry<String, SuffixTreeNode>> it = nextTopScored.iterator();
            while (it.hasNext()) {
                ++this.total;
                Map.Entry<String, SuffixTreeNode> entry = it.next();
                SuffixTreeNode node = entry.getValue();
                float overlap = this.jaccardOverlap(parentDocs, node.getDocIds());
                if (overlap > 0.0f && (double)overlap <= 0.2) {
                    ++this.cat1;
                } else if ((double)overlap > 0.2 && (double)overlap <= 0.4) {
                    ++this.cat2;
                } else if ((double)overlap > 0.4) {
                    ++this.cat3;
                }
                if (!(overlap < 1.0f - coverThres)) continue;
                node.setIsTopLabel(true);
                returnedNodes.add(entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnedNodes;
    }

    public float jaccardOverlap(ArrayList<Integer> parentDocs, ArrayList<Integer> childDocs) {
        ArrayList<Integer> union = new ArrayList<Integer>(parentDocs);
        union.addAll(childDocs);
        union = new ArrayList<Integer>(new TreeSet<Integer>(union));
        ArrayList<Integer> intersection = new ArrayList<Integer>(parentDocs);
        intersection.retainAll(childDocs);
        float result = (float)intersection.size() / (float)union.size();
        return result;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> improveHierarchy(ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs, int F, float coverThres) {
        for (Map.Entry<String, SuffixTreeNode> entry : maximalLabs) {
            SuffixTreeNode fnode = entry.getValue();
            HashMap<String, SuffixTreeNode> children = fnode.getChildren();
            Iterator<Map.Entry<String, SuffixTreeNode>> childrenEntries = children.entrySet().iterator();
            ArrayList<Map.Entry<String, SuffixTreeNode>> childrenList = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
            while (childrenEntries.hasNext()) {
                childrenList.add(childrenEntries.next());
            }
            this.sortByScore(childrenList);
            boolean impossible = false;
            int missChilds = F - fnode.countTopLabsChildren();
            int consumed = 0;
            boolean childExists = false;
            if (childrenList.size() > 0) {
                childExists = true;
            }
            while (consumed < missChilds && !impossible && childExists) {
                int childrenNum = missChilds - consumed;
                ArrayList<Map.Entry<String, SuffixTreeNode>> nextTopScored = this.getNextTopScored(childrenList, childrenNum);
                int topScoredNum = nextTopScored.size();
                if (topScoredNum < childrenNum) {
                    impossible = true;
                }
                nextTopScored = this.getElementsWithExtOver(coverThres, nextTopScored, fnode);
                topScoredNum = nextTopScored.size();
                consumed += topScoredNum;
                if (childrenList.size() > 0) continue;
                childExists = false;
            }
        }
        if (this.total == this.cat1 + this.cat2 + this.cat3) {
            System.out.println("-------- OK -------");
            System.out.println("avg(cat1)=" + (float)this.cat1 / (float)this.total);
            System.out.println("avg(cat2)=" + (float)this.cat2 / (float)this.total);
            System.out.println("avg(cat3)=" + (float)this.cat3 / (float)this.total);
        }
        return maximalLabs;
    }

    @Override
    public ArrayList<Cluster> clustering() throws Exception {
        this.constructSuffixTree();
        this.pruneSuffixTree(this.st.getRootWords());
        ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs = this.findTopScoredLabels();
        this.improveHierarchy(maximalLabs, this.F, this.coverThres);
        ArrayList<Cluster> clusters = this.createFinalClusters(maximalLabs);
        return clusters;
    }
}

