/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.clusterer;

import gr.forth.ics.isl.stellaclustering.Input;
import gr.forth.ics.isl.stellaclustering.Output;
import gr.forth.ics.isl.stellaclustering.Snippet;
import gr.forth.ics.isl.stellaclustering.SuffixTreeNode;
import gr.forth.ics.isl.stellaclustering.clusterer.Cluster;
import gr.forth.ics.isl.stellaclustering.clusterer.STC;
import gr.forth.ics.isl.stellaclustering.stemmer.Stemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NM_STC
extends STC {
    private int LLmax = 4;
    private int LLmin = 1;
    private int NCmax = 20;
    private String query;
    private int indexSize;
    private static final Comparator<Map.Entry<String, SuffixTreeNode>> ORDER_BY_NODE_SCORE = new Comparator<Map.Entry<String, SuffixTreeNode>>(){

        @Override
        public int compare(Map.Entry<String, SuffixTreeNode> en1, Map.Entry<String, SuffixTreeNode> en2) {
            float s2;
            float s1 = en1.getValue().getBaseClusterScore();
            return s1 > (s2 = en2.getValue().getBaseClusterScore()) ? -1 : (s1 == s2 ? 0 : 1);
        }
    };

    public void setLLmax(int labelLen) {
        this.LLmax = labelLen;
    }

    public void setLLmin(int labelLen) {
        this.LLmin = labelLen;
    }

    public void setNCmax(int clustersNum) {
        if (this.in != null) {
            int inputSize = this.in.snippetsSize();
            this.NCmax = inputSize < clustersNum ? inputSize / 2 : clustersNum;
        } else {
            throw new NullPointerException("NM_STC: Instance of class Input should be initialized.");
        }
    }

    public int getNCmax() {
        return this.NCmax;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public void setInputData(Input in) {
        this.in = in;
        if (this.in != null) {
            int inputSize = this.in.snippetsSize();
            if (inputSize < this.getNCmax()) {
                this.NCmax = inputSize / 2;
            }
        } else {
            throw new NullPointerException("NM_STC constructor: Instance of class Input should be initialized.");
        }
    }

    @Override
    public ArrayList<Cluster> clustering() throws Exception {
        this.constructSuffixTree();
        this.pruneSuffixTree(this.st.getRootWords());
        ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs = this.findTopScoredLabels();
        ArrayList<Cluster> clusters = this.createFinalClusters(maximalLabs);
        return clusters;
    }

    @Override
    public void constructSuffixTree() throws Exception {
        Integer docId2 = null;
        Snippet snippet = new Snippet();
        int i = 0;
        for (Integer docId2 : this.in.getSnippets().keySet()) {
            snippet = this.in.getSnippets().get(docId2);
            ArrayList<String> tit = snippet.getTitle();
            for (i = 0; i < tit.size(); ++i) {
                ArrayList<String> suffixes = this.generateSuffixes(tit.get(i));
                for (int z = 0; z < suffixes.size(); ++z) {
                    this.st.insertSuffix(docId2, suffixes.get(z), true, true);
                }
            }
            ArrayList<String> bt = snippet.getBestText();
            for (i = 0; i < bt.size(); ++i) {
                ArrayList<String> suffixes = this.generateSuffixes(bt.get(i));
                for (int z = 0; z < suffixes.size(); ++z) {
                    this.st.insertSuffix(docId2, suffixes.get(z), true, false);
                }
            }
        }
    }

    @Override
    public float funct_f(int effectiveLength) {
        return 0.0f;
    }

    @Override
    public void pruneSuffixTree(HashMap<String, SuffixTreeNode> subSufTree) throws Exception {
        int count = 0;
        Iterator<String> it = subSufTree.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            SuffixTreeNode node = subSufTree.get(key);
            if (node.getHasPruned()) continue;
            ArrayList<Integer> docIds = node.getDocIds();
            ArrayList<Integer> titleDocs = node.getTitleDocIds();
            ArrayList<Integer> snippetDocs = node.getSnippetDocIds();
            HashMap<String, SuffixTreeNode> subTree = node.getChildren();
            StringBuffer newName = new StringBuffer();
            newName.append(key);
            count = 0;
            while (subTree.size() == 1) {
                int size2;
                Iterator<String> it2 = subTree.keySet().iterator();
                String key2 = it2.next();
                SuffixTreeNode node2 = subTree.get(key2);
                ArrayList<Integer> docIds2 = node2.getDocIds();
                int size1 = docIds.size();
                if (size1 != (size2 = docIds2.size())) break;
                docIds.retainAll(docIds2);
                if (docIds.size() != size1) break;
                newName.append(" ");
                newName.append(key2);
                subTree = node2.getChildren();
                ++count;
            }
            if (count > 0) {
                SuffixTreeNode newNode = new SuffixTreeNode();
                newNode.setChildren(subTree);
                newNode.setTitleDocIds(titleDocs);
                newNode.setSnippetDocIds(snippetDocs);
                newNode.setHasPruned(true);
                subSufTree.remove(key);
                subSufTree.put(newName.toString(), newNode);
                it = subSufTree.keySet().iterator();
            }
            if (subTree.isEmpty()) continue;
            this.pruneSuffixTree(subTree);
        }
    }

    public void scoreLabelsOf(HashMap<String, SuffixTreeNode> subTree, String subphrase) throws Exception {
        if (subTree.isEmpty()) {
            return;
        }
        ArrayList<String> queryList = this.getQueryAsVector(this.query);
        float score = 0.0f;
        Iterator<Map.Entry<String, SuffixTreeNode>> it = subTree.entrySet().iterator();
        long total = 0L;
        while (it.hasNext()) {
            Map.Entry<String, SuffixTreeNode> mapEntry = it.next();
            SuffixTreeNode treeNode = mapEntry.getValue();
            String keyPhrase = mapEntry.getKey();
            StringBuffer phrase = new StringBuffer();
            if (subphrase != null && !subphrase.equals("")) {
                phrase.append(subphrase);
                phrase.append(" ");
            }
            phrase.append(keyPhrase);
            String bcPhrase = new String(phrase.toString());
            treeNode.setPhrase(bcPhrase);
            if (!this.zeroScoreLabelsEqualTo(queryList, mapEntry) && !this.zeroScoreLabelsLabelSize(mapEntry)) {
                score = this.score(treeNode);
                treeNode.setBaseClusterScore(score);
            }
            this.bcl.add(mapEntry);
            HashMap<String, SuffixTreeNode> children = treeNode.getChildren();
            if (children.isEmpty()) continue;
            this.scoreLabelsOf(children, bcPhrase);
        }
    }

    public ArrayList<String> getQueryAsVector(String q) throws Exception {
        ArrayList<String> queryList = new ArrayList<String>();
        StringTokenizer strTok = new StringTokenizer(q, " ");
        while (strTok.hasMoreTokens()) {
            String word = strTok.nextToken().toLowerCase();
            queryList.add(this.convertWord(word));
        }
        return queryList;
    }

    private boolean zeroScoreLabelsEqualTo(ArrayList<String> queryList, Map.Entry<String, SuffixTreeNode> mapEntry) {
        ArrayList<String> labelList = new ArrayList<String>();
        StringTokenizer strTok2 = new StringTokenizer(mapEntry.getKey(), " ");
        while (strTok2.hasMoreTokens()) {
            String word = strTok2.nextToken();
            labelList.add(this.convertWord(word));
        }
        if (labelList.size() == queryList.size() && labelList.containsAll(queryList)) {
            mapEntry.getValue().setBaseClusterScore(0.0f);
            return true;
        }
        if (labelList.size() != queryList.size()) {
            boolean diff = false;
            for (String w : labelList) {
                if (queryList.contains(w)) continue;
                diff = true;
            }
            if (!diff) {
                mapEntry.getValue().setBaseClusterScore(0.0f);
                return true;
            }
        }
        return false;
    }

    private String convertWord(String word) {
        word = word.replace('\u0386', '\u0391');
        word = word.replace('\u0388', '\u0395');
        word = word.replace('\u0389', '\u0397');
        word = word.replace('\u038a', '\u0399');
        word = word.replace('\u038c', '\u039f');
        word = word.replace('\u038e', '\u03a5');
        word = word.replace('\u038f', '\u03a9');
        word = word.replace('\u03aa', '\u0399');
        word = word.replace('\u03ab', '\u03a5');
        word = word.replace('\u03ac', '\u03b1');
        word = word.replace('\u03ad', '\u03b5');
        word = word.replace('\u03ae', '\u03b7');
        word = word.replace('\u03af', '\u03b9');
        word = word.replace('\u03cc', '\u03bf');
        word = word.replace('\u03cd', '\u03c5');
        word = word.replace('\u03ce', '\u03c9');
        word = word.replace('\u03ca', '\u03b9');
        word = word.replace('\u03cb', '\u03c5');
        return word;
    }

    private boolean zeroScoreLabelsLabelSize(Map.Entry<String, SuffixTreeNode> mapEntry) {
        String label = mapEntry.getKey();
        String[] words = label.split(" ");
        if (words.length < this.LLmin || words.length > this.LLmax) {
            mapEntry.getValue().setBaseClusterScore(0.0f);
            return true;
        }
        return false;
    }

    private float score(SuffixTreeNode node) {
        int snipNum = node.getSnippetDocsSize();
        int titleNum = node.getTitleDocsSize();
        float score = 0.0f;
        if (this.in.getIdfs() != null) {
            int indexSize = this.indexSize;
            float prepPidf = this.preparedPIDF(node.getPhrase());
            score = (float)(titleNum * this.in.snippetsSize() * indexSize + snipNum * indexSize) + prepPidf;
        } else {
            score = titleNum * this.in.snippetsSize() + snipNum;
        }
        return score;
    }

    private float preparedPIDF(String phrase) {
        float sum = 0.0f;
        StringTokenizer strTok = new StringTokenizer(phrase, " ");
        float tokensNum = strTok.countTokens();
        float idf = 0.0f;
        while (strTok.hasMoreTokens()) {
            String term = strTok.nextToken();
            String stem = Stemmer.Stem(term);
            if (!this.in.getIdfs().containsKey(stem)) continue;
            idf = this.in.getIdfs().get(stem).floatValue();
            sum += idf;
        }
        return sum / tokensNum;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> getTopScored(int consumed, int missing) {
        ArrayList<Map.Entry<String, SuffixTreeNode>> topScored = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
        int limit = consumed + missing;
        int j = 0;
        for (int i = consumed; i < limit && i < this.bcl.size(); ++i) {
            ((SuffixTreeNode)((Map.Entry)this.bcl.get(i)).getValue()).setIsTopLabel(true);
            topScored.add(j++, (Map.Entry<String, SuffixTreeNode>)this.bcl.get(i));
        }
        return topScored;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> maximal(ArrayList<Map.Entry<String, SuffixTreeNode>> topLabs) {
        ArrayList<Map.Entry<String, SuffixTreeNode>> maximal = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
        ArrayList<Map.Entry<String, SuffixTreeNode>> children = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
        int index = 0;
        for (int i = 0; i < topLabs.size(); ++i) {
            Map.Entry<String, SuffixTreeNode> entry = topLabs.get(i);
            if (children.contains(entry)) continue;
            this.addNodeToChildrenList(entry, children);
            maximal.add(index++, entry);
        }
        return maximal;
    }

    private void addNodeToChildrenList(Map.Entry<String, SuffixTreeNode> entry, ArrayList<Map.Entry<String, SuffixTreeNode>> children) {
        HashMap<String, SuffixTreeNode> ChMap = entry.getValue().getChildren();
        if (!ChMap.isEmpty()) {
            for (Map.Entry<String, SuffixTreeNode> mapEntry : ChMap.entrySet()) {
                if (mapEntry.getValue().getIsTopLabel()) {
                    children.add(mapEntry);
                    this.addNodeToChildrenList(mapEntry, children);
                    continue;
                }
                if (mapEntry.getValue().getBaseClusterScore() != 0.0f) continue;
                this.addNodeToChildrenList(mapEntry, children);
            }
        }
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> findTopScoredLabels() throws Exception {
        this.scoreLabelsOf(this.st.getRootWords(), "");
        this.sortBCByScore();
        ArrayList<Map.Entry<String, SuffixTreeNode>> topLabs = this.getTopScored(0, this.getNCmax());
        int consumed = this.getNCmax();
        boolean done = false;
        int missing = 0;
        ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs = null;
        while (!done && consumed < this.bcl.size()) {
            maximalLabs = this.maximal(topLabs);
            this.eliminateSubPhrasesSameExt(maximalLabs, topLabs);
            this.checkForSubstrings(maximalLabs);
            missing = this.getNCmax() - maximalLabs.size();
            if (missing > 0) {
                ArrayList<Map.Entry<String, SuffixTreeNode>> nextTopLabs = this.getTopScored(consumed, missing);
                int index = consumed;
                for (int i = 0; i < nextTopLabs.size(); ++i) {
                    topLabs.add(index++, nextTopLabs.get(i));
                }
                consumed += missing;
                continue;
            }
            done = true;
        }
        if (missing > 0) {
            maximalLabs = this.maximal(topLabs);
            this.eliminateSubPhrasesSameExt(maximalLabs, topLabs);
            this.checkForSubstrings(maximalLabs);
        }
        return maximalLabs;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> findTopScoredLabels2() throws Exception {
        int i;
        this.scoreLabelsOf(this.st.getRootWords(), "");
        this.sortBCByScore();
        ArrayList<Map.Entry<String, SuffixTreeNode>> topLabs = this.getTopScored(0, 2 * this.getNCmax());
        int consumed = 2 * this.getNCmax();
        boolean done = false;
        int missing = 0;
        ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs = null;
        int countLoops = 0;
        while (!done && consumed < this.bcl.size()) {
            ++countLoops;
            maximalLabs = this.maximal(topLabs);
            this.eliminateSubPhrasesSameExt(maximalLabs, topLabs);
            this.checkForSubstrings(maximalLabs);
            missing = this.getNCmax() - maximalLabs.size();
            if (missing > 0) {
                ArrayList<Map.Entry<String, SuffixTreeNode>> nextTopLabs = this.getTopScored(consumed, missing * 2);
                int index = consumed;
                for (int i2 = 0; i2 < nextTopLabs.size(); ++i2) {
                    topLabs.add(index++, nextTopLabs.get(i2));
                }
                consumed += missing * 2;
                continue;
            }
            done = true;
            if (missing >= 0) continue;
            System.out.println("negative missing=" + missing);
            int maxlabSize = maximalLabs.size();
            System.out.println("max siz=" + maxlabSize);
            for (i = maxlabSize - 1; i >= this.getNCmax(); --i) {
                System.out.println("i=" + i);
                maximalLabs.remove(i);
            }
        }
        if (missing > 0) {
            maximalLabs = this.maximal(topLabs);
            this.eliminateSubPhrasesSameExt(maximalLabs, topLabs);
            this.checkForSubstrings(maximalLabs);
        } else if (missing < 0) {
            System.out.println("negative missing=" + missing);
            int maxlabSize = maximalLabs.size();
            System.out.println("max siz=" + maxlabSize);
            for (i = maxlabSize - 1; i >= this.getNCmax(); --i) {
                System.out.println("i=" + i);
                maximalLabs.remove(i);
            }
        }
        System.out.println("Loops Num=" + countLoops);
        return maximalLabs;
    }

    private void eliminateSubPhrasesSameExt(ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs, ArrayList<Map.Entry<String, SuffixTreeNode>> topLabs) throws Exception {
        int i;
        ArrayList<Map.Entry<String, SuffixTreeNode>> dominators = new ArrayList<Map.Entry<String, SuffixTreeNode>>();
        for (i = 0; i < topLabs.size(); ++i) {
            if (maximalLabs.contains(topLabs.get(i))) continue;
            dominators.add(topLabs.get(i));
        }
        block1: for (i = 0; i < maximalLabs.size(); ++i) {
            for (int j = 0; j < dominators.size(); ++j) {
                SuffixTreeNode maxNode;
                String label1 = this.convertWord(maximalLabs.get(i).getValue().getPhrase());
                String dPhrase = this.convertWord(((SuffixTreeNode)((Map.Entry)dominators.get(j)).getValue()).getPhrase());
                if (dPhrase.endsWith(label1)) {
                    SuffixTreeNode domNode;
                    maxNode = maximalLabs.get(i).getValue();
                    if (!maxNode.hasSameDocsWith(domNode = (SuffixTreeNode)((Map.Entry)dominators.get(j)).getValue())) continue;
                    maximalLabs.remove(i);
                    --i;
                    continue block1;
                }
                if (!label1.endsWith(dPhrase)) continue;
                maxNode = maximalLabs.get(i).getValue();
                ArrayList<Integer> maxNodeDocs = maxNode.getDocIds();
                SuffixTreeNode domNode = (SuffixTreeNode)((Map.Entry)dominators.get(j)).getValue();
                ArrayList<Integer> domNodeDocs = domNode.getDocIds();
                if (!maxNode.hasSameDocsWith(domNode)) continue;
                HashMap<String, SuffixTreeNode> children = domNode.getChildren();
                dominators.remove(j);
                domNode.setIsTopLabel(false);
                --j;
                j = this.deleteNonMaximalEntries(children, dominators, j);
            }
        }
    }

    private int deleteNonMaximalEntries(HashMap<String, SuffixTreeNode> children, ArrayList<Map.Entry<String, SuffixTreeNode>> dominators, int index) {
        for (Map.Entry<String, SuffixTreeNode> child : children.entrySet()) {
            if (!dominators.contains(child)) continue;
            dominators.remove(child);
            child.getValue().setIsTopLabel(false);
            if (index > 0) {
                --index;
            }
            index = this.deleteNonMaximalEntries(child.getValue().getChildren(), dominators, index);
        }
        return index;
    }

    private void checkForSubstrings(ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs) throws Exception {
        block0: for (int i = 0; i < maximalLabs.size(); ++i) {
            SuffixTreeNode node1 = maximalLabs.get(i).getValue();
            String key1 = this.convertWord(maximalLabs.get(i).getKey());
            for (int j = i + 1; j < maximalLabs.size(); ++j) {
                String label2;
                SuffixTreeNode node2 = maximalLabs.get(j).getValue();
                String key2 = this.convertWord(maximalLabs.get(j).getKey());
                boolean h1 = false;
                boolean h2 = false;
                int count1 = 0;
                int count2 = 0;
                if (key1.equals(key2)) {
                    if (node1.hasTopLabsChildren()) {
                        h1 = true;
                    } else if (node2.hasTopLabsChildren()) {
                        h2 = true;
                    }
                    if (h1 && h2) {
                        count1 = node1.countTopLabsChildren();
                        if (count1 < (count2 = node2.countTopLabsChildren())) {
                            node2.mergeDocumentSets(node1);
                            maximalLabs.remove(i);
                            --i;
                            continue block0;
                        }
                        node1.getDocIds().addAll(node2.getDocIds());
                        maximalLabs.remove(j);
                        --j;
                        continue;
                    }
                    if (h1) {
                        node1.mergeDocumentSets(node2);
                        maximalLabs.remove(j);
                        --j;
                        continue;
                    }
                    if (!h2 && (h1 || h2)) continue;
                    node2.mergeDocumentSets(node1);
                    maximalLabs.remove(i);
                    --i;
                    continue block0;
                }
                String label1 = this.convertWord(node1.getPhrase());
                if (label1.endsWith(label2 = this.convertWord(node2.getPhrase()))) {
                    if (!node1.hasSameDocsWith(node2)) continue;
                    maximalLabs.remove(j);
                    --j;
                    continue;
                }
                if (!label2.endsWith(label1) || !node1.hasSameDocsWith(node2)) continue;
                maximalLabs.remove(i);
                --i;
                continue block0;
            }
        }
    }

    public ArrayList<Cluster> createFinalClusters(ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs) throws Exception {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        int index = 0;
        if (maximalLabs == null) {
            return clusters;
        }
        for (int i = 0; i < maximalLabs.size(); ++i) {
            Map.Entry<String, SuffixTreeNode> entry = maximalLabs.get(i);
            SuffixTreeNode node = entry.getValue();
            float score = node.getBaseClusterScore();
            ArrayList<Integer> docs = this.sortDocumentsByRank(node.getDocIds());
            String label = entry.getKey();
            Cluster cl = new Cluster(label, score, docs, null);
            clusters.add(index++, cl);
            HashMap<String, SuffixTreeNode> children = entry.getValue().getChildren();
            this.createHierarchy(cl, children);
        }
        return clusters;
    }

    private String findLabelOfMaximalNode(Map.Entry<String, SuffixTreeNode> entry) {
        String phrase;
        String label = entry.getKey();
        if (!label.equals(phrase = entry.getValue().getPhrase())) {
            label = phrase;
        }
        return label;
    }

    public void createHierarchy(Cluster cl, HashMap<String, SuffixTreeNode> children) throws Exception {
        if (!children.isEmpty()) {
            ArrayList<Cluster> cl_children = new ArrayList<Cluster>();
            for (String key : children.keySet()) {
                SuffixTreeNode childNode = children.get(key);
                if (childNode.getIsTopLabel()) {
                    ArrayList<Integer> docs = this.sortDocumentsByRank(childNode.getDocIds());
                    Cluster cl_child = new Cluster(key, childNode.getBaseClusterScore(), docs, null);
                    cl_children.add(cl_child);
                    this.createHierarchy(cl_child, childNode.getChildren());
                    continue;
                }
                if (childNode.getBaseClusterScore() != 0.0f) continue;
                this.createHierarchy(cl, childNode.getChildren());
            }
            if (!cl_children.isEmpty()) {
                if (cl_children.size() == 1) {
                    Cluster child;
                    int childDocSize;
                    int fatherDocSize = cl.getDocuments().size();
                    if (fatherDocSize == (childDocSize = (child = cl_children.get(0)).getDocuments().size())) {
                        StringBuffer name = new StringBuffer(cl.getLabel());
                        name.append(" ");
                        name.append(child.getLabel());
                        cl.setLabel(name.toString());
                        cl.setChildren(child.getChildren());
                    } else {
                        cl.setChildren(cl_children);
                    }
                } else {
                    Output.sortByScore(cl_children);
                    cl.setChildren(cl_children);
                }
            }
        }
    }

    private void sortBCByScore() {
        Collections.sort(this.bcl, ORDER_BY_NODE_SCORE);
    }

    protected void sortByScore(List<Map.Entry<String, SuffixTreeNode>> list) {
        Collections.sort(list, ORDER_BY_NODE_SCORE);
    }

    private void printMaximalLabs(ArrayList<Map.Entry<String, SuffixTreeNode>> maximalLabs) {
        System.out.println("----------- Maximal --------");
        for (int i = 0; i < maximalLabs.size(); ++i) {
            System.out.println(i + "=" + maximalLabs.get(i).getKey() + " phrase=" + maximalLabs.get(i).getValue().getPhrase() + " score=" + maximalLabs.get(i).getValue().getBaseClusterScore());
        }
        System.out.println("----------- End Maximal --------");
    }
}

