/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.clusterer;

import gr.forth.ics.isl.stellaclustering.Input;
import gr.forth.ics.isl.stellaclustering.SuffixTree;
import gr.forth.ics.isl.stellaclustering.SuffixTreeNode;
import gr.forth.ics.isl.stellaclustering.clusterer.Cluster;
import gr.forth.ics.isl.stellaclustering.clusterer.Clusterer;
import gr.forth.ics.isl.stellaclustering.util.byValueComparator;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class STC
implements Clusterer {
    protected Input in;
    protected SuffixTree st;
    protected float simThreshold;
    protected ArrayList<Map.Entry<String, SuffixTreeNode>> bcl;
    protected HashMap<String, Integer> VocabFrequencies;

    public STC() {
        this.st = new SuffixTree();
        this.simThreshold = 0.5f;
        this.bcl = new ArrayList();
        this.VocabFrequencies = new HashMap();
    }

    public STC(Input in) {
        this.in = in;
        this.st = new SuffixTree();
        this.simThreshold = 0.5f;
        this.bcl = new ArrayList();
        this.VocabFrequencies = new HashMap();
    }

    public STC(Input in, float threshold) {
        this.in = in;
        this.st = new SuffixTree();
        this.simThreshold = threshold;
        this.bcl = new ArrayList();
        this.VocabFrequencies = new HashMap();
    }

    @Override
    public abstract void setInputData(Input var1);

    public void setST(SuffixTree st) {
        this.st = st;
    }

    public void setBcl(ArrayList<Map.Entry<String, SuffixTreeNode>> baseCl) {
        this.bcl = baseCl;
    }

    public void setSimThreshold(float threshold) {
        this.simThreshold = threshold;
    }

    public SuffixTree getST() {
        return this.st;
    }

    public ArrayList<Map.Entry<String, SuffixTreeNode>> getBcl() {
        return this.bcl;
    }

    public float getSimThreshold() {
        return this.simThreshold;
    }

    @Override
    public abstract void constructSuffixTree() throws Exception;

    @Override
    public ArrayList<String> generateSuffixes(String sent) {
        ArrayList<String> suffixes = new ArrayList<String>();
        String[] words = sent.split(" ");
        int wLen = words.length;
        for (int i = 0; i < wLen; ++i) {
            StringBuffer suffix = new StringBuffer();
            for (int j = i; j < wLen; ++j) {
                suffix.append(words[j]);
                suffix.append(" ");
            }
            suffixes.add(suffix.toString().trim());
        }
        return suffixes;
    }

    @Override
    public abstract void pruneSuffixTree(HashMap<String, SuffixTreeNode> var1) throws Exception;

    public abstract float funct_f(int var1);

    public HashMap<Integer, ArrayList<Integer>> mergeBaseClusters() throws Exception {
        HashMap<Integer, ArrayList<Integer>> mergedClusters = new HashMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < this.bcl.size(); ++i) {
            ArrayList<Object> docList1 = new ArrayList();
            ArrayList<Integer> docList2 = new ArrayList();
            Map.Entry<String, SuffixTreeNode> entry = this.bcl.get(i);
            docList1 = entry.getValue().getDocIds();
            for (int j = i + 1; j < this.bcl.size(); ++j) {
                ArrayList indexes;
                ArrayList<Integer> copyDocList1 = new ArrayList<Integer>(docList1);
                Map.Entry<String, SuffixTreeNode> currEntry = this.bcl.get(j);
                docList2 = currEntry.getValue().getDocIds();
                if (!this.baseClustersOverlap(copyDocList1, docList2)) continue;
                if (!mergedClusters.containsKey(new Integer(i))) {
                    indexes = new ArrayList();
                    mergedClusters.put(new Integer(i), indexes);
                }
                mergedClusters.get(new Integer(i)).add(new Integer(j));
                if (!mergedClusters.containsKey(new Integer(j))) {
                    indexes = new ArrayList();
                    mergedClusters.put(new Integer(j), indexes);
                }
                mergedClusters.get(new Integer(j)).add(new Integer(i));
            }
        }
        return mergedClusters;
    }

    private boolean baseClustersOverlap(ArrayList<Integer> docA, ArrayList<Integer> docB) {
        float docASize = docA.size();
        float docBSize = docB.size();
        float intersectionSize = 0.0f;
        docA.retainAll(docB);
        intersectionSize = docA.size();
        float overlap1 = intersectionSize / docASize;
        float overlap2 = intersectionSize / docBSize;
        return overlap1 > this.simThreshold && overlap2 > this.simThreshold;
    }

    @Override
    public abstract ArrayList<Cluster> clustering() throws Exception;

    public void unionOfLists(ArrayList<Integer> l, ArrayList<Integer> toAdd) throws Exception {
        for (int i = 0; i < toAdd.size(); ++i) {
            if (l.contains(toAdd.get(i))) continue;
            l.add(toAdd.get(i));
        }
    }

    public int effectiveLength(String phrase) throws Exception {
        String[] words = phrase.split(" ");
        int effectiveLen = words.length;
        float percent = (float)(0.4 * (double)this.in.snippetsSize());
        if (percent > 8.4f) {
            for (int i = 0; i < words.length; ++i) {
                int num = 0;
                if (this.VocabFrequencies.containsKey(words[i])) {
                    num = this.VocabFrequencies.get(words[i]);
                } else {
                    num = this.findDocsThatContain(words[i], this.st.getRootWords(), new ArrayList<Integer>());
                    this.VocabFrequencies.put(words[i], new Integer(num));
                }
                if (num > 3 && !((float)num > percent)) continue;
                --effectiveLen;
            }
        }
        return effectiveLen;
    }

    public int findDocsThatContain(String str, HashMap<String, SuffixTreeNode> subTree, ArrayList<Integer> docList) throws Exception {
        if (subTree.isEmpty()) {
            return 0;
        }
        Iterator<String> it = subTree.keySet().iterator();
        int docCount = 0;
        int tmpCount = 0;
        while (it.hasNext()) {
            tmpCount = 0;
            String phrase = it.next();
            SuffixTreeNode node = subTree.get(phrase);
            if (phrase.contains(str)) {
                int docsBefore = docList.size();
                this.unionOfLists(docList, node.getDocIds());
                int docsAfter = docList.size();
                tmpCount = docsAfter - docsBefore;
            } else {
                HashMap<String, SuffixTreeNode> children = node.getChildren();
                if (!children.isEmpty()) {
                    tmpCount = this.findDocsThatContain(str, children, docList);
                }
            }
            docCount += tmpCount;
        }
        return docCount;
    }

    public ArrayList<Integer> sortDocumentsByRank(ArrayList<Integer> docs) {
        LinkedHashMap<Integer, Float> objMap = this.in.getDocIds();
        LinkedHashMap<Integer, Float> map = new LinkedHashMap<Integer, Float>();
        for (Integer docid : docs) {
            Float rank = objMap.get(docid);
            map.put(docid, rank);
        }
        byValueComparator bvc = new byValueComparator(map);
        ArrayList<Integer> keys = new ArrayList<Integer>(map.keySet());
        Collections.sort(keys, bvc);
        return keys;
    }

    protected void printBaseClusters(ArrayList<Map.Entry<String, SuffixTreeNode>> s) throws Exception {
        Map.Entry<String, SuffixTreeNode> entry = null;
        System.out.println("entry size=" + s.size());
        for (int i = 0; i < s.size(); ++i) {
            entry = s.get(i);
            SuffixTreeNode node = entry.getValue();
            System.out.println("String=|" + node.getPhrase() + "| score=" + node.getBaseClusterScore() + " doc=" + node.getDocIds().toString() + " titleNum=" + node.getTitleDocsSize());
        }
    }

    protected void printBaseClustersToFile(ArrayList<Map.Entry<String, SuffixTreeNode>> s) {
        try {
            File f = new File("/spare/mitos/skopidak/mitos/mitos-t1/baseCl.txt");
            FileOutputStream fout = new FileOutputStream(f);
            StringBuffer buff = new StringBuffer();
            Map.Entry<String, SuffixTreeNode> entry = null;
            for (int i = 0; i < s.size(); ++i) {
                entry = s.get(i);
                buff.append("i=");
                buff.append(i);
                buff.append("String=|");
                buff.append(entry.getValue().getPhrase());
                buff.append("| score=");
                buff.append(entry.getValue().getBaseClusterScore());
                buff.append(" docd=");
                buff.append(entry.getValue().getDocIds().toString());
                buff.append("\n");
            }
            fout.write(buff.toString().getBytes());
            fout.close();
        }
        catch (Exception e) {
            System.out.println("file not found exception");
        }
    }

    private void printMergedBaseClusters(HashMap<Integer, ArrayList<Integer>> indexes) {
        System.out.println("---------- Merged Indexes --------------");
        Iterator<Integer> it = indexes.keySet().iterator();
        Integer baseIndex = 0;
        while (it.hasNext()) {
            baseIndex = it.next();
            ArrayList<Integer> mergedInd = indexes.get(baseIndex);
            System.out.println("base i=" + baseIndex + "\tmerged with j=" + mergedInd.toString());
        }
    }

    private void printMergedBaseClustersToFile(HashMap<Integer, ArrayList<Integer>> indexes) {
        try {
            File f = new File("/spare/mitos/skopidak/mitos/mitos-t1/merged.txt");
            FileOutputStream fout = new FileOutputStream(f);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < indexes.size(); ++i) {
                ArrayList<Integer> mergedInd = indexes.get(i);
                buff.append("base i=");
                buff.append(i);
                buff.append("\tmerged with j=");
                buff.append(mergedInd.toString());
                buff.append("\n");
            }
            fout.write(buff.toString().getBytes());
            fout.close();
        }
        catch (Exception e) {
            System.out.println("file not found exception");
        }
    }

    private void printVocabFreq() {
        System.out.println("----- Vocab Freq ------");
        for (String word : this.VocabFrequencies.keySet()) {
            Integer docsNum = this.VocabFrequencies.get(word);
            System.out.println("word=" + word + "\t num=" + docsNum);
        }
    }
}

