/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.clusterer;

import gr.forth.ics.isl.stellaclustering.Input;
import gr.forth.ics.isl.stellaclustering.Snippet;
import gr.forth.ics.isl.stellaclustering.SuffixTreeNode;
import gr.forth.ics.isl.stellaclustering.clusterer.Cluster;
import gr.forth.ics.isl.stellaclustering.clusterer.STC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STC_Orig
extends STC {
    public STC_Orig() {
    }

    public STC_Orig(Input in) {
        super(in);
    }

    public STC_Orig(Input in, float threshold) {
        super(in, threshold);
    }

    @Override
    public void setInputData(Input in) {
        this.in = in;
    }

    @Override
    public void constructSuffixTree() throws Exception {
        Integer docId2 = null;
        Snippet snippet = new Snippet();
        int i = 0;
        for (Integer docId2 : this.in.getSnippets().keySet()) {
            int z;
            ArrayList<String> suffixes;
            snippet = this.in.getSnippets().get(docId2);
            ArrayList<String> tit = snippet.getTitle();
            ArrayList<String> bt = snippet.getBestText();
            for (i = 0; i < tit.size(); ++i) {
                suffixes = this.generateSuffixes(tit.get(i));
                for (z = 0; z < suffixes.size(); ++z) {
                    this.st.insertSuffix(docId2, suffixes.get(z), false, false);
                }
            }
            for (i = 0; i < bt.size(); ++i) {
                suffixes = this.generateSuffixes(bt.get(i));
                for (z = 0; z < suffixes.size(); ++z) {
                    this.st.insertSuffix(docId2, suffixes.get(z), false, false);
                }
            }
        }
    }

    @Override
    public void pruneSuffixTree(HashMap<String, SuffixTreeNode> subSufTree) throws Exception {
        int count = 0;
        Iterator<String> it = subSufTree.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            SuffixTreeNode node = subSufTree.get(key);
            if (node.getHasPruned()) continue;
            ArrayList<Integer> docIds = node.getSnippetDocIds();
            HashMap<String, SuffixTreeNode> subTree = node.getChildren();
            StringBuffer newName = new StringBuffer();
            newName.append(key);
            count = 0;
            while (subTree.size() == 1) {
                int size2;
                Iterator<String> it2 = subTree.keySet().iterator();
                String key2 = it2.next();
                SuffixTreeNode node2 = subTree.get(key2);
                ArrayList<Integer> docIds2 = node2.getSnippetDocIds();
                int size1 = docIds.size();
                if (size1 != (size2 = docIds2.size())) break;
                docIds.retainAll(docIds2);
                if (docIds.size() != size1) break;
                newName.append(" ");
                newName.append(key2);
                subTree = node2.getChildren();
                ++count;
            }
            if (count > 0) {
                SuffixTreeNode newNode = new SuffixTreeNode();
                newNode.setChildren(subTree);
                newNode.setSnippetDocIds(docIds);
                newNode.setHasPruned(true);
                subSufTree.remove(key);
                subSufTree.put(newName.toString(), newNode);
                it = subSufTree.keySet().iterator();
            }
            if (subTree.isEmpty()) continue;
            this.pruneSuffixTree(subTree);
        }
    }

    @Override
    public float funct_f(int effectiveLength) {
        float grade = 0.0f;
        if (effectiveLength <= 1) {
            grade = 0.5f;
        } else if (effectiveLength >= 2 && effectiveLength <= 6) {
            grade = effectiveLength;
        } else if (effectiveLength > 6) {
            grade = 7.0f;
        }
        return grade;
    }

    public int identifyBaseClusters(HashMap<String, SuffixTreeNode> subTree, String subphrase, int effLen, int index) throws Exception {
        if (subTree.isEmpty()) {
            return index;
        }
        float score = 0.0f;
        int effectiveLength = 0;
        for (Map.Entry<String, SuffixTreeNode> mapEntry : subTree.entrySet()) {
            SuffixTreeNode treeNode = mapEntry.getValue();
            String keyPhrase = mapEntry.getKey();
            int docNum = treeNode.getSnippetDocsSize();
            StringBuffer Phrase = new StringBuffer();
            if (subphrase != null && !subphrase.equals("")) {
                Phrase.append(subphrase);
                Phrase.append(" ");
            }
            Phrase.append(keyPhrase);
            if (docNum < 2) continue;
            effectiveLength = effLen + this.effectiveLength(keyPhrase);
            score = (float)docNum * this.funct_f(effectiveLength);
            treeNode.setBaseClusterScore(score);
            treeNode.setPhrase(new String(Phrase.toString()));
            this.bcl.add(index++, mapEntry);
            HashMap<String, SuffixTreeNode> children = treeNode.getChildren();
            if (children.isEmpty()) continue;
            index = this.identifyBaseClusters(children, Phrase.toString(), effectiveLength, index);
        }
        return index;
    }

    public ArrayList<Cluster> createFinalClusters(HashMap<Integer, ArrayList<Integer>> mergedClusters) throws Exception {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        ArrayList<Integer> visitedIndexes = new ArrayList<Integer>();
        SuffixTreeNode tmpNode = new SuffixTreeNode();
        int maxScoreDocNum = 0;
        for (int index = 0; index < mergedClusters.size(); ++index) {
            if (visitedIndexes.contains(new Integer(index))) continue;
            visitedIndexes.add(new Integer(index));
            Map.Entry stcEntry = (Map.Entry)this.bcl.get(index);
            SuffixTreeNode startNode = (SuffixTreeNode)stcEntry.getValue();
            tmpNode.setPhrase(startNode.getPhrase());
            tmpNode.setBaseClusterScore(startNode.getBaseClusterScore());
            tmpNode.setSnippetDocIds((ArrayList)startNode.getSnippetDocIds().clone());
            maxScoreDocNum = tmpNode.getSnippetDocsSize();
            this.recursiveMergeIndexes(mergedClusters, index, tmpNode, maxScoreDocNum, visitedIndexes);
            ArrayList clone = (ArrayList)tmpNode.getSnippetDocIds().clone();
            String maxScorePhrase = tmpNode.getPhrase();
            int len = this.effectiveLength(maxScorePhrase);
            float new_score = (float)clone.size() * this.funct_f(len);
            ArrayList<Integer> docsLi = this.sortDocumentsByRank(clone);
            Cluster cl = new Cluster(maxScorePhrase, new_score, docsLi, null);
            clusters.add(cl);
        }
        return clusters;
    }

    private void recursiveMergeIndexes(HashMap<Integer, ArrayList<Integer>> mergedClusters, int index, SuffixTreeNode tmpNode, float maxScoreDocNum, ArrayList<Integer> visitedIndexes) throws Exception {
        float score = 0.0f;
        ArrayList<Integer> mergedIndex = mergedClusters.get(index);
        if (mergedIndex == null) {
            return;
        }
        for (int i = 0; i < mergedIndex.size(); ++i) {
            if (visitedIndexes.contains(mergedIndex.get(i))) continue;
            visitedIndexes.add(mergedIndex.get(i));
            SuffixTreeNode node = (SuffixTreeNode)((Map.Entry)this.bcl.get(mergedIndex.get(i))).getValue();
            score = node.getBaseClusterScore();
            float maxScore = tmpNode.getBaseClusterScore();
            if (score >= maxScore) {
                if (score == maxScore) {
                    if (maxScoreDocNum < (float)node.getSnippetDocsSize()) {
                        maxScoreDocNum = node.getSnippetDocsSize();
                        tmpNode.setPhrase(node.getPhrase());
                    }
                } else {
                    maxScoreDocNum = node.getSnippetDocsSize();
                    tmpNode.setPhrase(node.getPhrase());
                }
                tmpNode.setBaseClusterScore(score);
            }
            this.unionOfLists(tmpNode.getSnippetDocIds(), node.getSnippetDocIds());
            this.recursiveMergeIndexes(mergedClusters, mergedIndex.get(i), tmpNode, maxScoreDocNum, visitedIndexes);
        }
    }

    @Override
    public ArrayList<Cluster> clustering() throws Exception {
        this.constructSuffixTree();
        this.pruneSuffixTree(this.st.getRootWords());
        this.identifyBaseClusters(this.st.getRootWords(), "", 0, 0);
        HashMap<Integer, ArrayList<Integer>> mergedClusters = this.mergeBaseClusters();
        ArrayList<Cluster> clusters = this.createFinalClusters(mergedClusters);
        return clusters;
    }
}

