/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.clusterer;

import gr.forth.ics.isl.stellaclustering.Input;
import gr.forth.ics.isl.stellaclustering.SuffixTreeNode;
import gr.forth.ics.isl.stellaclustering.clusterer.STC_Plus;
import gr.forth.ics.isl.stellaclustering.stemmer.Stemmer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STC_PlusPlus
extends STC_Plus {
    private int indexSize;

    public STC_PlusPlus() {
    }

    public STC_PlusPlus(Input in, float threshold) {
        super(in, threshold);
    }

    @Override
    public int identifyBaseClusters(HashMap<String, SuffixTreeNode> subTree, String subphrase, int effLen, int index) throws Exception {
        if (subTree.isEmpty()) {
            return index;
        }
        float score = 0.0f;
        int effectiveLength = 0;
        for (Map.Entry<String, SuffixTreeNode> mapEntry : subTree.entrySet()) {
            SuffixTreeNode treeNode = mapEntry.getValue();
            String keyPhrase = mapEntry.getKey();
            int docNum = treeNode.countDocIds();
            StringBuffer Phrase = new StringBuffer();
            if (subphrase != null && !subphrase.equals("")) {
                Phrase.append(subphrase);
                Phrase.append(" ");
            }
            Phrase.append(keyPhrase);
            if (docNum < 2) continue;
            treeNode.setPhrase(new String(Phrase.toString()));
            score = this.score(treeNode);
            treeNode.setBaseClusterScore(score);
            this.bcl.add(index++, mapEntry);
            HashMap<String, SuffixTreeNode> children = treeNode.getChildren();
            if (children.isEmpty()) continue;
            index = this.identifyBaseClusters(children, Phrase.toString(), effectiveLength, index);
        }
        return index;
    }

    private float score(SuffixTreeNode node) {
        int snipNum = node.getSnippetDocsSize();
        int titleNum = node.getTitleDocsSize();
        float score = 0.0f;
        if (this.in.getIdfs() != null) {
            int indexSize = this.indexSize;
            float prepPidf = this.preparedPIDF(node.getPhrase());
            score = (float)(titleNum * this.in.snippetsSize() * indexSize + snipNum * indexSize) + prepPidf;
        } else {
            score = titleNum * this.in.snippetsSize() + snipNum;
        }
        return score;
    }

    private float preparedPIDF(String phrase) {
        float sum = 0.0f;
        StringTokenizer strTok = new StringTokenizer(phrase, " ");
        float tokensNum = strTok.countTokens();
        float idf = 0.0f;
        while (strTok.hasMoreTokens()) {
            String term = strTok.nextToken();
            String stem = Stemmer.Stem(term);
            if (!this.in.getIdfs().containsKey(stem)) continue;
            idf = this.in.getIdfs().get(stem).floatValue();
            sum += idf;
        }
        return sum / tokensNum;
    }
}

