/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.lexicalanalyzer;

import gr.forth.ics.isl.stellaclustering.lexicalanalyzer.FileTerms;
import gr.forth.ics.isl.stellaclustering.lexicalanalyzer.LexicalAnalyzerProperties;
import gr.forth.ics.isl.stellaclustering.resources.Resources;
import gr.forth.ics.isl.stellaclustering.stemmer.Stemmer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalAnalyzer {
    static final String LOGSFOLDER = Resources.LOGSFOLDER;
    private String rep_file_name;
    private LexicalAnalyzerProperties properties;

    public LexicalAnalyzer() {
        Stemmer.Initialize();
        this.properties = new LexicalAnalyzerProperties();
    }

    public LexicalAnalyzer(LexicalAnalyzerProperties properties) {
        Stemmer.Initialize();
        this.properties = properties;
    }

    private void storeTextFile(String text) throws IOException {
        if (this.properties.getStoreTxt()) {
            int ch;
            StringReader reader = new StringReader(text);
            File dst = new File(this.rep_file_name);
            File folder = new File(this.properties.text_repository);
            folder.mkdirs();
            int SIZE = 0x800000;
            reader.mark(SIZE);
            BufferedWriter out = null;
            OutputStreamWriter owriter = new OutputStreamWriter((OutputStream)new FileOutputStream(dst), "UTF-8");
            out = new BufferedWriter(owriter);
            int flag = 0;
            while ((ch = reader.read()) != -1) {
                if (ch == 10) {
                    flag = 2;
                    continue;
                }
                if (Character.isWhitespace(ch) || ch == 10) {
                    if (flag != 0) continue;
                    flag = 1;
                    continue;
                }
                if (flag == 2) {
                    out.write(10);
                } else if (flag == 1) {
                    out.write(32);
                }
                flag = 0;
                out.write(ch);
            }
            reader.reset();
            out.close();
        }
    }

    public ArrayList<String> stringAnalyze(ArrayList<String> text) throws IOException {
        StringTokenizer tokenizer = null;
        StringBuffer sb = null;
        String token = null;
        FileTerms fileTerms = new FileTerms(this.properties);
        int ins = 0;
        ArrayList<String> textArray = new ArrayList<String>();
        for (int i = 0; i < text.size(); ++i) {
            tokenizer = new StringTokenizer(text.get(i));
            sb = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                String tok;
                token = tokenizer.nextToken();
                if ((token = token.toLowerCase().trim()).isEmpty() || (tok = fileTerms.getValidToken(token)) == null) continue;
                sb.append(tok);
                sb.append(" ");
            }
            int len = sb.length() - 1;
            if (len > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (sb.length() <= 0) continue;
            textArray.add(ins++, sb.toString());
        }
        return textArray;
    }
}

