/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.lexicalanalyzer;

import gr.forth.ics.isl.stellaclustering.resources.Resources;
import gr.forth.ics.isl.stellaclustering.stemmer.StopWords;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalAnalyzerProperties {
    public final String text_repository = Resources.TEXTFOLDER;
    private int MINWORD = 2;
    private int MAXWORD = 30;
    private int MAXSAMECHARACTERS = 4;
    private boolean blockTermsStartingWithNumbers = true;
    private boolean blockTermsWithNumbers = true;
    private boolean blockTermsWithPunctuation = true;
    private boolean blockGreekTerms = false;
    private boolean blockTermsWithManySameCharacters = true;
    private boolean storeTxt = true;
    private boolean useStemmer = Resources.useStemming;
    private boolean storeTermPos = true;
    private boolean blockStopWords = Resources.useStopWords;
    private boolean holdBestUnstemmed = true;
    private String encoding = "ISO-8859-7";
    private TreeMap<String, TreeMap<String, Integer>> unstemmedWords = new TreeMap();

    public TreeMap<String, TreeMap<String, Integer>> getUnstemmedWords() {
        return this.unstemmedWords;
    }

    public boolean isStopWord(String word) {
        return StopWords.isStopWord(this.convertWord(word));
    }

    private String convertWord(String word) {
        word = word.replace('\u0386', '\u0391');
        word = word.replace('\u0388', '\u0395');
        word = word.replace('\u0389', '\u0397');
        word = word.replace('\u038a', '\u0399');
        word = word.replace('\u038c', '\u039f');
        word = word.replace('\u038e', '\u03a5');
        word = word.replace('\u038f', '\u03a9');
        word = word.replace('\u03aa', '\u0399');
        word = word.replace('\u03ab', '\u03a5');
        word = word.replace('\u03ac', '\u03b1');
        word = word.replace('\u03ad', '\u03b5');
        word = word.replace('\u03ae', '\u03b7');
        word = word.replace('\u03af', '\u03b9');
        word = word.replace('\u03cc', '\u03bf');
        word = word.replace('\u03cd', '\u03c5');
        word = word.replace('\u03ce', '\u03c9');
        word = word.replace('\u03ca', '\u03b9');
        word = word.replace('\u03cb', '\u03c5');
        return word;
    }

    public void setBlockTermsStartingWithNumbers(boolean value) {
        this.blockTermsStartingWithNumbers = value;
    }

    public boolean getBlockTermsStartingWithNumbers() {
        return this.blockTermsStartingWithNumbers;
    }

    public void setBlockTermsWithNumbers(boolean value) {
        this.blockTermsWithNumbers = value;
    }

    public boolean getBlockTermsWithNumbers() {
        return this.blockTermsWithNumbers;
    }

    public void setBlockTermsWithPunctuation(boolean value) {
        this.blockTermsWithPunctuation = value;
    }

    public boolean getBlockTermsWithPunctuation() {
        return this.blockTermsWithPunctuation;
    }

    public void setBlockGreekTerms(boolean value) {
        this.blockGreekTerms = value;
    }

    public boolean getBlockGreekTerms() {
        return this.blockGreekTerms;
    }

    public void setBlockTermsWithManySameCharacters(boolean value) {
        this.blockTermsWithManySameCharacters = value;
    }

    public boolean getBlockTermsWithManySameCharacters() {
        return this.blockTermsWithManySameCharacters;
    }

    public void setStoreTxt(boolean value) {
        this.storeTxt = value;
    }

    public boolean getStoreTxt() {
        return this.storeTxt;
    }

    public void setUseStemmer(boolean value) {
        this.useStemmer = value;
    }

    public boolean getUseStemmer() {
        return this.useStemmer;
    }

    public void setStoreTermPos(boolean value) {
        this.storeTermPos = value;
    }

    public boolean getStoreTermPos() {
        return this.storeTermPos;
    }

    public void setBlockStopWords(boolean value) {
        this.blockStopWords = value;
    }

    public boolean getBlockStopWords() {
        return this.blockStopWords;
    }

    public void setHoldBestUnstemmed(boolean value) {
        this.holdBestUnstemmed = value;
    }

    public boolean getHoldBestUnstemmed() {
        return this.holdBestUnstemmed;
    }

    public void setDefaultEncoding(String value) {
        this.encoding = value;
    }

    public String getDefaultEncoding() {
        return this.encoding;
    }

    public void setMinWord(int min) {
        this.MINWORD = min;
    }

    public int getMinWord() {
        return this.MINWORD;
    }

    public void setMaxWord(int max) {
        this.MAXWORD = max;
    }

    public int getMaxWord() {
        return this.MAXWORD;
    }

    public void setMaxSameCharacters(int max) {
        this.MAXSAMECHARACTERS = max;
    }

    public int getMaxSameCharacters() {
        return this.MAXSAMECHARACTERS;
    }
}

