/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.stemmer;

import gr.forth.ics.isl.stellaclustering.resources.Resources;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;

public class StopWords {
    private BufferedReader br;
    private StringBuffer strBuf;
    private static HashSet<String> words;
    private static StopWords m_stopWords;

    private StopWords() {
        words = new HashSet();
        if (Resources.useStopWords) {
            try {
                int ch;
                this.br = new BufferedReader(new FileReader(Resources.STOPLIST));
                this.strBuf = new StringBuffer();
                while ((ch = this.br.read()) != -1) {
                    this.strBuf.append((char)ch);
                }
                StringTokenizer strTok = new StringTokenizer(this.strBuf.toString());
                while (strTok.hasMoreTokens()) {
                    String word = new String(strTok.nextToken().getBytes(), "utf-8");
                    words.add(word);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("FileNotFoundException found! File" + Resources.STOPLIST);
            }
            catch (IOException e) {
                System.out.println("IOException found!");
            }
        }
    }

    public static void Initialize() {
        m_stopWords = m_stopWords == null ? new StopWords() : m_stopWords;
    }

    public static boolean isStopWord(String word) {
        StopWords.Initialize();
        return words.contains(word);
    }

    public static boolean isOpWord(String word) {
        StopWords.Initialize();
        return word.compareToIgnoreCase("and") == 0 || word.compareToIgnoreCase("or") == 0 || word.compareToIgnoreCase("not") == 0;
    }

    static {
        m_stopWords = null;
    }
}

