/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.stemmer.greek;

import gr.forth.ics.isl.stellaclustering.resources.Resources;
import gr.forth.ics.isl.stellaclustering.stemmer.trie.Trie;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreekStemmer {
    private static GreekStemmer m_greekStemmer = null;
    private Trie m_endings;
    private Trie m_prefixes;
    private Trie m_unmatched;
    private Trie m_irregular;
    private final int MINIMUM_WORD_LENGTH;
    private TreeMap<Character, Character> m_accents = new TreeMap();
    private boolean m_perfectMatch = true;
    BufferedWriter outfile;
    static final String LOGSFOLDER = Resources.LOGSFOLDER;

    private GreekStemmer() {
        this.MINIMUM_WORD_LENGTH = 1;
        this.PopulateAccents();
        this.m_endings = new Trie();
        this.m_unmatched = new Trie();
        this.m_prefixes = new Trie();
        this.m_irregular = new Trie();
        try {
            this.LoadData();
        }
        catch (IOException exception) {
            System.out.println("GreekStemmer: " + exception.toString());
        }
    }

    public void SetPerfectMatch(boolean perfectMatch) {
        this.m_perfectMatch = perfectMatch;
    }

    private void PopulateAccents() {
        this.m_accents.put(new Character((char)Integer.parseInt("0390", 16)), new Character((char)Integer.parseInt("03B9", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03B0", 16)), new Character((char)Integer.parseInt("03C5", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03D3", 16)), new Character((char)Integer.parseInt("03D2", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03D4", 16)), new Character((char)Integer.parseInt("03D2", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("0386", 16)), new Character((char)Integer.parseInt("0391", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("0388", 16)), new Character((char)Integer.parseInt("0395", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("0389", 16)), new Character((char)Integer.parseInt("0397", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("038A", 16)), new Character((char)Integer.parseInt("0399", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03AA", 16)), new Character((char)Integer.parseInt("0399", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03CA", 16)), new Character((char)Integer.parseInt("03B9", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03AB", 16)), new Character((char)Integer.parseInt("03A5", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03CB", 16)), new Character((char)Integer.parseInt("03C5", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("038C", 16)), new Character((char)Integer.parseInt("039F", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03AC", 16)), new Character((char)Integer.parseInt("03B1", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03CC", 16)), new Character((char)Integer.parseInt("03BF", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03AD", 16)), new Character((char)Integer.parseInt("03B5", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03CD", 16)), new Character((char)Integer.parseInt("03C5", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("038E", 16)), new Character((char)Integer.parseInt("03A5", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03AE", 16)), new Character((char)Integer.parseInt("03B7", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03CE", 16)), new Character((char)Integer.parseInt("03C9", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("038F", 16)), new Character((char)Integer.parseInt("03A9", 16)));
        this.m_accents.put(new Character((char)Integer.parseInt("03AF", 16)), new Character((char)Integer.parseInt("03B9", 16)));
    }

    private String RemoveAccents(String string) {
        char[] newString = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            Character c = this.m_accents.get(new Character(string.charAt(i)));
            newString[i] = c != null ? c.charValue() : string.charAt(i);
        }
        return new String(newString);
    }

    private void LoadData() throws IOException {
        String replacement = new String();
        boolean verb = false;
        BufferedReader inputsuffixes = new BufferedReader(new FileReader(Resources.ENDINGS));
        BufferedReader inputprefixes = new BufferedReader(new FileReader(Resources.PREFIXES));
        String ending = inputsuffixes.readLine();
        while (ending != null) {
            block30: {
                block31: {
                    if (ending.isEmpty()) break block30;
                    if (!ending.startsWith("/")) break block31;
                    if (!ending.startsWith("//&")) break block30;
                    verb = true;
                }
                if (!ending.startsWith("/")) {
                    this.m_endings.Insert(this.RemoveAccents(GreekStemmer.Reverse(ending.trim().toLowerCase())), verb);
                }
            }
            ending = inputsuffixes.readLine();
        }
        inputsuffixes.close();
        ending = inputprefixes.readLine();
        while (ending != null) {
            if (!ending.isEmpty()) {
                if (ending.startsWith("/")) {
                    if (ending.startsWith("//&")) {
                        replacement = ending.replace("//&", " ");
                        replacement = replacement.trim();
                    }
                } else if (!ending.startsWith("/")) {
                    if (replacement.isEmpty()) {
                        this.m_prefixes.Insert(ending.trim().toLowerCase(), verb);
                    } else {
                        this.m_prefixes.Insert(ending.trim().toLowerCase(), replacement);
                    }
                }
            }
            ending = inputprefixes.readLine();
        }
        inputprefixes.close();
        BufferedReader unmatched = new BufferedReader(new FileReader(Resources.AKLITA));
        ending = unmatched.readLine();
        while (ending != null) {
            if (!ending.isEmpty()) {
                if (ending.startsWith("/")) {
                    if (ending.startsWith("//&")) {
                        replacement = ending.replace("//&", " ");
                        replacement = replacement.trim();
                    }
                } else if (!ending.startsWith("/")) {
                    if (replacement.isEmpty()) {
                        this.m_unmatched.Insert(ending.trim().toLowerCase(), verb);
                    } else {
                        this.m_unmatched.Insert(ending.trim().toLowerCase(), replacement);
                    }
                }
            }
            ending = unmatched.readLine();
        }
        unmatched.close();
        BufferedReader irregularities = new BufferedReader(new FileReader(Resources.IRREGULAR));
        String[] prefs = new String[]{new String(), new String()};
        ending = irregularities.readLine();
        while (ending != null) {
            if (!ending.isEmpty()) {
                String word;
                if (ending.startsWith("/")) {
                    if (ending.startsWith("//&")) {
                        replacement = ending.replace("//&", " ");
                        replacement = replacement.trim();
                        word = replacement.toLowerCase();
                        prefs = this.ExtractPrefix(word);
                        word = this.RemoveSuffix(this.RemoveAccents(word.substring(prefs[0].length())));
                        replacement = this.LengthOptimization(replacement.substring(prefs[0].length()), word);
                        replacement = this.replaceLastCharacter(replacement);
                        replacement = prefs[1].concat(replacement);
                    }
                } else if (!ending.startsWith("/")) {
                    if (replacement.isEmpty()) {
                        word = ending.trim().toLowerCase();
                        prefs = this.ExtractPrefix(word);
                        word = word.substring(prefs[0].length());
                        word = this.RemoveAccents(word);
                        word = this.LengthOptimization(word, this.RemoveSuffix(word));
                        this.m_irregular.Insert(word, verb);
                    } else {
                        word = ending.trim().toLowerCase();
                        prefs = this.ExtractPrefix(word);
                        word = word.substring(prefs[0].length());
                        word = this.RemoveAccents(word);
                        String word2 = this.RemoveSuffix(word);
                        this.m_irregular.Insert(word2, replacement);
                    }
                }
            }
            ending = irregularities.readLine();
        }
        irregularities.close();
    }

    private static String Reverse(String string) {
        char[] reversed = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            reversed[string.length() - i - 1] = string.charAt(i);
        }
        return new String(reversed);
    }

    public static void Initialize() {
        m_greekStemmer = m_greekStemmer == null ? new GreekStemmer() : m_greekStemmer;
    }

    public static GreekStemmer Singleton() {
        return m_greekStemmer;
    }

    public static String RemoveStartRepetitions(String string) {
        int i;
        if (string.length() == 0) {
            return string;
        }
        char start = string.charAt(0);
        for (i = 1; i < string.length() && string.charAt(i) == start; ++i) {
        }
        return string.substring(i - 1);
    }

    public String Stem(String _word) {
        _word = _word.toLowerCase();
        _word.trim();
        String unmatched = this.m_unmatched.FindSubstring(_word, true);
        if (unmatched.length() == _word.length()) {
            return this.RemoveAccents(_word);
        }
        String[] prefixes = this.ExtractPrefix(_word);
        String finalstem1 = prefixes[0];
        String finalstem2 = prefixes[1];
        String word = _word.substring(finalstem1.length());
        word = this.RemoveAccents(word.trim());
        String stemmed = this.RemoveSuffix(word);
        stemmed = this.OptimizeWord(word, stemmed, finalstem2);
        finalstem1 = finalstem1.concat(stemmed);
        finalstem2 = finalstem2.concat(stemmed);
        finalstem1 = this.RemoveAccents(finalstem1);
        finalstem2 = this.RemoveAccents(finalstem2);
        return finalstem2;
    }

    private ArrayList<String[]> RemovePrefix(String word) {
        String msg = new String();
        ArrayList<String[]> prefs = new ArrayList<String[]>();
        String[] prefix = new String[]{new String(), new String()};
        do {
            word = GreekStemmer.Reverse(GreekStemmer.RemoveStartRepetitions(GreekStemmer.Reverse(GreekStemmer.RemoveStartRepetitions(word))));
            prefix = this.m_prefixes.FindSubstring(word);
            msg.concat("<" + prefix[0] + ", " + prefix[1] + ">");
            prefs.add(prefix);
            word = word.substring(prefix[0].length());
        } while (prefix[0].trim().length() != 0 && word.length() != 0);
        return prefs;
    }

    private String[] ExtractPrefix(String word) {
        ArrayList<String[]> prefs = this.RemovePrefix(word);
        String[] prefixes = new String[]{new String(), new String()};
        for (String[] temp : prefs) {
            prefixes[0] = prefixes[0].concat(temp[0]);
            prefixes[1] = prefixes[1].concat(temp[1]);
        }
        return prefixes;
    }

    private String RemoveSuffix(String _word) {
        String word = _word;
        if (word.length() <= this.MINIMUM_WORD_LENGTH) {
            return word;
        }
        String reversedWord = GreekStemmer.Reverse(word);
        String suffix = this.m_endings.FindSubstring(reversedWord, this.m_perfectMatch);
        int cutOff = word.length() - suffix.length() >= this.MINIMUM_WORD_LENGTH ? suffix.length() : word.length() - this.MINIMUM_WORD_LENGTH;
        return GreekStemmer.Reverse(reversedWord.substring(cutOff));
    }

    private String OptimizeWord(String word, String stemmed, String finalstem2) {
        String newstemmed = stemmed;
        if (finalstem2.length() == 0 && this.m_endings.getVerb()) {
            stemmed = this.ReplaceIrregular(stemmed);
        }
        if (stemmed.compareTo(newstemmed) != 0) {
            return stemmed;
        }
        if (stemmed.length() <= this.MINIMUM_WORD_LENGTH + 1 && stemmed.trim().length() != 0) {
            stemmed = this.LengthOptimization(word, stemmed);
        }
        if (stemmed.length() >= this.MINIMUM_WORD_LENGTH) {
            stemmed = this.replaceLastCharacter(stemmed);
        }
        return stemmed;
    }

    private String LengthOptimization(String word, String stemmed) {
        int j;
        int i = stemmed.length() - 1;
        char ch = stemmed.charAt(stemmed.length() - 1);
        int max = word.length();
        for (j = stemmed.length(); j < max; ++j) {
            if (word.substring(j - 1, j + 1).equals("\u03b1\u03b9")) {
                ++j;
                break;
            }
            if (word.substring(j - 1, j + 1).equals("\u03b1\u03c5")) {
                ++j;
                break;
            }
            if (word.substring(j - 1, j + 1).equals("\u03b5\u03c5")) {
                ++j;
                break;
            }
            if (word.substring(j - 1, j + 1).equals("\u03bf\u03c5")) {
                ++j;
                break;
            }
            if (word.substring(j - 1, j + 1).equals("\u03bc\u03bc")) {
                ++j;
                break;
            }
            if (ch != '\u03b1' && ch != '\u03b5' && ch != '\u03b7' && ch != '\u03b9' && ch != '\u03bf' && ch != '\u03c9' && ch != '\u03c5' && j > 2) break;
            ch = word.charAt(++i);
        }
        if (j < max) {
            return word.substring(0, j);
        }
        return word.substring(0, max);
    }

    private String replaceLastCharacter(String stem) {
        stem = GreekStemmer.Reverse(stem);
        char ch1 = stem.charAt(0);
        int ch2 = stem.length() >= 2 ? (int)stem.charAt(1) : 32;
        switch (ch1) {
            case '\u03c4': {
                if (ch2 == 964) {
                    stem = stem.replaceFirst("\u03c4\u03c4", "\u03be");
                    break;
                }
                if (ch2 == 960) {
                    stem = stem.replaceFirst("\u03c4\u03c0", "\u03c8");
                    break;
                }
                if (ch2 == 954) {
                    stem = stem.replaceFirst("\u03c4\u03ba", "\u03be");
                    break;
                }
                stem = stem.replaceFirst("\u03c4", "\u03c3");
                break;
            }
            case '\u03c3': {
                if (ch2 != 963) break;
                stem = stem.replaceFirst("\u03c3\u03c3", "\u03be");
                break;
            }
            case '\u03b4': {
                stem = stem.replaceFirst("\u03b4", "\u03c3");
                break;
            }
            case '\u03b8': {
                if (ch2 == 967) {
                    stem = stem.replaceFirst("\u03b8\u03c7", "\u03be");
                    break;
                }
                if (ch2 == 960) {
                    stem = stem.replaceFirst("\u03b8\u03c6", "\u03c8");
                    break;
                }
                stem = stem.replaceFirst("\u03b8", "\u03c3");
                break;
            }
            case '\u03c0': {
                stem = stem.replaceFirst("\u03c0", "\u03c8");
                break;
            }
            case '\u03b2': {
                stem = stem.replaceFirst("\u03b2", "\u03c8");
                break;
            }
            case '\u03c6': {
                stem = stem.replaceFirst("\u03c6", "\u03c8");
                break;
            }
            case '\u03ba': {
                stem = stem.replaceFirst("\u03ba", "\u03be");
                break;
            }
            case '\u03b3': {
                stem = stem.replaceFirst("\u03b3", "\u03be");
                break;
            }
            case '\u03c7': {
                stem = stem.replaceFirst("\u03c7", "\u03be");
                break;
            }
            case '\u03bd': {
                if (!this.m_endings.getVerb()) break;
                stem = stem.replaceFirst("\u03bd", "\u03c3");
                break;
            }
            case '\u03bc': {
                if (ch2 == 956) {
                    stem = stem.replaceFirst("\u03bc\u03bc", "\u03c8");
                    break;
                }
                if (ch2 != 947) break;
                stem = stem.replaceFirst("\u03bc\u03b3", "\u03be");
                break;
            }
        }
        stem = GreekStemmer.Reverse(stem);
        return stem;
    }

    private String ReplaceIrregular(String stemmed) {
        String reversedWord = stemmed;
        String[] newstemmed = this.m_irregular.FindSubstring(reversedWord);
        if (newstemmed[0].compareTo(stemmed) == 0) {
            if (newstemmed[1].length() == 0) {
                return stemmed;
            }
            return stemmed.equals(newstemmed[1]) ? stemmed : newstemmed[1].trim();
        }
        return stemmed;
    }

    private void initializeLogger() {
        Properties logProperties = new Properties();
        System.setProperty("log4j.logPath", LOGSFOLDER);
        try {
            FileInputStream stream = new FileInputStream(Resources.STEMMERLOG);
            logProperties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            System.out.println("Unable to load logging property " + Resources.STEMMERLOG);
        }
    }
}

