/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.stemmer.trie;

import gr.forth.ics.isl.stellaclustering.stemmer.trie.TrieNode;

public class Trie {
    private TrieNode m_root = new TrieNode();
    boolean verb;

    public void Insert(String string, boolean verb) {
        int i;
        TrieNode startNode = this.m_root;
        for (i = 0; i < string.length() && startNode.HasPointerTo(string.charAt(i)); ++i) {
            startNode = startNode.GetPointerTo(string.charAt(i));
        }
        TrieNode node = startNode;
        while (i < string.length()) {
            node.Connect(new TrieNode(string.charAt(i)));
            node = node.GetPointerTo(string.charAt(i));
            ++i;
        }
        node.SetEndOfString(true);
        node.SetVerb(verb);
    }

    public void Insert(String string, String replacement) {
        int i;
        TrieNode startNode = this.m_root;
        for (i = 0; i < string.length() && startNode.HasPointerTo(string.charAt(i)); ++i) {
            startNode = startNode.GetPointerTo(string.charAt(i));
        }
        TrieNode node = startNode;
        while (i < string.length()) {
            node.Connect(new TrieNode(string.charAt(i)));
            node = node.GetPointerTo(string.charAt(i));
            ++i;
        }
        node.SetEndOfString(true);
        node.SetVerb(false);
        node.SetReplacable(true);
        node.SetReplacement(replacement);
    }

    public String FindSubstring(String string, boolean perfectMatch) {
        TrieNode node = this.m_root;
        String subString = new String();
        String bestMatch = new String();
        for (int i = 0; i < string.length() && node.HasPointerTo(string.charAt(i)); ++i) {
            node = node.GetPointerTo(string.charAt(i));
            subString = subString + node.GetLetter();
            bestMatch = node.IsEndOfString() ? new String(subString) : bestMatch;
            this.verb = node.IsEndOfString() ? node.IsVerb() : this.verb;
        }
        return perfectMatch ? bestMatch : subString;
    }

    public String[] FindSubstring(String string) {
        String[] arraytotal = new String[]{new String(), new String()};
        TrieNode node = this.m_root;
        String subString = new String();
        String bestMatch = new String();
        String replacement = new String();
        for (int i = 0; i < string.length() && node.HasPointerTo(string.charAt(i)); ++i) {
            node = node.GetPointerTo(string.charAt(i));
            subString = subString + node.GetLetter();
            String string2 = bestMatch = node.IsEndOfString() ? new String(subString) : bestMatch;
            if (node.IsReplacable()) {
                replacement = node.GetReplacement();
                arraytotal[1] = node.IsEndOfString() ? replacement : "";
            }
            this.verb = node.IsVerb();
        }
        arraytotal[0] = bestMatch;
        return arraytotal;
    }

    public TrieNode getRoot() {
        return this.m_root;
    }

    public boolean getVerb() {
        return this.verb;
    }
}

