/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.stellaclustering.stemmer.trie;

import java.util.TreeMap;

public class TrieNode {
    private char m_letter;
    private TreeMap<Character, TrieNode> m_pointers;
    private boolean m_endOfString;
    private boolean m_Verb;
    private String m_Replacement;
    private boolean m_replacable;

    public TrieNode(char letter) {
        this.m_letter = letter;
        this.m_pointers = new TreeMap();
        this.m_endOfString = false;
    }

    public TrieNode() {
        this.m_pointers = new TreeMap();
        this.m_endOfString = false;
    }

    public void Connect(TrieNode node) {
        this.m_pointers.put(new Character(node.GetLetter()), node);
    }

    public char GetLetter() {
        return this.m_letter;
    }

    public void SetEndOfString(boolean value) {
        this.m_endOfString = value;
    }

    public boolean IsEndOfString() {
        return this.m_endOfString;
    }

    public boolean HasPointerTo(char letter) {
        return this.m_pointers.containsKey(new Character(letter));
    }

    public TrieNode GetPointerTo(char letter) {
        return this.m_pointers.get(new Character(letter));
    }

    public boolean IsVerb() {
        return this.m_Verb;
    }

    public void SetVerb(boolean Verb) {
        this.m_Verb = Verb;
    }

    public String GetReplacement() {
        return this.m_Replacement;
    }

    public void SetReplacement(String replacement) {
        this.m_Replacement = new String(replacement);
    }

    public boolean IsReplacable() {
        return this.m_replacable;
    }

    public void SetReplacable(boolean rep) {
        this.m_replacable = rep;
    }

    public int GetOutgoingEdges() {
        return this.m_pointers.values().size();
    }
}

