/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.textentitymining.gate;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.ANNIEConstants;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.util.GateException;
import gr.forth.ics.isl.textentitymining.resources.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public final class GateAnnie {
    public static SerialAnalyserController annieController;
    private static String gateHome;

    public static void InitializeGate() {
        try {
            System.out.println("Initialising ANNIE...");
            File homeFile = new File(Resources.MINING_HOME);
            Gate.setGateHome((File)homeFile);
            Gate.init();
            gateHome = Resources.MINING_HOME;
            if (gateHome == null) {
                System.out.println("gate.home is not specified.. use -Dgate.home to specify the value");
                return;
            }
            if (!gateHome.toLowerCase().startsWith("file:/")) {
                gateHome = "file:///" + gateHome;
            }
            String url = gateHome + "plugins/ANNIE";
            Gate.getCreoleRegister().registerDirectories(new URL(url));
            annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
            for (int i = 0; i < ANNIEConstants.PR_NAMES.length; ++i) {
                FeatureMap params = Factory.newFeatureMap();
                ProcessingResource pr = (ProcessingResource)Factory.createResource((String)ANNIEConstants.PR_NAMES[i], (FeatureMap)params);
                annieController.add(pr);
            }
            System.out.println("...ANNIE loaded");
        }
        catch (Exception e) {
            System.out.println("*** ERROR INITIALIZING GATEANNIE: " + e.getMessage());
        }
    }

    public static void RestartGate() throws MalformedURLException, ResourceInstantiationException, GateException {
        System.out.println("# Restarting Gate...");
        String url = gateHome + "plugins/ANNIE";
        Gate.init();
        Gate.getCreoleRegister().registerDirectories(new URL(url));
        annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
        for (int i = 0; i < ANNIEConstants.PR_NAMES.length; ++i) {
            FeatureMap params = Factory.newFeatureMap();
            ProcessingResource pr = (ProcessingResource)Factory.createResource((String)ANNIEConstants.PR_NAMES[i], (FeatureMap)params);
            annieController.add(pr);
        }
        System.out.println("# Gate was successfully restarted!");
    }

    public static void InitializeMiningProperties(String propertiesFilePath) {
        System.out.println("# Initializing Mining Properties...");
        try {
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(propertiesFilePath);
            prop.load(in);
            String gateHomeFolder = prop.getProperty("gr.forth.ics.textentitymining.resources.gateHomeFolder");
            String maxNumOfTotalEntities = prop.getProperty("gr.forth.ics.textentitymining.resources.maxNumOfTotalEntities");
            Resources.MINING_HOME = gateHomeFolder;
            try {
                Resources.MAX_TOTAL_NUM_OF_ENTITIES = Integer.parseInt(maxNumOfTotalEntities);
            }
            catch (Exception e) {
                System.out.println("*** ERROR PARSING MAX NUMBER OF TOTAL ENTITIES: " + e.getMessage());
            }
            System.out.println("=> GATE HOME: " + Resources.MINING_HOME);
            System.out.println("=> MAX TOTAL NUM OF ENTITIES: " + Resources.MAX_TOTAL_NUM_OF_ENTITIES);
            System.out.println("------");
        }
        catch (Exception e) {
            System.out.println("*** PROBLEM READING PROPERTIES FILE: " + e.getMessage());
        }
    }
}

