/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.textentitymining.gate;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.CollectionEntityMiner;
import gr.forth.ics.isl.textentitymining.TextEntityMiner;
import gr.forth.ics.isl.textentitymining.gate.GateAnnie;
import gr.forth.ics.isl.textentitymining.gate.Mine;
import gr.forth.ics.isl.textentitymining.resources.Resources;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateEntityMiner
implements TextEntityMiner,
CollectionEntityMiner {
    private ArrayList<String> collectionToMine = new ArrayList();
    private Set<String> acceptedCategories = new HashSet<String>();
    private ArrayList<Category> entities;

    @Override
    public void findEntities() {
        if (this.collectionToMine.isEmpty()) {
            System.out.println("*** ATTENTION! You have not set the text you want to mine (function 'setTextToMine' or 'setTextListToMine')! ***");
        }
        if (this.acceptedCategories.isEmpty()) {
            System.out.println("*** ATTENTION! You have not set the accepted categories (function 'setAcceptedCategories')! ***");
        }
        this.entities = new ArrayList();
        try {
            System.out.println("# Running entity mining...");
            Corpus corpus = (Corpus)Factory.createResource((String)"gate.corpora.CorpusImpl");
            corpus = this.addDocsToCorpus(corpus);
            System.out.println("# The corpus was created!");
            GateAnnie.annieController.setCorpus(corpus);
            System.out.println("# The corpus was set!");
            GateAnnie.annieController.execute();
            System.out.println("# AnnieGate was executed!");
            Mine mine = new Mine(corpus, this.acceptedCategories);
            this.entities = mine.getCategories();
        }
        catch (Exception ex) {
            System.out.println("*** PROBLEM RUNNING ANNIEGATE.");
        }
    }

    private Corpus addDocsToCorpus(Corpus corpus) {
        for (int i = 0; i < this.collectionToMine.size(); ++i) {
            String text = this.collectionToMine.get(i);
            try {
                String path = Resources.MINING_HOME + "tmp.result";
                FileOutputStream fos = new FileOutputStream(path);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                BufferedWriter out = new BufferedWriter(osw);
                out.write(text);
                out.flush();
                out.close();
                osw.close();
                fos.close();
                FeatureMap params = Factory.newFeatureMap();
                params.put((Object)"sourceUrl", (Object)("file:" + path));
                params.put((Object)"preserveOriginalContent", (Object)true);
                params.put((Object)"collectRepositioningInfo", (Object)true);
                Document doc = (Document)Factory.createResource((String)"gate.corpora.DocumentImpl", (FeatureMap)params);
                corpus.add((Object)doc);
                continue;
            }
            catch (Exception ex) {
                System.out.println("*** PROBLEM ADDING TO CORPUS THE CONTENTS:\n" + text);
                System.out.println("*** ERROR MESSAGE: " + ex.getMessage());
            }
        }
        return corpus;
    }

    public Set<String> getAcceptedCategories() {
        return this.acceptedCategories;
    }

    @Override
    public void setAcceptedCategories(Set<String> acceptedCategories) {
        this.acceptedCategories = acceptedCategories;
    }

    public void addAcceptedCategory(String category) {
        this.acceptedCategories.add(category);
    }

    public void removeAcceptedCategory(String category) {
        this.acceptedCategories.remove(category);
    }

    @Override
    public ArrayList<Category> getEntities() {
        if (this.entities == null) {
            System.out.println("*** ATTENTION! You must search for entities first (function 'findEntities')! ***");
            this.entities = new ArrayList();
        }
        return this.entities;
    }

    @Override
    public void setTextToMine(String textToMine) {
        this.collectionToMine = new ArrayList();
        this.collectionToMine.add(textToMine);
    }

    public String getTextToMine() {
        return this.collectionToMine.get(0);
    }

    public void addTextToMine(String textToMine) {
        this.collectionToMine.add(textToMine);
    }

    @Override
    public void setCollectionToMine(Collection<String> textToMine) {
        this.collectionToMine = (ArrayList)textToMine;
    }

    public ArrayList<String> getCollectionToMine() {
        return this.collectionToMine;
    }

    @Override
    public void rankEntities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

