/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.textentitymining.gate.addcategory;

import gate.creole.ResourceInstantiationException;
import gate.util.GateException;
import gr.forth.ics.isl.textentitymining.gate.GateAnnie;
import gr.forth.ics.isl.textentitymining.resources.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCategory {
    public final String CATEGORY_PARAMETER = "<CATEGORY>";
    private String categoryName;
    private String categoryNameNoSpace;
    private TreeSet<String> entities;
    private String NE_FOLDER;
    private String MAIN_JAPE_FILE;
    private String GAZETEER_FOLDER;
    private String LISTS_DEF_FILE;
    private String JAPE_FILE_TEMPLATE;
    private String JAPE_FILE_NAME;
    private String LISTS_DEF_TEMPLATE_LINE;
    private String LIST_FILE_NAME;

    public AddCategory() {
    }

    public AddCategory(String categoryName, TreeSet<String> entities) throws IOException, MalformedURLException, ResourceInstantiationException, GateException {
        this.categoryName = categoryName;
        this.categoryNameNoSpace = categoryName.replace(" ", "_");
        this.entities = entities;
    }

    public void add() throws IOException, MalformedURLException, ResourceInstantiationException, GateException {
        this.initializeVariables();
        this.addJapeFile();
        this.addInMainJapeFile();
        this.addListFile();
        this.addInListsDefFile();
        GateAnnie.RestartGate();
    }

    public final void initializeVariables() {
        if (!Resources.MINING_HOME.endsWith("/")) {
            Resources.MINING_HOME = Resources.MINING_HOME + "/";
        }
        this.NE_FOLDER = Resources.MINING_HOME + "plugins/ANNIE/resources/NE/";
        this.MAIN_JAPE_FILE = Resources.MINING_HOME + "plugins/ANNIE/resources/NE/main.jape";
        this.GAZETEER_FOLDER = Resources.MINING_HOME + "plugins/ANNIE/resources/gazetteer/";
        this.LISTS_DEF_FILE = Resources.MINING_HOME + "plugins/ANNIE/resources/gazetteer/lists.def";
        this.JAPE_FILE_TEMPLATE = "Phase:\t<CATEGORY>\nInput: Lookup Token\nOptions: control = appelt\n\nRule: <CATEGORY>\n(\n {Lookup.majorType == <CATEGORY>}\n)\n:<CATEGORY>\n-->\n :<CATEGORY>.<CATEGORY> = {rule = \"<CATEGORY>\"}";
        this.LISTS_DEF_TEMPLATE_LINE = "<CATEGORY>.lst:<CATEGORY>";
        this.JAPE_FILE_NAME = this.categoryNameNoSpace + ".jape";
        this.JAPE_FILE_NAME = this.NE_FOLDER + this.JAPE_FILE_NAME;
        this.LIST_FILE_NAME = this.categoryNameNoSpace + ".lst";
        this.LIST_FILE_NAME = this.GAZETEER_FOLDER + this.LIST_FILE_NAME;
    }

    public final void addJapeFile() throws IOException {
        File file = new File(this.JAPE_FILE_NAME);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        output.write(this.JAPE_FILE_TEMPLATE.replace(this.CATEGORY_PARAMETER, this.categoryNameNoSpace));
        ((Writer)output).close();
        System.out.println("# The " + this.JAPE_FILE_NAME + " file was created!");
    }

    public final void addInMainJapeFile() throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.MAIN_JAPE_FILE, true), "UTF-8");
        BufferedWriter fbw = new BufferedWriter(writer);
        fbw.newLine();
        fbw.write(this.categoryNameNoSpace);
        fbw.close();
        System.out.println("# The category was added in the " + this.MAIN_JAPE_FILE + "!");
    }

    public final void addListFile() throws IOException {
        File file = new File(this.LIST_FILE_NAME);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        for (String entity : this.entities) {
            entity = entity.replace("\"", "");
            output.write(entity);
            output.write("\n");
        }
        ((Writer)output).close();
        System.out.println("# The " + this.LISTS_DEF_FILE + " file was created!");
    }

    public final void addInListsDefFile() throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.LISTS_DEF_FILE, true), "UTF-8");
        BufferedWriter fbw = new BufferedWriter(writer);
        fbw.newLine();
        fbw.write(this.LISTS_DEF_TEMPLATE_LINE.replace(this.CATEGORY_PARAMETER, this.categoryNameNoSpace));
        fbw.close();
        System.out.println("# The category was added in the " + this.LISTS_DEF_FILE + "!");
    }

    public String getGAZETEER_FOLDER() {
        return this.GAZETEER_FOLDER;
    }

    public void setGAZETEER_FOLDER(String GAZETEER_FOLDER) {
        this.GAZETEER_FOLDER = GAZETEER_FOLDER;
    }

    public String getJAPE_FILE_NAME() {
        return this.JAPE_FILE_NAME;
    }

    public void setJAPE_FILE_NAME(String JAPE_FILE_NAME) {
        this.JAPE_FILE_NAME = JAPE_FILE_NAME;
    }

    public String getJAPE_FILE_TEMPLATE() {
        return this.JAPE_FILE_TEMPLATE;
    }

    public void setJAPE_FILE_TEMPLATE(String JAPE_FILE_TEMPLATE) {
        this.JAPE_FILE_TEMPLATE = JAPE_FILE_TEMPLATE;
    }

    public String getLISTS_DEF_FILE() {
        return this.LISTS_DEF_FILE;
    }

    public void setLISTS_DEF_FILE(String LISTS_DEF_FILE) {
        this.LISTS_DEF_FILE = LISTS_DEF_FILE;
    }

    public String getLISTS_DEF_TEMPLATE_LINE() {
        return this.LISTS_DEF_TEMPLATE_LINE;
    }

    public void setLISTS_DEF_TEMPLATE_LINE(String LISTS_DEF_TEMPLATE_LINE) {
        this.LISTS_DEF_TEMPLATE_LINE = LISTS_DEF_TEMPLATE_LINE;
    }

    public String getLIST_FILE_NAME() {
        return this.LIST_FILE_NAME;
    }

    public void setLIST_FILE_NAME(String LIST_FILE_NAME) {
        this.LIST_FILE_NAME = LIST_FILE_NAME;
    }

    public String getMAIN_JAPE_FILE() {
        return this.MAIN_JAPE_FILE;
    }

    public void setMAIN_JAPE_FILE(String MAIN_JAPE_FILE) {
        this.MAIN_JAPE_FILE = MAIN_JAPE_FILE;
    }

    public String getNE_FOLDER() {
        return this.NE_FOLDER;
    }

    public void setNE_FOLDER(String NE_FOLDER) {
        this.NE_FOLDER = NE_FOLDER;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryNameNoSpace() {
        return this.categoryNameNoSpace;
    }

    public void setCategoryNameNoSpace(String categoryNameNoSpace) {
        this.categoryNameNoSpace = categoryNameNoSpace;
    }

    public TreeSet<String> getEntities() {
        return this.entities;
    }

    public void setEntities(TreeSet<String> entities) {
        this.entities = entities;
    }
}

