/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.textentitymining;

import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
implements Serializable,
Comparable<Entity> {
    private String name;
    private ArrayList<Integer> docIds = new ArrayList();
    private double rank;

    public Entity(String name, ArrayList<Integer> docIds) {
        this.name = name;
        this.docIds = docIds;
        this.rank = 0.0;
    }

    public Entity(String name) {
        this.name = name;
        this.rank = 0.0;
    }

    public void addDocId(Integer docId) {
        this.docIds.add(docId);
    }

    public static void printElementsContents(Entity element) {
        System.out.print(element.getName());
        System.out.print(" [");
        for (int i = 0; i < element.getDocIds().size(); ++i) {
            System.out.print(element.getDocIds().get(i) + " ");
        }
        System.out.println("]");
    }

    public ArrayList<Integer> getDocIds() {
        return this.docIds;
    }

    public void setDocIds(ArrayList<Integer> docIds) {
        this.docIds = docIds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getRank() {
        return this.rank;
    }

    public void setRank(double rank) {
        this.rank = rank;
    }

    public void increaseRank() {
        this.rank += 1.0;
    }

    public void increaseRank(int num) {
        this.rank += (double)num;
    }

    @Override
    public int compareTo(Entity n) {
        if (this.rank > n.getRank()) {
            return -1;
        }
        if (this.rank < n.getRank()) {
            return 1;
        }
        if (this.docIds.size() > n.getDocIds().size()) {
            return -1;
        }
        if (this.docIds.size() < n.getDocIds().size()) {
            return 1;
        }
        return this.name.compareTo(n.getName());
    }
}

