/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.textentitymining;

import gate.util.GateException;
import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.gate.GateAnnie;
import gr.forth.ics.isl.textentitymining.gate.GateEntityMiner;
import gr.forth.ics.isl.textentitymining.util.HTMLTag;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Example {
    public static void main(String[] args) throws GateException, MalformedURLException {
        GateAnnie.InitializeMiningProperties("/conf/mining.properties");
        GateAnnie.InitializeGate();
        URL url = new URL("http://en.wikipedia.org/wiki/Fisheries");
        HTMLTag tagger = new HTMLTag(url);
        String content = tagger.getSourceCode();
        System.out.println("Retrieving the entities from the snippets...");
        GateEntityMiner miner = new GateEntityMiner();
        HashSet<String> accepted_categories = new HashSet<String>();
        accepted_categories.add("Person");
        accepted_categories.add("Location");
        accepted_categories.add("Organization");
        accepted_categories.add("Species");
        accepted_categories.add("FAOCountry");
        miner.setAcceptedCategories(accepted_categories);
        miner.setTextToMine(content);
        miner.findEntities();
        ArrayList<Category> entities = miner.getEntities();
        System.out.println("-----------------");
        System.out.println("All entities: \n");
        for (int i = 0; i < entities.size(); ++i) {
            System.out.println("Category: " + entities.get(i).getName());
            for (int j = 0; j < entities.get(i).getEntities().size(); ++j) {
                System.out.println("\tEntity: " + entities.get(i).getEntities().get(j).getName() + " - " + entities.get(i).getEntities().get(j).getDocIds());
            }
        }
        System.out.println("-----------------");
    }

    private static ArrayList<String> findBingResults(String query) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            String enc_query = URLEncoder.encode(query + " language:en", "utf-8");
            String bing_path = "http://www.bing.com/search?q=" + enc_query + "&count=50&first=0&format=rss";
            URL url = new URL(bing_path);
            HTMLTag tagger = new HTMLTag(url, true);
            int i1 = tagger.getFirstTagIndex("item");
            int num = 1;
            while (i1 != -1) {
                String title = tagger.getFirstTagData("title", i1);
                String description = tagger.getFirstTagData("description", i1);
                String result = title + " | " + description;
                results.add(result);
                ++num;
                i1 = tagger.getFirstTagIndex("item", i1 + 2);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        return results;
    }
}

