/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.textentitymining.gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.FeatureMap;
import gate.corpora.RepositioningInfo;
import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.Entity;
import gr.forth.ics.isl.textentitymining.resources.Resources;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mine {
    private ArrayList<Category> categories = new ArrayList();
    private int num = 0;

    public Mine(Corpus corpus, Set<String> acceptedCategories) {
        this.setEntities(corpus, acceptedCategories);
    }

    private void setEntities(Corpus corpus, Set<String> acceptedCategories) {
        Iterator iter = corpus.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Document doc = (Document)iter.next();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            AnnotationSet annotSet = defaultAnnotSet.get(acceptedCategories);
            FeatureMap features = doc.getFeatures();
            String originalContent = (String)features.get((Object)"Original_document_content_on_load");
            RepositioningInfo info = (RepositioningInfo)features.get((Object)"Document_repositioning_info");
            if (originalContent != null) {
                this.createMinedEntities(acceptedCategories, annotSet, originalContent, info, i);
                ++i;
            } else {
                System.out.println("ORIGINAL CONTENT IS NULL!");
                System.out.println("\tContent : " + originalContent);
                System.out.println("\tRepositioning: " + info);
            }
            if (this.num <= Resources.MAX_TOTAL_NUM_OF_ENTITIES) continue;
            break;
        }
    }

    public void createMinedEntities(Set annotTypesRequired, AnnotationSet annotationSet, String originalContent, RepositioningInfo info, int docId) {
        StringBuilder editableContent = new StringBuilder(originalContent);
        for (Annotation currAnnot : annotationSet) {
            int pos;
            String str;
            long insertPositionStart = currAnnot.getStartNode().getOffset();
            long insertPositionEnd = currAnnot.getEndNode().getOffset();
            if (info != null) {
                insertPositionStart = info.getOriginalPos(insertPositionStart);
                insertPositionEnd = info.getOriginalPos(insertPositionEnd, true);
            }
            if (insertPositionEnd == -1L || insertPositionStart == -1L || (str = editableContent.substring((int)insertPositionStart, (int)insertPositionEnd)).contains("<") || str.contains(">")) continue;
            while (str.contains("\n")) {
                str = str.replace("\n", " ");
            }
            str = str.replace("\t", " ");
            while ((pos = str.indexOf("  ")) > -1) {
                str = str.substring(0, pos) + str.substring(pos + 1);
            }
            if ((str = str.trim()).length() < 2 || str.equals("amp")) continue;
            Entity entity = new Entity(str);
            entity.addDocId(docId);
            this.addAnnotationToMinedEntities(currAnnot, annotTypesRequired, entity);
        }
    }

    public void addAnnotationToMinedEntities(Annotation currAnnot, Set annotTypesRequired, Entity entity) {
        for (String annotType : annotTypesRequired) {
            if (!currAnnot.getType().equals(annotType)) continue;
            this.addAnnotation(this.categories, entity, annotType);
            break;
        }
    }

    public void addAnnotation(ArrayList<Category> allEntities, Entity entity, String annotType) {
        ArrayList<Entity> entitiesList2 = new ArrayList<Entity>();
        for (int k = 0; k < allEntities.size(); ++k) {
            if (!allEntities.get(k).getName().equals(annotType)) continue;
            for (int i = 0; i < allEntities.get(k).getEntities().size(); ++i) {
                if (!allEntities.get(k).getEntities().get(i).getName().toLowerCase().equals(entity.getName().toLowerCase())) continue;
                Integer docId = entity.getDocIds().get(entity.getDocIds().size() - 1);
                if (!allEntities.get(k).getEntities().get(i).getDocIds().contains(docId)) {
                    allEntities.get(k).getEntities().get(i).addDocId(docId);
                }
                return;
            }
            allEntities.get(k).getEntities().add(entity);
            ++this.num;
            return;
        }
        entitiesList2.add(entity);
        allEntities.add(new Category(annotType, entitiesList2));
    }

    public ArrayList<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(ArrayList<Category> categories) {
        this.categories = categories;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }
}

