/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink;

import gr.forth.ics.isl.xlink.EntityMiningComponent;
import gr.forth.ics.isl.xlink.exceptions.CategoryNotFoundException;
import gr.forth.ics.isl.xlink.resources.Resources;
import gr.forth.ics.isl.xlink.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
implements Serializable,
Comparable<Category> {
    private String name;
    private double rank;
    private String resourceClass;
    private String endpoint;
    private String templateQuery;
    private String sparqlQueryFilepathOfEntities;
    private TreeSet<String> namedEntities;
    private String sparqlQuery;
    private static Pattern ALPHANUMERIC = Pattern.compile("[A-Za-z0-9 -]+");

    public Category(String thename) {
        while (thename.contains("  ")) {
            thename = thename.replace("  ", " ");
        }
        this.name = thename.replace(" ", "_");
        this.rank = 0.0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String thename) {
        while (thename.contains("  ")) {
            thename = thename.replace("  ", " ");
        }
        this.name = thename.replace(" ", "_");
    }

    public double getRank() {
        return this.rank;
    }

    public void setRank(double rank) {
        this.rank = rank;
    }

    public String getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(String resourceClass) throws MalformedURLException, URISyntaxException {
        URL url = new URL(resourceClass);
        url.toURI();
        this.resourceClass = resourceClass;
    }

    public void setResourceClassPermanent(String resourceClass, EntityMiningComponent emc) throws MalformedURLException, URISyntaxException, IOException, CategoryNotFoundException {
        URL url = new URL(resourceClass);
        url.toURI();
        this.resourceClass = resourceClass;
        emc.changeCategoryAttributes(this.name, null, null, null, resourceClass);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) throws MalformedURLException, URISyntaxException {
        URL url = new URL(endpoint);
        url.toURI();
        this.endpoint = endpoint;
        if (!this.endpoint.toLowerCase().endsWith("?query=")) {
            this.endpoint = this.endpoint + "?query=";
        }
    }

    public void setEndpointPermanent(String endpoint, EntityMiningComponent emc) throws MalformedURLException, URISyntaxException, IOException, CategoryNotFoundException {
        URL url = new URL(endpoint);
        url.toURI();
        this.endpoint = endpoint;
        if (!this.endpoint.toLowerCase().endsWith("?query=")) {
            this.endpoint = this.endpoint + "?query=";
        }
        emc.changeCategoryAttributes(this.name, endpoint, null, null, null);
    }

    public String getTemplateQuery() {
        return this.templateQuery;
    }

    public void setTemplateQuery(String templateQuery) throws FileNotFoundException {
        File file = new File(templateQuery);
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.templateQuery = templateQuery;
    }

    public void setTemplateQueryPermanent(String templateQuery, EntityMiningComponent emc) throws FileNotFoundException, IOException, CategoryNotFoundException, MalformedURLException, URISyntaxException {
        File file = new File(templateQuery);
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.templateQuery = templateQuery;
        emc.changeCategoryAttributes(this.name, null, templateQuery, null, null);
    }

    public TreeSet<String> getNamedEntities() {
        return this.namedEntities;
    }

    public void setNamedEntities(TreeSet<String> namedEntities) {
        TreeSet<String> namedEntities2 = new TreeSet<String>();
        for (String tmp : namedEntities) {
            if (this.checkForIllegalCharacters(tmp)) continue;
            namedEntities2.add(tmp);
        }
        this.namedEntities = namedEntities2;
    }

    public void addNamedEntity(String namedEntity) {
        if (this.namedEntities == null) {
            this.namedEntities = new TreeSet();
        }
        this.namedEntities.add(namedEntity);
    }

    public String getSparqlQueryFilepathOfEntities() {
        return this.sparqlQueryFilepathOfEntities;
    }

    public String getSparqlQuery() {
        return this.sparqlQuery;
    }

    public void setSparqlQueryFilepathOfEntities(String sparqlQueryOfEntities) throws FileNotFoundException {
        File file = new File(sparqlQueryOfEntities);
        String path = file.getAbsolutePath();
        File tmp = new File(path);
        if (!tmp.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.sparqlQueryFilepathOfEntities = sparqlQueryOfEntities;
    }

    public void setSparqlQuery(String sparqlQuery) {
        this.sparqlQuery = sparqlQuery;
    }

    public void setSparqlQueryFilepathOfEntitiesPermanent(String sparqlQueryOfEntities, EntityMiningComponent emc) throws FileNotFoundException, IOException, CategoryNotFoundException, MalformedURLException, URISyntaxException {
        File file = new File(sparqlQueryOfEntities);
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.sparqlQueryFilepathOfEntities = sparqlQueryOfEntities;
        emc.changeCategoryAttributes(this.name, null, null, sparqlQueryOfEntities, null);
    }

    public void retrieveNamedEntitiesByResourceClass() {
        if (this.endpoint == null) {
            System.out.println("*** You must first specify the endpoint of the category.");
            return;
        }
        if (this.resourceClass == null) {
            System.out.println("*** You must first specify the resource class of the category.");
            return;
        }
        String instancesQuery = Utils.readTemplateQuery(Resources.TEMPLATE_GET_INSTANCES_QUERY);
        instancesQuery = instancesQuery.replace(Resources.TEMPLATE_RESOURCE_CLASS_PARAMETER, this.resourceClass);
        String queryPath = null;
        try {
            queryPath = this.endpoint + URLEncoder.encode(instancesQuery, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Category.class.getName()).log(Level.SEVERE, null, ex);
        }
        String result = Utils.runSparqlQuery(queryPath);
        TreeSet<String> entries = Utils.readEntriesFromXmlResult(result);
        if (this.namedEntities == null) {
            this.namedEntities = new TreeSet();
        }
        for (String tmp : entries) {
            if (this.checkForIllegalCharacters(tmp) || !this.checkAlphaNumeric(tmp)) continue;
            tmp = this.ingoreTextBetweenBrackets(tmp);
            tmp = tmp.replaceAll("\"", "");
            this.namedEntities.add(tmp);
        }
    }

    public void retrieveNamedEntitiesByQuery() {
        if (this.endpoint == null) {
            System.out.println("*** You must first specify the endpoint of the category.");
            return;
        }
        if (this.sparqlQueryFilepathOfEntities == null && this.sparqlQuery == null) {
            System.out.println("*** You must first specify the SPARQL query for getting the entities.");
            return;
        }
        String queryPath = null;
        String query = this.sparqlQuery != null ? this.sparqlQuery : Utils.readTemplateQuery(this.sparqlQueryFilepathOfEntities);
        try {
            queryPath = this.endpoint + URLEncoder.encode(query, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Category.class.getName()).log(Level.SEVERE, null, ex);
        }
        String result = Utils.runSparqlQuery(queryPath);
        TreeSet<String> entries = Utils.readEntriesFromXmlResult(result);
        if (this.namedEntities == null) {
            this.namedEntities = new TreeSet();
        }
        for (String tmp : entries) {
            if (this.checkForIllegalCharacters(tmp) || !this.checkAlphaNumeric(tmp)) continue;
            tmp = this.ingoreTextBetweenBrackets(tmp);
            tmp = tmp.replaceAll("\"", "");
            this.namedEntities.add(tmp);
        }
    }

    @Override
    public int compareTo(Category n) {
        if (this.rank > n.getRank()) {
            return -1;
        }
        if (this.rank < n.getRank()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Category{name=" + this.name + ", rank=" + this.rank + ", resourceClass=" + this.resourceClass + ", endpoint=" + this.endpoint + ", templateQuery=" + this.templateQuery + ", sparqlQueryFilepathOfEntities=" + this.sparqlQueryFilepathOfEntities + ", namedEntities=" + this.namedEntities + '}';
    }

    private boolean checkForIllegalCharacters(String categoryName) {
        return false;
    }

    private boolean checkAlphaNumeric(String s) {
        return true;
    }

    private String ingoreTextBetweenBrackets(String text) {
        StringBuilder buffer = new StringBuilder();
        int parenthesis_count = 0;
        int square_brackets_count = 0;
        int curly_brackets_count = 0;
        for (char c : text.toCharArray()) {
            if (c == '(') {
                ++parenthesis_count;
            }
            if (c == ')') {
                --parenthesis_count;
            }
            if (c == '[') {
                ++square_brackets_count;
            }
            if (c == ']') {
                --square_brackets_count;
            }
            if (c == '{') {
                ++curly_brackets_count;
            }
            if (c == '}') {
                --curly_brackets_count;
            }
            if (c == '}' || c == '{' || curly_brackets_count != 0 || c == ')' || c == '(' || parenthesis_count != 0 || c == ']' || c == '[' || square_brackets_count != 0) continue;
            buffer.append(c);
        }
        String t = buffer.toString();
        while (t.contains("  ")) {
            t = t.replace("  ", " ");
        }
        t = t.trim();
        return t;
    }
}

