/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
implements Serializable,
Comparable<Entity> {
    private String name;
    private String categoryName;
    private Set<String> matchingURIs;
    private HashMap<String, String> properties;
    private double rank;
    private int numOfOccurrences;

    public Entity(String name) {
        this.name = name;
        this.rank = 0.0;
        this.numOfOccurrences = 1;
        this.matchingURIs = new HashSet<String>();
        this.properties = new HashMap();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public double getRank() {
        return this.rank;
    }

    public void setRank(double rank) {
        this.rank = rank;
    }

    public int getNumOfOccurrences() {
        return this.numOfOccurrences;
    }

    public void setNumOfOccurrences(int numOfOccurrences) {
        this.numOfOccurrences = numOfOccurrences;
    }

    public void increaseNumOfOccurrences() {
        ++this.numOfOccurrences;
    }

    public Set<String> getMatchingURIs() {
        return this.matchingURIs;
    }

    public void setMatchingURIs(Set<String> matchingURIs) {
        this.matchingURIs = matchingURIs;
    }

    public void addMatchingURI(String uri) {
        this.matchingURIs.add(uri);
    }

    @Override
    public int compareTo(Entity n) {
        if (this.rank > n.getRank()) {
            return -1;
        }
        if (this.rank < n.getRank()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Entity{name=" + this.name + ", categoryName=" + this.categoryName + ", matchingURIs=" + this.matchingURIs + ", properties=" + this.properties + ", rank=" + this.rank + ", numOfOccurrences=" + this.numOfOccurrences + '}';
    }
}

