/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink;

import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.EntityMiningComponent;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.gate.GateEntityMiner;
import gr.forth.ics.isl.xlink.gate.GateEntityMiningComponent;
import gr.forth.ics.isl.xlink.resources.Resources;
import gr.forth.ics.isl.xlink.textextractor.TextExtractor;
import gr.forth.ics.isl.xlink.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLink {
    private EntityMiningComponent emc;
    private ArrayList<Entity> entities;

    public void setEntityMiningComponent(EntityMiningComponent emc) {
        this.emc = emc;
    }

    public void retrieveEntities(TextExtractor extractor, HashSet<String> acceptedCategoryNames) throws FalseFileTypeException {
        TreeSet<String> acceptedCategoryNamesChanged = new TreeSet<String>();
        for (String entity : acceptedCategoryNames) {
            while (entity.contains("  ")) {
                entity = entity.replace("  ", " ");
            }
            entity = entity.replace(" ", "_");
            acceptedCategoryNamesChanged.add(entity.toLowerCase());
        }
        GateEntityMiner miner = new GateEntityMiner();
        miner.setEntityMiningComponent(this.emc);
        miner.setAcceptedCategories(acceptedCategoryNamesChanged);
        miner.setTextToMine(extractor.extractText());
        miner.findEntities();
        this.entities = miner.getEntities();
    }

    public void retrieveEntities(String content, HashSet<String> acceptedCategoryNames) {
        TreeSet<String> acceptedCategoryNamesChanged = new TreeSet<String>();
        for (String entity : acceptedCategoryNames) {
            while (entity.contains("  ")) {
                entity = entity.replace("  ", " ");
            }
            entity = entity.replace(" ", "_");
            acceptedCategoryNamesChanged.add(entity.toLowerCase());
        }
        GateEntityMiner miner = new GateEntityMiner();
        miner.setEntityMiningComponent(this.emc);
        miner.setAcceptedCategories(acceptedCategoryNamesChanged);
        miner.setTextToMine(content);
        miner.findEntities();
        this.entities = miner.getEntities();
    }

    public void matchEntities() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy_HHmmss");
            Date date = new Date();
            String dateText = dateFormat.format(date);
            File file = new File(((GateEntityMiningComponent)this.emc).getGateHome() + "storedMatchings/" + dateText + ".csv");
            FileWriter fw = new FileWriter(file);
            PrintWriter out = new PrintWriter(fw);
            out.print("Entity_Name");
            out.print(";");
            out.print("Category");
            out.print(";");
            out.print("URIs");
            out.print(";");
            out.print("Rank");
            out.print(";");
            out.print("Number of Occurrences");
            out.println();
            out.println();
            for (int i = 0; i < this.entities.size(); ++i) {
                String entityName = this.entities.get(i).getName();
                String entityCategoryName = this.entities.get(i).getCategoryName();
                entityName = this.findClosestEntity(entityName, entityCategoryName);
                Set<String> uris_new = this.getMatchingURIs(entityName, entityCategoryName);
                this.entities.get(i).setMatchingURIs(uris_new);
                if (uris_new.isEmpty()) {
                    out.print(this.entities.get(i).getName());
                    out.print(";");
                    out.print(this.entities.get(i).getCategoryName());
                    out.print(";");
                    out.print(";");
                    out.print(this.entities.get(i).getRank());
                    out.print(";");
                    out.print(this.entities.get(i).getNumOfOccurrences());
                    out.println();
                } else {
                    for (String uri : uris_new) {
                        out.print(this.entities.get(i).getName());
                        out.print(";");
                        out.print(this.entities.get(i).getCategoryName());
                        out.print(";");
                        out.print(uri);
                        out.print(";");
                        out.print(this.entities.get(i).getRank());
                        out.print(";");
                        out.print(this.entities.get(i).getNumOfOccurrences());
                        out.println();
                    }
                }
                out.flush();
            }
            out.close();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(XLink.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void retrieveIncomingProperties() {
    }

    public void retrieveOutcomingProperties() {
    }

    public void retrieveAllProperties() {
    }

    private Set<String> getMatchingURIs(String entityName, String entityCategoryName) {
        TreeSet<String> uris = new TreeSet<String>();
        for (int i = 0; i < this.emc.getAvailableCategories().size(); ++i) {
            if (!this.emc.getAvailableCategories().get(i).getName().toLowerCase().equals(entityCategoryName.toLowerCase())) continue;
            String endpoint = this.emc.getAvailableCategories().get(i).getEndpoint();
            if (endpoint == null) {
                System.out.println("*** The endpoint of the category '" + entityCategoryName + "' does not exist, matching URIs of the entity '" + entityName + "' cannot be retrieved! ***");
                return uris;
            }
            String templateQueryFile = this.emc.getAvailableCategories().get(i).getTemplateQuery();
            if (templateQueryFile == null) {
                System.out.println("*** The template query of the category '" + entityCategoryName + "' does not exist, matching URIs of the entity '" + entityName + "' cannot be retrieved! ***");
                return uris;
            }
            String templateQuery = Utils.readTemplateQuery(templateQueryFile);
            String sparqlQuery = templateQuery.replace(Resources.TEMPLATE_ENTITY_PARAMETER, entityName);
            try {
                sparqlQuery = URLEncoder.encode(sparqlQuery, "utf8");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(XLink.class.getName()).log(Level.SEVERE, null, ex);
            }
            String sparqlQueryPath = endpoint + sparqlQuery;
            System.out.println("# Retrieving URIs of: ");
            System.out.println("  - Entity: " + entityName);
            System.out.println("  - Caegory: " + entityCategoryName);
            System.out.println("  - SPARQL Endpoint: " + endpoint);
            System.out.println("  - SPARQL Template Query: " + templateQuery);
            System.out.println("  - SPARQL Query Path: " + sparqlQueryPath);
            String sparqlQueryResult = Utils.runSparqlQuery(sparqlQueryPath);
            uris = Utils.readEntriesFromXmlResult(sparqlQueryResult);
            System.out.println("# Finish retrieving the matching URIs.");
            break;
        }
        return uris;
    }

    public EntityMiningComponent getEmc() {
        return this.emc;
    }

    public void setEmc(EntityMiningComponent emc) {
        this.emc = emc;
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<Entity> entities) {
        this.entities = entities;
    }

    private String findClosestEntity(String entityName, String entityCategoryName) {
        int min = 5;
        String temp = entityName;
        String path = ((GateEntityMiningComponent)this.emc).getGateHome();
        File tempR = new File(path + "plugins/ANNIE/resources/gazetteer/" + entityCategoryName + ".lst");
        try {
            String currLine;
            BufferedReader reader = new BufferedReader(new FileReader(tempR));
            while ((currLine = reader.readLine()) != null) {
                int tmp = this.computeLevenshteinDistance(entityName, currLine);
                if (tmp > min) continue;
                min = tmp;
                temp = currLine;
            }
            entityName = temp;
            reader.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(XLink.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException exc) {
            Logger.getLogger(XLink.class.getName()).log(Level.SEVERE, null, exc);
        }
        return entityName;
    }

    private int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public int computeLevenshteinDistance(CharSequence str1, CharSequence str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = this.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }
}

