/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.clientexamples;

import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.XLink;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.exceptions.NoProperXLinkRepositoryException;
import gr.forth.ics.isl.xlink.exceptions.XLinkIsOffException;
import gr.forth.ics.isl.xlink.gate.GateEntityMiningComponent;
import gr.forth.ics.isl.xlink.resources.Resources;
import gr.forth.ics.isl.xlink.resultexporter.CSVExporter;
import gr.forth.ics.isl.xlink.resultexporter.TXTExporter;
import gr.forth.ics.isl.xlink.resultexporter.XMLExporter;
import gr.forth.ics.isl.xlink.textextractor.WebPageTextExtractor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;

public class ClientFindEntities {
    public static void main(String[] args) throws XLinkIsOffException, MalformedURLException, URISyntaxException, FileNotFoundException, NoProperXLinkRepositoryException, IOException, FalseFileTypeException {
        GateEntityMiningComponent emc = new GateEntityMiningComponent(Resources.XLinkRepo_forTestClients);
        emc.startup();
        emc.printAvailableCategories();
        XLink xlink = new XLink();
        xlink.setEntityMiningComponent(emc);
        HashSet<String> acceptedCategoryNames = new HashSet<String>();
        acceptedCategoryNames.add("species");
        WebPageTextExtractor extractor = new WebPageTextExtractor("http://en.wikipedia.org/wiki/Yellowfin_tuna");
        xlink.retrieveEntities(extractor, acceptedCategoryNames);
        xlink.matchEntities();
        ArrayList<Entity> entities = xlink.getEntities();
        emc.shutdown();
        System.out.println("----------");
        System.out.println("# Detected entities: ");
        for (Entity entity : entities) {
            System.out.println("Entity name: " + entity.getName());
            System.out.println("Category: " + entity.getCategoryName());
            System.out.println("Matching URIs: " + entity.getMatchingURIs());
            System.out.println("-----");
        }
        XMLExporter exp1 = new XMLExporter("results/file2.xml", entities);
        exp1.exportResults();
        TXTExporter exp2 = new TXTExporter("results/file2.txt", entities);
        exp2.exportResults();
        CSVExporter exp3 = new CSVExporter("results/file2.csv", entities);
        exp3.exportResults();
    }
}

