/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.gate;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.EntityMiningComponent;
import gr.forth.ics.isl.xlink.TextEntityMiner;
import gr.forth.ics.isl.xlink.gate.GateEntityMiningComponent;
import gr.forth.ics.isl.xlink.gate.Mine;
import gr.forth.ics.isl.xlink.resources.Resources;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateEntityMiner
implements TextEntityMiner {
    private ArrayList<String> collectionToMine = new ArrayList();
    private Set<String> acceptedCategories = new HashSet<String>();
    private ArrayList<Entity> entities;
    private GateEntityMiningComponent emc;

    public void setEntityMiningComponent(EntityMiningComponent emc) {
        this.emc = (GateEntityMiningComponent)emc;
    }

    @Override
    public void findEntities() {
        if (this.collectionToMine.isEmpty()) {
            System.out.println("*** ATTENTION! You have not set the text you want to mine (function 'setTextToMine' or 'setTextListToMine')! ***");
        }
        if (this.acceptedCategories.isEmpty()) {
            System.out.println("*** ATTENTION! You have not set the accepted categories (function 'setAcceptedCategories')! ***");
        }
        this.entities = new ArrayList();
        try {
            System.out.println("# Running entity mining...");
            Corpus corpus = (Corpus)Factory.createResource((String)"gate.corpora.CorpusImpl");
            corpus = this.setCorpus(corpus);
            System.out.println("# The corpus was created!");
            this.emc.annieController.setCorpus(corpus);
            System.out.println("# The corpus was set!");
            this.emc.annieController.execute();
            System.out.println("# AnnieGate was executed!");
            Mine mine = new Mine(corpus, this.acceptedCategories);
            this.entities = mine.getEntities();
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Corpus setCorpus(Corpus corpus) {
        for (int i = 0; i < this.collectionToMine.size(); ++i) {
            String text = this.collectionToMine.get(i);
            if (text == null) {
                text = "";
            }
            if (text.trim().equals("")) {
                text = "- - - -";
            }
            try {
                String path = this.emc.getGateHome() + "tmp.result";
                FileOutputStream fos = new FileOutputStream(path);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                BufferedWriter out = new BufferedWriter(osw);
                out.write(text);
                out.flush();
                out.close();
                osw.close();
                fos.close();
                FeatureMap params = Factory.newFeatureMap();
                if (Resources.SYSTEM_OS.equals("Linux")) {
                    params.put((Object)"sourceUrl", (Object)("file:" + path));
                } else {
                    params.put((Object)"sourceUrl", (Object)("file:/" + path));
                }
                params.put((Object)"preserveOriginalContent", (Object)true);
                params.put((Object)"collectRepositioningInfo", (Object)true);
                Document doc = (Document)Factory.createResource((String)"gate.corpora.DocumentImpl", (FeatureMap)params);
                corpus.add((Object)doc);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(GateEntityMiner.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return corpus;
    }

    public Set<String> getAcceptedCategories() {
        return this.acceptedCategories;
    }

    @Override
    public void setAcceptedCategories(Set<String> acceptedCategories) {
        this.acceptedCategories = acceptedCategories;
    }

    public void addAcceptedCategory(String category) {
        this.acceptedCategories.add(category);
    }

    public void removeAcceptedCategory(String category) {
        this.acceptedCategories.remove(category);
    }

    @Override
    public void setTextToMine(String textToMine) {
        this.collectionToMine = new ArrayList();
        this.collectionToMine.add(textToMine);
    }

    public String getTextToMine() {
        return this.collectionToMine.get(0);
    }

    public void addTextToMine(String textToMine) {
        this.collectionToMine.add(textToMine);
    }

    @Override
    public void rankEntities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<Entity> getEntities() {
        return this.entities;
    }
}

