/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.gate;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.util.GateException;
import gr.forth.ics.isl.xlink.Category;
import gr.forth.ics.isl.xlink.EntityMiningComponent;
import gr.forth.ics.isl.xlink.exceptions.CategoryAlreadyExistsException;
import gr.forth.ics.isl.xlink.exceptions.CategoryNotFoundException;
import gr.forth.ics.isl.xlink.exceptions.EmptyListOfNamedEntitiesException;
import gr.forth.ics.isl.xlink.exceptions.IllegalCategoryNameException;
import gr.forth.ics.isl.xlink.exceptions.NoGivenResourceClassException;
import gr.forth.ics.isl.xlink.exceptions.NoGivenSPARQLEndpointException;
import gr.forth.ics.isl.xlink.exceptions.NoGivenSparqlQueryFileException;
import gr.forth.ics.isl.xlink.exceptions.NoProperCategoryNameException;
import gr.forth.ics.isl.xlink.exceptions.NoProperXLinkRepositoryException;
import gr.forth.ics.isl.xlink.exceptions.XLinkIsOffException;
import gr.forth.ics.isl.xlink.gate.addcategory.AddCategory;
import gr.forth.ics.isl.xlink.resources.Resources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateEntityMiningComponent
implements EntityMiningComponent {
    public SerialAnalyserController annieController;
    private String gateHome;
    private String gateHomeUrl;
    private ArrayList<Category> categories;

    public GateEntityMiningComponent(String gateHome) throws MalformedURLException, URISyntaxException, FileNotFoundException, NoProperXLinkRepositoryException, IOException {
        this.gateHome = gateHome;
        if (!gateHome.endsWith("/") && !gateHome.endsWith("/")) {
            this.gateHome = this.gateHome + "/";
        }
        this.categories = new ArrayList();
        File f = new File(this.gateHome);
        this.gateHome = f.getAbsolutePath() + "/";
        File file = new File(this.gateHome + "x-link.properties");
        if (!file.exists()) {
            throw new NoProperXLinkRepositoryException(file.toString());
        }
        this.readProperties(this.gateHome + "x-link.properties");
    }

    @Override
    public void startup() {
        System.out.println("Initialising ANNIE...");
        try {
            String[] tmp;
            File homeFile = new File(this.gateHome);
            Gate.setGateHome((File)homeFile);
            Gate.init();
            if (this.gateHome == null) {
                System.out.println("gate.home is not specified.. use -Dgate.home to specify the value");
                return;
            }
            this.gateHomeUrl = "file:///" + this.gateHome;
            String url = this.gateHomeUrl + "plugins/ANNIE";
            try {
                Gate.getCreoleRegister().registerDirectories(new URL(url));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
            prop.load(in);
            if (prop.getProperty("gr.forth.ics.xlink.gate.editDistance").equalsIgnoreCase("true")) {
                tmp = new String[]{"gate.creole.annotdelete.AnnotationDeletePR", "gate.creole.tokeniser.DefaultTokeniser", "bwp.gate.gazetteer.BWPGazetteer", "gate.creole.splitter.SentenceSplitter", "gate.creole.ANNIETransducer", "gate.creole.orthomatcher.OrthoMatcher"};
                Resources.ANNIE_CONSTANTS = tmp;
            } else {
                tmp = new String[]{"gate.creole.annotdelete.AnnotationDeletePR", "gate.creole.tokeniser.DefaultTokeniser", "gate.creole.gazetteer.DefaultGazetteer", "gate.creole.splitter.SentenceSplitter", "gate.creole.ANNIETransducer", "gate.creole.orthomatcher.OrthoMatcher"};
                Resources.ANNIE_CONSTANTS = tmp;
            }
            for (int i = 0; i < Resources.ANNIE_CONSTANTS.length; ++i) {
                FeatureMap params = Factory.newFeatureMap();
                ProcessingResource pr = (ProcessingResource)Factory.createResource((String)Resources.ANNIE_CONSTANTS[i], (FeatureMap)params);
                this.annieController.add(pr);
            }
            System.out.println("...ANNIE loaded");
        }
        catch (GateException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void shutdown() {
        this.annieController.cleanup();
        this.annieController = null;
        this.gateHome = null;
        this.gateHomeUrl = null;
    }

    @Override
    public ArrayList<Category> getAvailableCategories() {
        return this.categories;
    }

    @Override
    public void addNewCategory(Category category) throws CategoryAlreadyExistsException, XLinkIsOffException, IllegalCategoryNameException, NoProperCategoryNameException {
        if (this.checkForIllegalCharacters(category.getName())) {
            throw new IllegalCategoryNameException(category.getName());
        }
        if (this.checkForCategoryInPropertiesFile(category.getName())) {
            throw new CategoryAlreadyExistsException(category.getName());
        }
        if (this.checkForCategory(category.getName())) {
            throw new NoProperCategoryNameException(category.getName());
        }
        try {
            if (category.getNamedEntities() == null) {
                System.out.println("*** The list of named entities is empty! The category was not added! ***");
                throw new EmptyListOfNamedEntitiesException("Category " + category.getName());
            }
            if (category.getNamedEntities().isEmpty()) {
                System.out.println("*** The list of named entities is empty! The category was not added! ***");
                throw new EmptyListOfNamedEntitiesException("Category " + category.getName());
            }
            AddCategory addCategory = new AddCategory(this.gateHome, category.getName(), category.getNamedEntities());
            addCategory.add();
            this.restart();
            this.categories.add(category);
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
            prop.load(in);
            String propertyValue = "";
            for (Category cat : this.categories) {
                String categoryName = cat.getName();
                propertyValue = propertyValue + categoryName.trim();
                propertyValue = propertyValue + ";";
            }
            prop.setProperty("gr.forth.ics.xlink.resources.categories", propertyValue.substring(0, propertyValue.length() - 1));
            if (category.getEndpoint() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + category.getName() + ".endpoint", category.getEndpoint());
            }
            if (category.getResourceClass() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + category.getName() + ".resourceclass", category.getResourceClass());
            }
            if (category.getSparqlQueryFilepathOfEntities() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + category.getName() + ".sparqlqueryofentities", category.getSparqlQueryFilepathOfEntities());
            }
            if (category.getTemplateQuery() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + category.getName() + ".template", category.getTemplateQuery());
            }
            prop.store(new FileOutputStream(new File(this.gateHome + "x-link.properties")), "X-Link Properties");
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void removeCategory(String categoryName) throws CategoryNotFoundException, FileNotFoundException, UnsupportedEncodingException, IOException, XLinkIsOffException {
        while (categoryName.contains("  ")) {
            categoryName = categoryName.replace("  ", " ");
        }
        String categoryAsGiven = categoryName.replace(" ", "_");
        categoryName = categoryAsGiven.toLowerCase();
        File file1 = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + categoryName + ".lst");
        File file2 = new File(this.gateHome + "plugins/ANNIE/resources/NE/" + categoryName + ".jape");
        File file_1 = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + categoryAsGiven + ".lst");
        File file_2 = new File(this.gateHome + "plugins/ANNIE/resources/NE/" + categoryAsGiven + ".jape");
        File file3 = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/lists.def");
        File file4 = new File(this.gateHome + "plugins/ANNIE/resources/NE/main.jape");
        if (!this.checkForCategory(categoryName)) {
            throw new CategoryNotFoundException(categoryAsGiven);
        }
        System.out.println("====================================================");
        System.out.println("  Warning the following files will be deleted : \n  i)  " + categoryName + ".lst" + "\n ii)  " + categoryName + ".jape");
        if (file1.delete()) {
            System.out.println("  * File '" + categoryName + ".lst' deleted ! ");
        } else {
            System.out.println("  * File '" + categoryName + ".lst' does not exist ! ");
        }
        if (file2.delete()) {
            System.out.println("  * File '" + categoryName + ".jape' deleted ! ");
        } else {
            System.out.println("  * File '" + categoryName + ".jape' does not exist ! ");
        }
        this.removeLineFromFile(file3, categoryName, 0);
        this.removeLineFromFile(file4, categoryName, 1);
        System.out.println("====================================================");
        this.removeCategoryFromPropertiesFile(categoryName);
        this.restart();
    }

    private void removeLineFromFile(File file, String line, int i) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        boolean renamed;
        String currLine;
        int count = this.countLines(file);
        int k = 1;
        File temp = i == 0 ? new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/temp.def") : new File(this.gateHome + "plugins/ANNIE/resources/NE/temp.jape");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(temp, true), "UTF-8");
        BufferedWriter fbw = new BufferedWriter(writer);
        while ((currLine = reader.readLine()) != null) {
            String tmp = i == 0 ? currLine.substring(0, currLine.lastIndexOf(".")) : currLine;
            if (!tmp.equalsIgnoreCase(line)) {
                if (k > 1) {
                    fbw.write("\n");
                    fbw.write(currLine);
                } else {
                    fbw.write(currLine);
                }
            }
            ++k;
        }
        fbw.close();
        writer.close();
        reader.close();
        if (!file.delete()) {
            System.out.println(" -- Error in deleting file " + file.getName() + " -- ");
        }
        if (renamed = temp.renameTo(file)) {
            System.out.println("  * File '" + file.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + file.getName() + "' can not updated !");
        }
    }

    @Override
    public void updateCategoryBySet(String categoryName, Set<String> entries) throws CategoryNotFoundException, FileNotFoundException, IOException, XLinkIsOffException, EmptyListOfNamedEntitiesException {
        boolean renamed;
        String currLine;
        if (!this.checkForCategory(categoryName = categoryName.replace(" ", "_")) || !this.checkForCategoryInPropertiesFile(categoryName)) {
            throw new CategoryNotFoundException(categoryName);
        }
        if (entries == null || entries.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        categoryName = categoryName.toLowerCase();
        TreeSet<String> newSet = new TreeSet<String>();
        File tempR = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + categoryName + ".lst");
        File tempW = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/tempU.lst");
        BufferedReader reader = new BufferedReader(new FileReader(tempR));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempW));
        while ((currLine = reader.readLine()) != null) {
            newSet.add(currLine);
        }
        reader.close();
        newSet.addAll(entries);
        Iterator it = newSet.iterator();
        try {
            while (it.hasNext()) {
                writer.write(((String)it.next()).replaceAll("\"", ""));
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("4");
        }
        System.out.println("====================================================");
        if (!tempR.delete()) {
            System.out.println(" -- Error in deleting file " + tempR.getName() + " -- ");
        }
        if (renamed = tempW.renameTo(tempR)) {
            System.out.println("  * File '" + tempR.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + tempR.getName() + "' can not updated !");
        }
        System.out.println("====================================================");
        this.restart();
    }

    @Override
    public void updateCategoryBySingleEntity(String categoryName, String entity) throws CategoryNotFoundException, FileNotFoundException, IOException, XLinkIsOffException, EmptyListOfNamedEntitiesException {
        boolean renamed;
        String currLine;
        if (!this.checkForCategory(categoryName = categoryName.replace(" ", "_")) || !this.checkForCategoryInPropertiesFile(categoryName)) {
            throw new CategoryNotFoundException(categoryName);
        }
        if (entity == null) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        categoryName = categoryName.toLowerCase();
        TreeSet<String> newSet = new TreeSet<String>();
        File tempR = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + categoryName + ".lst");
        File tempW = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/tempU.lst");
        BufferedReader reader = new BufferedReader(new FileReader(tempR));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempW));
        while ((currLine = reader.readLine()) != null) {
            newSet.add(currLine);
        }
        reader.close();
        newSet.add(entity);
        Iterator it = newSet.iterator();
        try {
            while (it.hasNext()) {
                writer.write(((String)it.next()).replaceAll("\"", ""));
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("====================================================");
        if (!tempR.delete()) {
            System.out.println(" -- Error in deleting file " + tempR.getName() + " -- ");
        }
        if (renamed = tempW.renameTo(tempR)) {
            System.out.println("  * File '" + tempR.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + tempR.getName() + "' can not updated !");
        }
        System.out.println("====================================================");
        this.restart();
    }

    @Override
    public void printAvailableCategories() {
        System.out.println("# Available categories: ");
        for (Category category : this.categories) {
            System.out.println(" - " + category.getName());
        }
    }

    @Override
    public void restart() {
        System.out.println("# Restarting Gate...");
        String url = this.gateHomeUrl + "plugins/ANNIE";
        try {
            Gate.init();
            Gate.getCreoleRegister().registerDirectories(new URL(url));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (GateException ex2) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex2);
        }
        try {
            this.annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
        }
        catch (ResourceInstantiationException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            String[] tmp;
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
            prop.load(in);
            if (prop.getProperty("gr.forth.ics.xlink.gate.editDistance").equalsIgnoreCase("true")) {
                tmp = new String[]{"gate.creole.annotdelete.AnnotationDeletePR", "gate.creole.tokeniser.DefaultTokeniser", "bwp.gate.gazetteer.BWPGazetteer", "gate.creole.splitter.SentenceSplitter", "gate.creole.ANNIETransducer", "gate.creole.orthomatcher.OrthoMatcher"};
                Resources.ANNIE_CONSTANTS = tmp;
            } else {
                tmp = new String[]{"gate.creole.annotdelete.AnnotationDeletePR", "gate.creole.tokeniser.DefaultTokeniser", "gate.creole.gazetteer.DefaultGazetteer", "gate.creole.splitter.SentenceSplitter", "gate.creole.ANNIETransducer", "gate.creole.orthomatcher.OrthoMatcher"};
                Resources.ANNIE_CONSTANTS = tmp;
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex2) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex2);
        }
        for (int i = 0; i < Resources.ANNIE_CONSTANTS.length; ++i) {
            FeatureMap params = Factory.newFeatureMap();
            ProcessingResource pr = null;
            try {
                pr = (ProcessingResource)Factory.createResource((String)Resources.ANNIE_CONSTANTS[i], (FeatureMap)params);
            }
            catch (ResourceInstantiationException ex) {
                // empty catch block
            }
            this.annieController.add(pr);
        }
        System.out.println("# Gate was successfully restarted!");
    }

    private void readProperties(String propertiesFilePath) throws MalformedURLException, URISyntaxException, FileNotFoundException {
        String[] categoriesArray;
        String intancesTemplateQuery;
        String parameterClass;
        String parameterEntity;
        System.out.println("# Initializing X-Link Properties...");
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertiesFilePath);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            prop.load(in);
        }
        catch (IOException ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        String categoriesList = prop.getProperty("gr.forth.ics.xlink.resources.categories");
        Resources.TEMPLATE_GET_INSTANCES_QUERY = parameterEntity = prop.getProperty("gr.forth.ics.xlink.resources.categories.addcategory.getinstancestemplatequery");
        System.out.println("# ENTITY TEMPLATE PARAMETER: " + Resources.TEMPLATE_GET_INSTANCES_QUERY);
        Resources.TEMPLATE_ENTITY_PARAMETER = parameterClass = prop.getProperty("gr.forth.ics.xlink.resources.parameters.entity");
        System.out.println("# RESOURCE CLASS TEMPLATE PARAMETER: " + Resources.TEMPLATE_ENTITY_PARAMETER);
        Resources.TEMPLATE_RESOURCE_CLASS_PARAMETER = intancesTemplateQuery = prop.getProperty("gr.forth.ics.xlink.resources.parameters.resourceclass");
        System.out.println("# GET INSTANCE TEMPLATE QUERY: " + Resources.TEMPLATE_RESOURCE_CLASS_PARAMETER);
        for (String cat : categoriesArray = categoriesList.split(";")) {
            if ((cat = cat.trim()).equals("")) continue;
            Category category = new Category(cat);
            this.categories.add(category);
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            String categoryName = this.categories.get(i).getName();
            String possibleEndpointPropName = "gr.forth.ics.xlink.resources.categories." + categoryName + ".endpoint";
            String possibleTemplatePropName = "gr.forth.ics.xlink.resources.categories." + categoryName + ".template";
            String possibleResourceClass = "gr.forth.ics.xlink.resources.categories." + categoryName + ".resourceclass";
            String possibleSparqlQueryOfEntities = "gr.forth.ics.xlink.resources.categories." + categoryName + ".sparqlqueryofentities";
            String endpoint = prop.getProperty(possibleEndpointPropName);
            String template = prop.getProperty(possibleTemplatePropName);
            String resourceClass = prop.getProperty(possibleResourceClass);
            String sparqlQueryOfEntities = prop.getProperty(possibleSparqlQueryOfEntities);
            if (endpoint != null) {
                this.categories.get(i).setEndpoint(endpoint);
            }
            if (template != null) {
                this.categories.get(i).setTemplateQuery(template);
            }
            if (resourceClass != null) {
                this.categories.get(i).setResourceClass(resourceClass);
            }
            if (sparqlQueryOfEntities == null) continue;
            this.categories.get(i).setSparqlQueryFilepathOfEntities(sparqlQueryOfEntities);
        }
        for (Category cat : this.categories) {
            System.out.println("- " + cat.toString());
        }
        System.out.println("------");
    }

    public SerialAnalyserController getAnnieController() {
        return this.annieController;
    }

    public void setAnnieController(SerialAnalyserController annieController) {
        this.annieController = annieController;
    }

    public String getGateHome() {
        return this.gateHome;
    }

    public void setGateHome(String gateHome) {
        this.gateHome = gateHome;
    }

    public ArrayList<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(ArrayList<Category> categories) {
        this.categories = categories;
    }

    private boolean checkForCategory(String category) throws XLinkIsOffException {
        String temp;
        int i;
        File folder = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer");
        File[] listOfFiles = folder.listFiles();
        File folder2 = new File(this.gateHome + "plugins/ANNIE/resources/NE");
        File[] listOfFiles2 = folder2.listFiles();
        boolean found = false;
        if (listOfFiles == null) {
            throw new XLinkIsOffException();
        }
        for (i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            temp = listOfFiles[i].getName();
            if (!(temp = temp.substring(0, temp.indexOf("."))).equals(category.toLowerCase())) continue;
            found = true;
        }
        for (i = 0; i < listOfFiles2.length; ++i) {
            if (!listOfFiles2[i].isFile()) continue;
            temp = listOfFiles2[i].getName();
            if (!(temp = temp.substring(0, temp.indexOf("."))).equals(category.toLowerCase())) continue;
            found = true;
        }
        return found;
    }

    @Override
    public void replaceCategoryByQuery(String categoryName) throws CategoryNotFoundException, FileNotFoundException, UnsupportedEncodingException, CategoryAlreadyExistsException, IOException, XLinkIsOffException, IllegalCategoryNameException, NoProperCategoryNameException, NoGivenSPARQLEndpointException, NoGivenSparqlQueryFileException, EmptyListOfNamedEntitiesException {
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        if (!this.checkForCategory(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (category.getEndpoint() == null) {
            throw new NoGivenSPARQLEndpointException(temp);
        }
        if (category.getSparqlQueryFilepathOfEntities() == null) {
            throw new NoGivenSparqlQueryFileException(temp);
        }
        this.removeCategory(temp);
        category.retrieveNamedEntitiesByQuery();
        TreeSet<String> namedEntities = category.getNamedEntities();
        if (namedEntities == null || namedEntities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        this.addNewCategory(category);
    }

    @Override
    public void replaceCategoryByQuery(String categoryName, String sparqlQuery) throws CategoryNotFoundException, FileNotFoundException, UnsupportedEncodingException, CategoryAlreadyExistsException, IOException, XLinkIsOffException, IllegalCategoryNameException, NoProperCategoryNameException, NoGivenSPARQLEndpointException, NoGivenSparqlQueryFileException, EmptyListOfNamedEntitiesException {
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        System.out.println(category.toString());
        if (!this.checkForCategory(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (category.getEndpoint() == null) {
            throw new NoGivenSPARQLEndpointException(temp);
        }
        if (category.getSparqlQueryFilepathOfEntities() == null) {
            throw new NoGivenSparqlQueryFileException(temp);
        }
        this.removeCategory(temp);
        category.setSparqlQuery(sparqlQuery);
        category.retrieveNamedEntitiesByQuery();
        TreeSet<String> namedEntities = category.getNamedEntities();
        if (namedEntities == null || namedEntities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        this.addNewCategory(category);
    }

    @Override
    public void replaceCategoryByResourceClass(String categoryName) throws CategoryNotFoundException, FileNotFoundException, UnsupportedEncodingException, CategoryAlreadyExistsException, IOException, XLinkIsOffException, IllegalCategoryNameException, NoProperCategoryNameException, NoGivenResourceClassException, EmptyListOfNamedEntitiesException {
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        if (!this.checkForCategory(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (category.getResourceClass() == null) {
            throw new NoGivenResourceClassException(temp);
        }
        this.removeCategory(temp);
        category.retrieveNamedEntitiesByResourceClass();
        TreeSet<String> namedEntities = category.getNamedEntities();
        if (namedEntities == null || namedEntities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        this.addNewCategory(category);
    }

    @Override
    public void renameCategory(String oldCategory, String newCategory) throws CategoryNotFoundException, CategoryAlreadyExistsException, IOException, XLinkIsOffException, NoProperCategoryNameException, IllegalCategoryNameException {
        if (this.checkForIllegalCharacters(oldCategory)) {
            throw new IllegalCategoryNameException(oldCategory);
        }
        if (this.checkForIllegalCharacters(newCategory)) {
            throw new IllegalCategoryNameException(newCategory);
        }
        while (oldCategory.contains("  ")) {
            oldCategory = oldCategory.replace("  ", " ");
        }
        String oldCategoryAsGiven = oldCategory.replace(" ", "_");
        while (newCategory.contains("  ")) {
            newCategory = newCategory.replace("  ", " ");
        }
        String newCategoryAsGiven = newCategory.replace(" ", "_");
        oldCategory = oldCategoryAsGiven.toLowerCase();
        newCategory = newCategoryAsGiven.toLowerCase();
        if (!this.checkForCategoryInPropertiesFile(oldCategory)) {
            throw new CategoryNotFoundException(oldCategory);
        }
        if (!this.checkForCategory(oldCategory)) {
            throw new CategoryNotFoundException(oldCategory);
        }
        if (!oldCategory.equalsIgnoreCase(newCategory)) {
            if (this.checkForCategoryInPropertiesFile(newCategory)) {
                throw new CategoryAlreadyExistsException(newCategory);
            }
            if (this.checkForCategory(newCategory)) {
                throw new CategoryAlreadyExistsException(newCategory);
            }
            File category_lst = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + oldCategory + ".lst");
            File new_category_lst = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + newCategory + ".lst");
            File category_jape = new File(this.gateHome + "plugins/ANNIE/resources/NE/" + oldCategory + ".jape");
            File new_category_jape = new File(this.gateHome + "plugins/ANNIE/resources/NE/" + newCategory + ".jape");
            File file3 = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/lists.def");
            File file4 = new File(this.gateHome + "plugins/ANNIE/resources/NE/main.jape");
            boolean renamed = category_lst.renameTo(new_category_lst);
            System.out.println("====================================================");
            if (renamed) {
                System.out.println("  * File '" + category_lst.getName() + "' renamed to " + new_category_lst.getName() + " !");
            } else {
                System.out.println("  * File '" + category_lst.getName() + "' can not renamed to " + new_category_lst.getName() + " !");
            }
            category_jape.delete();
            this.createNewJapeFile(new_category_jape, newCategory);
            System.out.println("  * File '" + category_jape.getName() + "' renamed to " + new_category_jape.getName() + " !");
            this.renameLineInFile(file3, oldCategory, newCategory, 0);
            this.renameLineInFile(file4, oldCategory, newCategory, 1);
            System.out.println("====================================================");
            this.renameCategoryInPropertiesFile(oldCategory, newCategoryAsGiven);
        } else {
            this.renameCategoryInPropertiesFile(oldCategory, newCategoryAsGiven);
        }
        this.restart();
    }

    private void renameLineInFile(File file, String old_c, String new_c, int i) throws CategoryNotFoundException, CategoryAlreadyExistsException, IOException {
        boolean renamed;
        String currLine;
        int count = this.countLines(file);
        int k = 0;
        File temp = i == 0 ? new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/temp.def") : new File(this.gateHome + "plugins/ANNIE/resources/NE/temp.jape");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(temp, true), "UTF-8");
        BufferedWriter fbw = new BufferedWriter(writer);
        while ((currLine = reader.readLine()) != null) {
            ++k;
            if (currLine.startsWith(old_c)) {
                if (i == 0) {
                    String subString1 = currLine.substring(0, currLine.lastIndexOf("."));
                    String subString2 = currLine.substring(currLine.lastIndexOf("."), currLine.length());
                    String subString3 = subString2.substring(subString2.lastIndexOf(":") + 1, subString2.length());
                    if (subString1.equals(old_c)) {
                        currLine = new_c + ".lst:" + new_c;
                    }
                } else if (currLine.equals(old_c)) {
                    currLine = new_c;
                }
            }
            fbw.write(currLine);
            if (k > count - 1 || k == count) continue;
            fbw.write("\n");
        }
        fbw.close();
        writer.close();
        reader.close();
        if (!file.delete()) {
            System.out.println(" -- Error in deleting file " + file.getName() + " -- ");
        }
        if (renamed = temp.renameTo(file)) {
            System.out.println("  * File '" + file.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + file.getName() + "' can not updated !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countLines(File aFile) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(aFile));
            while (((LineNumberReader)reader).readLine() != null) {
            }
            int n = ((LineNumberReader)reader).getLineNumber();
            return n;
        }
        catch (Exception ex) {
            int n = -1;
            return n;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void removeCategoryFromPropertiesFile(String CategoryToRemove) throws FileNotFoundException, IOException {
        Category cat2 = null;
        for (Category cat1 : this.categories) {
            if (!cat1.getName().equalsIgnoreCase(CategoryToRemove)) continue;
            cat2 = cat1;
        }
        Properties prop = new Properties();
        FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
        prop.load(in);
        String propertyValue = "";
        Set<Object> keySet = prop.keySet();
        TreeSet<Object> obj2 = new TreeSet<Object>();
        for (Object obj : keySet) {
            String subString;
            if (obj.toString().length() < 40 + CategoryToRemove.length() || !(subString = obj.toString().substring(40, 40 + CategoryToRemove.length())).equalsIgnoreCase(CategoryToRemove)) continue;
            obj2.add(obj);
        }
        for (Object tmp : obj2) {
            prop.remove(tmp);
        }
        this.categories.remove(cat2);
        for (Category cat : this.categories) {
            String categoryName = cat.getName();
            propertyValue = propertyValue + categoryName.trim();
            propertyValue = propertyValue + ";";
        }
        prop.setProperty("gr.forth.ics.xlink.resources.categories", propertyValue.substring(0, propertyValue.length() - 1));
        for (Category cat : this.categories) {
            if (cat.getEndpoint() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".endpoint", cat.getEndpoint());
            }
            if (cat.getResourceClass() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".resourceclass", cat.getResourceClass());
            }
            if (cat.getSparqlQueryFilepathOfEntities() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".sparqlqueryofentities", cat.getSparqlQueryFilepathOfEntities());
            }
            if (cat.getTemplateQuery() == null) continue;
            prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".template", cat.getTemplateQuery());
        }
        prop.store(new FileOutputStream(new File(this.gateHome + "x-link.properties")), "X-Link Properties");
        System.out.println(" =================================== ");
        System.out.println("  File 'x-link.properties' updated! ");
        System.out.println(" =================================== ");
    }

    private void deleteTemplateFiles(String category) {
        String currentDir = System.getProperty("user.dir");
        currentDir = currentDir.substring(0, currentDir.lastIndexOf("/") + 1);
        currentDir = currentDir.substring(0, currentDir.lastIndexOf("/") + 1);
        File folder = new File(currentDir + "sparql/templates");
        File[] listOfFiles = folder.listFiles();
        boolean deleted = false;
        category = category.toLowerCase();
        for (int i = 0; i < listOfFiles.length; ++i) {
            File forDelete;
            if (!listOfFiles[i].isFile()) continue;
            String temp = listOfFiles[i].getName();
            if ((temp = temp.substring(0, temp.indexOf("."))).equalsIgnoreCase(category)) {
                forDelete = new File(currentDir + "sparql/templates/" + category + ".template");
                deleted = forDelete.delete();
            }
            if (temp.equalsIgnoreCase(category + "URI")) {
                forDelete = new File(currentDir + "sparql/templates/" + category + "URI.template");
                deleted = forDelete.delete();
            }
            if (!temp.equalsIgnoreCase(category + "Template")) continue;
            forDelete = new File(currentDir + "sparql/templates/" + category + "Template.template");
            deleted = forDelete.delete();
        }
    }

    private void renameTemplateFiles(String oldCategory, String newCategory) {
        String currentDir = System.getProperty("user.dir");
        currentDir = currentDir.substring(0, currentDir.lastIndexOf("/") + 1);
        currentDir = currentDir.substring(0, currentDir.lastIndexOf("/") + 1);
        oldCategory = oldCategory.replace(" ", "_").toLowerCase();
        newCategory = newCategory.replace(" ", "_").toLowerCase();
        File folder = new File(currentDir + "sparql/templates");
        File[] listOfFiles = folder.listFiles();
        boolean renamed = false;
        for (int i = 0; i < listOfFiles.length; ++i) {
            File temp_t;
            File forRename;
            if (!listOfFiles[i].isFile()) continue;
            String temp = listOfFiles[i].getName();
            if ((temp = temp.substring(0, temp.indexOf("."))).equalsIgnoreCase(oldCategory)) {
                forRename = new File(currentDir + "sparql/templates/" + oldCategory + ".template");
                temp_t = new File(currentDir + "sparql/templates/" + newCategory + ".template");
                forRename.renameTo(temp_t);
            }
            if (temp.equalsIgnoreCase(oldCategory + "URI")) {
                forRename = new File(currentDir + "sparql/templates/" + oldCategory + "URI.template");
                temp_t = new File(currentDir + "sparql/templates/" + newCategory + "URI.template");
                forRename.renameTo(temp_t);
            }
            if (!temp.equalsIgnoreCase(oldCategory + "Template")) continue;
            forRename = new File(currentDir + "sparql/templates/" + oldCategory + "Template.template");
            temp_t = new File(currentDir + "sparql/templates/" + newCategory + "Template.template");
            forRename.renameTo(temp_t);
        }
    }

    private void renameCategoryInPropertiesFile(String oldCategory, String newCategory) throws IOException {
        Category cat2 = null;
        for (Category cat1 : this.categories) {
            if (!cat1.getName().equalsIgnoreCase(oldCategory)) continue;
            cat2 = cat1;
        }
        Properties prop = new Properties();
        FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
        prop.load(in);
        String propertyValue = "";
        Set<Object> keySet = prop.keySet();
        TreeSet<Object> obj2 = new TreeSet<Object>();
        for (Object obj : keySet) {
            String subString;
            if (obj.toString().length() < 40 + oldCategory.length() || !(subString = obj.toString().substring(40, 40 + oldCategory.length())).equalsIgnoreCase(oldCategory)) continue;
            obj2.add(obj);
        }
        for (Object tmp : obj2) {
            prop.remove(tmp);
        }
        if (cat2 != null) {
            this.categories.remove(cat2);
            cat2.setName(newCategory);
            this.categories.add(cat2);
        }
        for (Category cat : this.categories) {
            String categoryName = cat.getName();
            propertyValue = propertyValue + categoryName.trim();
            propertyValue = propertyValue + ";";
        }
        prop.setProperty("gr.forth.ics.xlink.resources.categories", propertyValue.substring(0, propertyValue.length() - 1));
        for (Category cat : this.categories) {
            if (cat.getEndpoint() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".endpoint", cat.getEndpoint());
            }
            if (cat.getResourceClass() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".resourceclass", cat.getResourceClass());
            }
            if (cat.getSparqlQueryFilepathOfEntities() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".sparqlqueryofentities", cat.getSparqlQueryFilepathOfEntities());
            }
            if (cat.getTemplateQuery() == null) continue;
            prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".template", cat.getTemplateQuery());
        }
        prop.store(new FileOutputStream(new File(this.gateHome + "x-link.properties")), "X-Link Properties");
        System.out.println(" =================================== ");
        System.out.println("  File 'x-link.properties' updated! ");
        System.out.println(" =================================== ");
    }

    private void createNewJapeFile(File file, String name) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8");
        BufferedWriter fbw = new BufferedWriter(writer);
        fbw.write("Phase:\t" + name + "\n" + "Input: Lookup Token\n" + "Options: control = appelt\n" + "\n" + "Rule: " + name + "\n" + "(\n" + " {Lookup.majorType == " + name + "}\n" + ")\n" + ":" + name + "\n" + "-->\n" + " :" + name + "." + name + " = {rule = \"" + name + "\"}");
        fbw.close();
        writer.close();
    }

    private boolean checkForCategoryInPropertiesFile(String categoryName) {
        for (Category cat1 : this.categories) {
            if (!cat1.getName().equalsIgnoreCase(categoryName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void changeCategoryAttributes(String category, String newEndpoint, String newTemplatePath, String newSparqlQueryofEntitiesPath, String newResourceClass) throws IOException, CategoryNotFoundException, MalformedURLException, URISyntaxException {
        if (!this.checkForCategoryInPropertiesFile(category)) {
            throw new CategoryNotFoundException(category);
        }
        Category cat2 = null;
        for (Category cat1 : this.categories) {
            if (!cat1.getName().equalsIgnoreCase(category)) continue;
            cat2 = cat1;
        }
        Properties prop = new Properties();
        FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
        prop.load(in);
        String propertyValue = "";
        Set<Object> keySet = prop.keySet();
        TreeSet<Object> obj2 = new TreeSet<Object>();
        for (Object obj : keySet) {
            String subString;
            if (obj.toString().length() <= 41 + category.length() || !(subString = obj.toString().substring(40, 40 + category.length())).equalsIgnoreCase(category)) continue;
            obj2.add(obj);
        }
        for (Object tmp : obj2) {
            prop.remove(tmp);
        }
        if (cat2 != null) {
            String temp = cat2.getName();
            this.categories.remove(cat2);
            cat2.setName(temp);
            if (newEndpoint != null) {
                cat2.setEndpoint(newEndpoint);
            }
            if (newTemplatePath != null) {
                cat2.setTemplateQuery(newTemplatePath);
            }
            if (newSparqlQueryofEntitiesPath != null) {
                cat2.setSparqlQueryFilepathOfEntities(newSparqlQueryofEntitiesPath);
            }
            if (newResourceClass != null) {
                cat2.setResourceClass(newResourceClass);
            }
            this.categories.add(cat2);
        }
        for (Category cat : this.categories) {
            String categoryName = cat.getName();
            propertyValue = propertyValue + categoryName.trim();
            propertyValue = propertyValue + ";";
        }
        prop.setProperty("gr.forth.ics.xlink.resources.categories", propertyValue.substring(0, propertyValue.length() - 1));
        for (Category cat : this.categories) {
            if (cat.getEndpoint() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".endpoint", cat.getEndpoint());
            }
            if (cat.getResourceClass() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".resourceclass", cat.getResourceClass());
            }
            if (cat.getSparqlQueryFilepathOfEntities() != null) {
                prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".sparqlqueryofentities", cat.getSparqlQueryFilepathOfEntities());
            }
            if (cat.getTemplateQuery() == null) continue;
            prop.setProperty("gr.forth.ics.xlink.resources.categories." + cat.getName() + ".template", cat.getTemplateQuery());
        }
        prop.store(new FileOutputStream(new File(this.gateHome + "x-link.properties")), "X-Link Properties");
        System.out.println(" =================================== ");
        System.out.println("  File 'x-link.properties' updated! ");
        System.out.println(" =================================== ");
        this.restart();
    }

    private boolean checkForIllegalCharacters(String categoryName) {
        String[] special_char = new String[]{"`", "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "+", "=", "\u20ac", ",", "[", "{", "}", "]", "/", "|", ";", ":", "'", "\"", "<", ">", ".", "?", "/"};
        for (int i = 0; i < special_char.length; ++i) {
            if (!categoryName.contains(special_char[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void replaceCategoryBySet(String categoryName, Set<String> entities) throws CategoryNotFoundException, XLinkIsOffException, FileNotFoundException, UnsupportedEncodingException, IOException, CategoryAlreadyExistsException, IllegalCategoryNameException, NoProperCategoryNameException, EmptyListOfNamedEntitiesException {
        boolean renamed;
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Object category = null;
        if (!this.checkForCategory(temp) || !this.checkForCategoryInPropertiesFile(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (entities == null || entities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        TreeSet<String> newSet = new TreeSet<String>();
        File tempR = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + temp + ".lst");
        File tempW = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/tempU.lst");
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempW));
        newSet.addAll(entities);
        Iterator it = newSet.iterator();
        try {
            while (it.hasNext()) {
                writer.write(((String)it.next()).replaceAll("\"", ""));
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("====================================================");
        if (!tempR.delete()) {
            System.out.println(" -- Error in deleting file " + tempR.getName() + " -- ");
        }
        if (renamed = tempW.renameTo(tempR)) {
            System.out.println("  * File '" + tempR.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + tempR.getName() + "' can not updated !");
        }
        System.out.println("====================================================");
        this.restart();
    }

    @Override
    public void updateCategoryByQuery(String categoryName) throws XLinkIsOffException, CategoryNotFoundException, NoGivenSPARQLEndpointException, NoGivenSparqlQueryFileException, FileNotFoundException, IOException, EmptyListOfNamedEntitiesException {
        boolean renamed;
        String currLine;
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        if (!this.checkForCategory(temp) || !this.checkForCategoryInPropertiesFile(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (category.getEndpoint() == null) {
            throw new NoGivenSPARQLEndpointException(temp);
        }
        if (category.getSparqlQueryFilepathOfEntities() == null) {
            throw new NoGivenSparqlQueryFileException(temp);
        }
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        category.retrieveNamedEntitiesByQuery();
        TreeSet<String> namedEntities = category.getNamedEntities();
        if (namedEntities == null || namedEntities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        TreeSet<String> newSet = new TreeSet<String>();
        File tempR = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + temp + ".lst");
        File tempW = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/tempU.lst");
        BufferedReader reader = new BufferedReader(new FileReader(tempR));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempW));
        while ((currLine = reader.readLine()) != null) {
            newSet.add(currLine);
        }
        reader.close();
        newSet.addAll(category.getNamedEntities());
        Iterator it = newSet.iterator();
        try {
            while (it.hasNext()) {
                writer.write((String)it.next());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("====================================================");
        if (!tempR.delete()) {
            System.out.println(" -- Error in deleting file " + tempR.getName() + " -- ");
        }
        if (renamed = tempW.renameTo(tempR)) {
            System.out.println("  * File '" + tempR.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + tempR.getName() + "' can not updated !");
        }
        System.out.println("====================================================");
        this.restart();
    }

    @Override
    public void updateCategoryByQuery(String categoryName, String sparqlQuery) throws XLinkIsOffException, CategoryNotFoundException, NoGivenSPARQLEndpointException, NoGivenSparqlQueryFileException, FileNotFoundException, IOException, EmptyListOfNamedEntitiesException {
        boolean renamed;
        String currLine;
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        if (!this.checkForCategory(temp) || !this.checkForCategoryInPropertiesFile(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (category.getEndpoint() == null) {
            throw new NoGivenSPARQLEndpointException(temp);
        }
        if (category.getSparqlQueryFilepathOfEntities() == null) {
            throw new NoGivenSparqlQueryFileException(temp);
        }
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        category.retrieveNamedEntitiesByQuery();
        TreeSet<String> namedEntities = category.getNamedEntities();
        if (namedEntities == null || namedEntities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        TreeSet<String> newSet = new TreeSet<String>();
        File tempR = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + temp + ".lst");
        File tempW = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/tempU.lst");
        BufferedReader reader = new BufferedReader(new FileReader(tempR));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempW));
        while ((currLine = reader.readLine()) != null) {
            newSet.add(currLine);
        }
        reader.close();
        newSet.addAll(category.getNamedEntities());
        Iterator it = newSet.iterator();
        try {
            while (it.hasNext()) {
                writer.write((String)it.next());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("====================================================");
        if (!tempR.delete()) {
            System.out.println(" -- Error in deleting file " + tempR.getName() + " -- ");
        }
        if (renamed = tempW.renameTo(tempR)) {
            System.out.println("  * File '" + tempR.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + tempR.getName() + "' can not updated !");
        }
        System.out.println("====================================================");
        this.restart();
    }

    @Override
    public void updateCategoryByResourceClass(String categoryName) throws FileNotFoundException, IOException, CategoryNotFoundException, XLinkIsOffException, NoGivenResourceClassException, EmptyListOfNamedEntitiesException {
        boolean renamed;
        String currLine;
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        if (!this.checkForCategory(temp) || !this.checkForCategoryInPropertiesFile(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        if (category.getResourceClass() == null) {
            throw new NoGivenResourceClassException(temp);
        }
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        category.retrieveNamedEntitiesByResourceClass();
        TreeSet<String> namedEntities = category.getNamedEntities();
        if (namedEntities == null || namedEntities.isEmpty()) {
            throw new EmptyListOfNamedEntitiesException(categoryName);
        }
        TreeSet<String> newSet = new TreeSet<String>();
        File tempR = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/" + temp + ".lst");
        File tempW = new File(this.gateHome + "plugins/ANNIE/resources/gazetteer/tempU.lst");
        BufferedReader reader = new BufferedReader(new FileReader(tempR));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempW));
        while ((currLine = reader.readLine()) != null) {
            newSet.add(currLine);
        }
        reader.close();
        newSet.addAll(category.getNamedEntities());
        Iterator it = newSet.iterator();
        try {
            while (it.hasNext()) {
                writer.write((String)it.next());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            Logger.getLogger(GateEntityMiningComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("====================================================");
        if (!tempR.delete()) {
            System.out.println(" -- Error in deleting file " + tempR.getName() + " -- ");
        }
        if (renamed = tempW.renameTo(tempR)) {
            System.out.println("  * File '" + tempR.getName() + "' updated !");
        } else {
            System.out.println("  * File '" + tempR.getName() + "' can not updated !");
        }
        System.out.println("====================================================");
        this.restart();
    }

    @Override
    public Category getCategory(String categoryName) throws CategoryNotFoundException {
        String temp = categoryName.replace(" ", "_").toLowerCase();
        Category category = null;
        if (!this.checkForCategoryInPropertiesFile(temp)) {
            throw new CategoryNotFoundException(temp);
        }
        for (Category tmp : this.categories) {
            if (!tmp.getName().equalsIgnoreCase(temp)) continue;
            category = tmp;
        }
        return category;
    }

    @Override
    public void changeEditDistanceValue(Double value) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
        prop.load(in);
        File xmlFile = new File(this.gateHome + "plugins/ANNIE/creole.xml");
        BufferedReader br = new BufferedReader(new FileReader(xmlFile));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.contains("<PARAMETER \tDEFAULT=\"" + prop.getProperty("gr.forth.ics.xlink.gate.editDistance.value") + "\"")) {
                line = line.replace("<PARAMETER \tDEFAULT=\"" + prop.getProperty("gr.forth.ics.xlink.gate.editDistance.value") + "\"", "<PARAMETER \tDEFAULT=\"" + value + "\"");
            }
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        BufferedWriter bw = new BufferedWriter(new FileWriter(xmlFile));
        bw.write(sb.toString());
        bw.close();
        Set<Object> keySet = prop.keySet();
        Object tmp = null;
        for (Object obj : keySet) {
            if (!obj.toString().equals("gr.forth.ics.xlink.gate.editDistance.value")) continue;
            tmp = obj;
        }
        prop.remove(tmp);
        prop.setProperty("gr.forth.ics.xlink.gate.editDistance.value", value.toString());
        prop.store(new FileOutputStream(new File(this.gateHome + "x-link.properties")), "X-Link Properties");
        this.restart();
    }

    @Override
    public void changeEditDistance(boolean usage) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        FileInputStream in = new FileInputStream(this.gateHome + "x-link.properties");
        prop.load(in);
        Set<Object> keySet = prop.keySet();
        Object tmp = null;
        for (Object obj : keySet) {
            if (!obj.toString().equals("gr.forth.ics.xlink.gate.editDistance")) continue;
            tmp = obj;
        }
        prop.remove(tmp);
        String temp = usage ? "true" : "false";
        prop.setProperty("gr.forth.ics.xlink.gate.editDistance", temp);
        prop.store(new FileOutputStream(new File(this.gateHome + "x-link.properties")), "X-Link Properties");
        this.restart();
    }
}

