/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.FeatureMap;
import gate.corpora.RepositioningInfo;
import gr.forth.ics.isl.xlink.Entity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mine {
    private ArrayList<Entity> entities = new ArrayList();

    protected Mine(Corpus corpus, Set<String> acceptedCategories) {
        this.setEntities(corpus, acceptedCategories);
    }

    private void setEntities(Corpus corpus, Set<String> acceptedCategories) {
        Iterator iter = corpus.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Document doc = (Document)iter.next();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            AnnotationSet annotSet = defaultAnnotSet.get(acceptedCategories);
            FeatureMap features = doc.getFeatures();
            String originalContent = (String)features.get((Object)"Original_document_content_on_load");
            RepositioningInfo info = (RepositioningInfo)features.get((Object)"Document_repositioning_info");
            if (originalContent != null) {
                this.readEntities(annotSet, originalContent, info);
                ++i;
                continue;
            }
            System.out.println("### ORIGINAL CONTENT IS NULL! ###");
            System.out.println("\t- Content : " + originalContent);
            System.out.println("\t- Repositioning: " + info);
        }
    }

    private void readEntities(AnnotationSet annotationSet, String originalContent, RepositioningInfo info) {
        StringBuilder editableContent = new StringBuilder(originalContent);
        for (Annotation currAnnot : annotationSet) {
            int pos;
            String str;
            long insertPositionStart = currAnnot.getStartNode().getOffset();
            long insertPositionEnd = currAnnot.getEndNode().getOffset();
            if (info != null) {
                insertPositionStart = info.getOriginalPos(insertPositionStart);
                insertPositionEnd = info.getOriginalPos(insertPositionEnd, true);
            }
            if (insertPositionEnd == -1L || insertPositionStart == -1L || (str = editableContent.substring((int)insertPositionStart, (int)insertPositionEnd)).contains("<") || str.contains(">")) continue;
            while (str.contains("\n")) {
                str = str.replace("\n", " ");
            }
            str = str.replace("\t", " ");
            while ((pos = str.indexOf("  ")) > -1) {
                str = str.substring(0, pos) + str.substring(pos + 1);
            }
            if ((str = str.trim()).length() < 2 || str.equals("amp")) continue;
            boolean find_no_asci = false;
            for (int k = 0; k < str.length(); ++k) {
                if (str.charAt(k) >= ' ' && str.charAt(k) < '\u007f') continue;
                find_no_asci = true;
                break;
            }
            if (find_no_asci) continue;
            String categoryName = currAnnot.getType();
            Entity entity = new Entity(str);
            entity.setCategoryName(categoryName);
            boolean already = false;
            for (int i = 0; i < this.entities.size(); ++i) {
                Entity e = this.entities.get(i);
                if (!e.getName().toLowerCase().equals(str.toLowerCase()) || !e.getCategoryName().toLowerCase().equals(categoryName.toLowerCase())) continue;
                already = true;
                this.entities.get(i).increaseNumOfOccurrences();
                break;
            }
            if (already) continue;
            this.entities.add(entity);
        }
    }

    protected ArrayList<Entity> getEntities() {
        return this.entities;
    }

    protected void setEntities(ArrayList<Entity> entities) {
        this.entities = entities;
    }
}

