/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.resultexporter;

import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.resultexporter.ResultExporter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExporter
implements ResultExporter {
    private String filepath;
    private ArrayList<Entity> entities;

    public CSVExporter(String filepath, ArrayList<Entity> entities) throws FalseFileTypeException {
        this.filepath = filepath;
        this.entities = entities;
        if (!filepath.endsWith("csv")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    @Override
    public void exportResults() {
        try {
            FileWriter fw = new FileWriter(this.filepath);
            PrintWriter out = new PrintWriter(fw);
            out.print("Entity_Name");
            out.print(";");
            out.print("Category");
            out.print(";");
            out.print("URIs");
            out.print(";");
            out.print("Rank");
            out.print(";");
            out.print("Number of Occurrences");
            out.println();
            out.println();
            for (Entity entity : this.entities) {
                Set<String> matchingURIs = entity.getMatchingURIs();
                if (matchingURIs.isEmpty()) {
                    out.print(entity.getName());
                    out.print(";");
                    out.print(entity.getCategoryName());
                    out.print(";");
                    out.print(";");
                    out.print(entity.getRank());
                    out.print(";");
                    out.print(entity.getNumOfOccurrences());
                    out.println();
                    continue;
                }
                for (String uri : matchingURIs) {
                    out.print(entity.getName());
                    out.print(";");
                    out.print(entity.getCategoryName());
                    out.print(";");
                    out.print(uri);
                    out.print(";");
                    out.print(entity.getRank());
                    out.print(";");
                    out.print(entity.getNumOfOccurrences());
                    out.println();
                }
            }
            out.flush();
            out.close();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CSVExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

