/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.resultexporter;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.resultexporter.RDFExporter;
import gr.forth.ics.isl.xlink.resultexporter.ResultExporter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NTriplesExporter
implements ResultExporter {
    private String filepath;
    private ArrayList<Entity> entities;

    public NTriplesExporter(String filepath, ArrayList<Entity> entities) throws FalseFileTypeException {
        this.filepath = filepath;
        this.entities = entities;
        if (!filepath.endsWith("nt")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    @Override
    public void exportResults() {
        String tmp = "http://localhost/Entity/";
        try {
            Model model = ModelFactory.createDefaultModel();
            model.setNsPrefix("Entity", tmp);
            for (Entity entity : this.entities) {
                Resource resource = model.createResource("http://localhost/" + entity.getName());
                Property entity_name = model.createProperty(tmp, "entity_name");
                Property category = model.createProperty(tmp + "category");
                Property rank = model.createProperty(tmp + "rank");
                Property number_of_occurrences = model.createProperty(tmp + "number_of_occurrences");
                Property uris = model.createProperty(tmp + "uris");
                resource.addProperty(entity_name, entity.getName());
                resource.addProperty(category, entity.getCategoryName());
                resource.addProperty(rank, Double.toString(entity.getRank()));
                resource.addProperty(number_of_occurrences, Integer.toString(entity.getNumOfOccurrences()));
                for (String temp : entity.getMatchingURIs()) {
                    resource.addProperty(uris, temp);
                }
            }
            FileOutputStream fout = new FileOutputStream(this.filepath);
            model.write((OutputStream)fout, "N-TRIPLES");
        }
        catch (Exception e) {
            Logger.getLogger(RDFExporter.class.getName()).log(Level.SEVERE, null, e);
        }
    }
}

